/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.UdpChannelTransport;
import io.aeron.driver.media.UdpTransportPoller;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import org.agrona.LangUtil;
import org.agrona.collections.ArrayUtil;

public class DataTransportPoller
extends UdpTransportPoller {
    private ReceiveChannelEndpoint[] transports = new ReceiveChannelEndpoint[0];

    @Override
    public int pollTransports() {
        int bytesReceived = 0;
        try {
            if (this.transports.length <= 5) {
                for (ReceiveChannelEndpoint transport : this.transports) {
                    bytesReceived += transport.pollForData();
                }
            } else {
                this.selector.selectNow();
                SelectionKey[] keys = this.selectedKeySet.keys();
                int length = this.selectedKeySet.size();
                for (int i = 0; i < length; ++i) {
                    bytesReceived += ((ReceiveChannelEndpoint)keys[i].attachment()).pollForData();
                }
                this.selectedKeySet.reset();
            }
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return bytesReceived;
    }

    @Override
    public SelectionKey registerForRead(UdpChannelTransport transport) {
        return this.registerForRead((ReceiveChannelEndpoint)transport);
    }

    public SelectionKey registerForRead(ReceiveChannelEndpoint transport) {
        SelectionKey key = null;
        try {
            this.transports = (ReceiveChannelEndpoint[])ArrayUtil.add((Object[])this.transports, (Object)transport);
            key = transport.receiveDatagramChannel().register(this.selector, 1, transport);
        }
        catch (ClosedChannelException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return key;
    }

    @Override
    public void cancelRead(UdpChannelTransport transport) {
        this.cancelRead((ReceiveChannelEndpoint)transport);
    }

    public void cancelRead(ReceiveChannelEndpoint transport) {
        this.transports = (ReceiveChannelEndpoint[])ArrayUtil.remove((Object[])this.transports, (Object)transport);
    }
}

