/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.DataPacketDispatcher;
import io.aeron.driver.EventLog;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.PublicationImage;
import io.aeron.driver.exceptions.ConfigurationException;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.media.UdpChannelTransport;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.protocol.DataHeaderFlyweight;
import io.aeron.protocol.NakFlyweight;
import io.aeron.protocol.SetupFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import org.agrona.LangUtil;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.collections.MutableInteger;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;

@EventLog
public class ReceiveChannelEndpoint
extends UdpChannelTransport {
    private final DataPacketDispatcher dispatcher;
    private final AtomicCounter statusMessageShortSends;
    private final AtomicCounter nakMessageShortSends;
    private final AtomicCounter invalidPackets;
    private final AtomicCounter possibleTtlAsymmetry;
    private final ByteBuffer smBuffer = ByteBuffer.allocateDirect(28);
    private final StatusMessageFlyweight smHeader = new StatusMessageFlyweight(this.smBuffer);
    private final ByteBuffer nakBuffer = ByteBuffer.allocateDirect(28);
    private final NakFlyweight nakHeader = new NakFlyweight(this.nakBuffer);
    private final SetupFlyweight setupHeader;
    private final DataHeaderFlyweight dataHeader;
    private final Int2ObjectHashMap<MutableInteger> refCountByStreamIdMap = new Int2ObjectHashMap();
    private volatile boolean isClosed = false;

    public ReceiveChannelEndpoint(UdpChannel udpChannel, DataPacketDispatcher dispatcher, MediaDriver.Context context) {
        super(udpChannel, udpChannel.remoteData(), udpChannel.remoteData(), null, context.errorLog());
        this.smHeader.version((short)0).headerType(3).frameLength(28);
        this.nakHeader.version((short)0).headerType(2).frameLength(28);
        this.dataHeader = new DataHeaderFlyweight(this.receiveBuffer);
        this.setupHeader = new SetupFlyweight(this.receiveBuffer);
        this.dispatcher = dispatcher;
        this.statusMessageShortSends = context.systemCounters().get(SystemCounterDescriptor.STATUS_MESSAGE_SHORT_SENDS);
        this.nakMessageShortSends = context.systemCounters().get(SystemCounterDescriptor.NAK_MESSAGE_SHORT_SENDS);
        this.invalidPackets = context.systemCounters().get(SystemCounterDescriptor.INVALID_PACKETS);
        this.possibleTtlAsymmetry = context.systemCounters().get(SystemCounterDescriptor.POSSIBLE_TTL_ASYMMETRY);
    }

    public int sendTo(ByteBuffer buffer, InetSocketAddress remoteAddress) {
        int bytesSent = 0;
        try {
            bytesSent = this.sendDatagramChannel.send(buffer, remoteAddress);
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return bytesSent;
    }

    public String originalUriString() {
        return this.udpChannel().originalUriString();
    }

    @Override
    public void close() {
        super.close();
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void openChannel() {
        this.openDatagramChannel();
    }

    public void possibleTelAsymmetryEncountered() {
        this.possibleTtlAsymmetry.orderedIncrement();
    }

    public int incRefToStream(int streamId) {
        MutableInteger count = (MutableInteger)this.refCountByStreamIdMap.get(streamId);
        if (null == count) {
            count = new MutableInteger();
            this.refCountByStreamIdMap.put(streamId, (Object)count);
        }
        ++count.value;
        return count.value;
    }

    public int decRefToStream(int streamId) {
        MutableInteger count = (MutableInteger)this.refCountByStreamIdMap.get(streamId);
        if (null == count) {
            throw new IllegalStateException("Could not find stream Id to decrement: " + streamId);
        }
        --count.value;
        if (0 == count.value) {
            this.refCountByStreamIdMap.remove(streamId);
        }
        return count.value;
    }

    public int streamCount() {
        return this.refCountByStreamIdMap.size();
    }

    public int onDataPacket(DataHeaderFlyweight header, UnsafeBuffer buffer, int length, InetSocketAddress srcAddress) {
        return this.dispatcher.onDataPacket(this, header, buffer, length, srcAddress);
    }

    public void onSetupMessage(SetupFlyweight header, UnsafeBuffer buffer, InetSocketAddress srcAddress) {
        this.dispatcher.onSetupMessage(this, header, buffer, srcAddress);
    }

    public void sendSetupElicitingStatusMessage(InetSocketAddress controlAddress, int sessionId, int streamId) {
        this.sendStatusMessage(controlAddress, sessionId, streamId, 0, 0, 0, (short)128);
    }

    public void validateWindowMaxLength(int windowMaxLength) {
        int soRcvbuf = this.getOption(StandardSocketOptions.SO_RCVBUF);
        if (windowMaxLength > soRcvbuf) {
            throw new ConfigurationException(String.format("Max Window length greater than socket SO_RCVBUF, increase %s to match window: windowMaxLength=%d, SO_RCVBUF=%d", "aeron.rcv.initial.window.length", windowMaxLength, soRcvbuf));
        }
    }

    public void validateSenderMtuLength(int senderMtuLength) {
        int soRcvbuf = this.getOption(StandardSocketOptions.SO_RCVBUF);
        if (senderMtuLength > soRcvbuf) {
            throw new ConfigurationException(String.format("Sender MTU greater than socket SO_RCVBUF, increase %s to match MTU: senderMtuLength=%d, SO_RCVBUF=%d", "aeron.socket.so_rcvbuf", senderMtuLength, soRcvbuf));
        }
        int capacity = this.receiveBufferCapacity();
        if (senderMtuLength > capacity) {
            throw new ConfigurationException(String.format("Sender MTU greater than receive buffer capacity, increase %s to match MTU: senderMtuLength=%d, capacity=%d", "aeron.rcv.buffer.length", senderMtuLength, capacity));
        }
    }

    public void sendStatusMessage(InetSocketAddress controlAddress, int sessionId, int streamId, int termId, int termOffset, int window, short flags) {
        if (!this.isClosed) {
            this.smBuffer.clear();
            this.smHeader.sessionId(sessionId).streamId(streamId).consumptionTermId(termId).consumptionTermOffset(termOffset).receiverWindowLength(window).flags(flags);
            int bytesSent = this.sendTo(this.smBuffer, controlAddress);
            if (28 != bytesSent) {
                this.statusMessageShortSends.orderedIncrement();
            }
        }
    }

    public void sendNakMessage(InetSocketAddress controlAddress, int sessionId, int streamId, int termId, int termOffset, int length) {
        if (!this.isClosed) {
            this.nakBuffer.clear();
            this.nakHeader.streamId(streamId).sessionId(sessionId).termId(termId).termOffset(termOffset).length(length);
            int bytesSent = this.sendTo(this.nakBuffer, controlAddress);
            if (28 != bytesSent) {
                this.nakMessageShortSends.orderedIncrement();
            }
        }
    }

    @Override
    public int pollForData() {
        int bytesReceived = 0;
        InetSocketAddress srcAddress = this.receive();
        if (null != srcAddress) {
            int length = this.receiveByteBuffer.position();
            if (this.isValidFrame(this.receiveBuffer, length)) {
                bytesReceived = this.dispatch(this.receiveBuffer, length, srcAddress);
            } else {
                this.invalidPackets.orderedIncrement();
            }
        }
        return bytesReceived;
    }

    public void removePendingSetup(int sessionId, int streamId) {
        this.dispatcher.removePendingSetup(sessionId, streamId);
    }

    public void removePublicationImage(PublicationImage publicationImage) {
        this.dispatcher.removePublicationImage(publicationImage);
    }

    public void addSubscription(int streamId) {
        this.dispatcher.addSubscription(streamId);
    }

    public void removeSubscription(int streamId) {
        this.dispatcher.removeSubscription(streamId);
    }

    public void addPublicationImage(PublicationImage image) {
        this.dispatcher.addPublicationImage(image);
    }

    public void removeCoolDown(int sessionId, int streamId) {
        this.dispatcher.removeCoolDown(sessionId, streamId);
    }

    protected int dispatch(UnsafeBuffer buffer, int length, InetSocketAddress srcAddress) {
        int bytesReceived = 0;
        switch (FrameDescriptor.frameType((UnsafeBuffer)buffer, (int)0)) {
            case 0: 
            case 1: {
                bytesReceived = this.dispatcher.onDataPacket(this, this.dataHeader, buffer, length, srcAddress);
                break;
            }
            case 5: {
                this.dispatcher.onSetupMessage(this, this.setupHeader, buffer, srcAddress);
            }
        }
        return bytesReceived;
    }
}

