/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.EventLog;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.media.UdpChannelTransport;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.protocol.NakFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import org.agrona.LangUtil;
import org.agrona.collections.BiInt2ObjectMap;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;

@EventLog
public class SendChannelEndpoint
extends UdpChannelTransport {
    private final NakFlyweight nakMessage;
    private final StatusMessageFlyweight statusMessage;
    private final Int2ObjectHashMap<NetworkPublication> driversPublicationByStreamId = new Int2ObjectHashMap();
    private final BiInt2ObjectMap<NetworkPublication> sendersPublicationByStreamAndSessionId = new BiInt2ObjectMap();
    private final AtomicCounter statusMessagesReceived;
    private final AtomicCounter nakMessagesReceived;
    private final AtomicCounter invalidPackets;

    public SendChannelEndpoint(UdpChannel udpChannel, MediaDriver.Context context) {
        super(udpChannel, udpChannel.remoteControl(), udpChannel.localControl(), udpChannel.remoteData(), context.errorLog());
        this.nakMessagesReceived = context.systemCounters().get(SystemCounterDescriptor.NAK_MESSAGES_RECEIVED);
        this.statusMessagesReceived = context.systemCounters().get(SystemCounterDescriptor.STATUS_MESSAGES_RECEIVED);
        this.invalidPackets = context.systemCounters().get(SystemCounterDescriptor.INVALID_PACKETS);
        this.nakMessage = new NakFlyweight(this.receiveBuffer);
        this.statusMessage = new StatusMessageFlyweight(this.receiveBuffer);
    }

    public void openChannel() {
        this.openDatagramChannel();
    }

    public String originalUriString() {
        return this.udpChannel().originalUriString();
    }

    public NetworkPublication getPublication(int streamId) {
        return (NetworkPublication)this.driversPublicationByStreamId.get(streamId);
    }

    public void addPublication(NetworkPublication publication) {
        this.driversPublicationByStreamId.put(publication.streamId(), (Object)publication);
    }

    public NetworkPublication removePublication(NetworkPublication publication) {
        return (NetworkPublication)this.driversPublicationByStreamId.remove(publication.streamId());
    }

    public int sessionCount() {
        return this.driversPublicationByStreamId.size();
    }

    public void registerForSend(NetworkPublication publication) {
        this.sendersPublicationByStreamAndSessionId.put(publication.sessionId(), publication.streamId(), (Object)publication);
    }

    public void unregisterForSend(NetworkPublication publication) {
        this.sendersPublicationByStreamAndSessionId.remove(publication.sessionId(), publication.streamId());
    }

    public int send(ByteBuffer buffer) {
        int byteSent = 0;
        try {
            this.presend(buffer, this.connectAddress);
            byteSent = this.sendDatagramChannel.write(buffer);
        }
        catch (PortUnreachableException | ClosedChannelException iOException) {
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return byteSent;
    }

    protected void presend(ByteBuffer buffer, InetSocketAddress address) {
    }

    @Override
    public int pollForData() {
        int bytesReceived = 0;
        InetSocketAddress srcAddress = this.receive();
        if (null != srcAddress) {
            int length = this.receiveByteBuffer.position();
            if (this.isValidFrame(this.receiveBuffer, length)) {
                bytesReceived = this.dispatch(this.receiveBuffer, length, srcAddress);
            } else {
                this.invalidPackets.orderedIncrement();
            }
        }
        return bytesReceived;
    }

    protected int dispatch(UnsafeBuffer buffer, int length, InetSocketAddress srcAddress) {
        int framesRead = 0;
        switch (FrameDescriptor.frameType((UnsafeBuffer)buffer, (int)0)) {
            case 2: {
                this.onNakMessage(this.nakMessage);
                framesRead = 1;
                break;
            }
            case 3: {
                this.onStatusMessage(this.statusMessage, srcAddress);
                framesRead = 1;
            }
        }
        return framesRead;
    }

    private void onStatusMessage(StatusMessageFlyweight msg, InetSocketAddress srcAddress) {
        NetworkPublication publication = (NetworkPublication)this.sendersPublicationByStreamAndSessionId.get(msg.sessionId(), msg.streamId());
        if (null != publication) {
            if (128 == (msg.flags() & 0x80)) {
                publication.triggerSendSetupFrame();
            } else {
                publication.onStatusMessage(msg.consumptionTermId(), msg.consumptionTermOffset(), msg.receiverWindowLength(), srcAddress);
            }
            this.statusMessagesReceived.orderedIncrement();
        }
    }

    private void onNakMessage(NakFlyweight msg) {
        NetworkPublication publication = (NetworkPublication)this.sendersPublicationByStreamAndSessionId.get(msg.sessionId(), msg.streamId());
        if (null != publication) {
            publication.onNak(msg.termId(), msg.termOffset(), msg.length());
            this.nakMessagesReceived.orderedIncrement();
        }
    }
}

