/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.Configuration;
import io.aeron.driver.media.UdpChannel;
import io.aeron.driver.media.UdpTransportPoller;
import io.aeron.logbuffer.FrameDescriptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PortUnreachableException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import org.agrona.LangUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.errors.DistinctErrorLog;

public abstract class UdpChannelTransport
implements AutoCloseable {
    protected InetSocketAddress bindAddress;
    protected InetSocketAddress endPointAddress;
    protected InetSocketAddress connectAddress;
    protected SelectionKey selectionKey;
    protected UdpTransportPoller transportPoller;
    protected final UdpChannel udpChannel;
    protected final DistinctErrorLog errorLog;
    protected final ByteBuffer receiveByteBuffer = ByteBuffer.allocateDirect(Configuration.RECEIVE_BYTE_BUFFER_LENGTH);
    protected final UnsafeBuffer receiveBuffer = new UnsafeBuffer(this.receiveByteBuffer);
    protected DatagramChannel sendDatagramChannel;
    protected DatagramChannel receiveDatagramChannel;

    public UdpChannelTransport(UdpChannel udpChannel, InetSocketAddress endPointAddress, InetSocketAddress bindAddress, InetSocketAddress connectAddress, DistinctErrorLog errorLog) {
        this.udpChannel = udpChannel;
        this.errorLog = errorLog;
        this.endPointAddress = endPointAddress;
        this.bindAddress = bindAddress;
        this.connectAddress = connectAddress;
    }

    public void openDatagramChannel() {
        try {
            this.receiveDatagramChannel = this.sendDatagramChannel = DatagramChannel.open(this.udpChannel.protocolFamily());
            if (this.udpChannel.isMulticast()) {
                NetworkInterface localInterface = this.udpChannel.localInterface();
                if (null != this.connectAddress) {
                    this.receiveDatagramChannel = DatagramChannel.open(this.udpChannel.protocolFamily());
                }
                this.receiveDatagramChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
                this.receiveDatagramChannel.bind(new InetSocketAddress(this.endPointAddress.getPort()));
                this.receiveDatagramChannel.join(this.endPointAddress.getAddress(), localInterface);
                this.sendDatagramChannel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, localInterface);
                if (0 != this.udpChannel.multicastTtl()) {
                    this.sendDatagramChannel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)this.udpChannel.multicastTtl());
                }
                if (null != this.connectAddress) {
                    this.sendDatagramChannel.connect(this.connectAddress);
                }
            } else {
                this.sendDatagramChannel.bind(this.bindAddress);
                if (null != this.connectAddress) {
                    this.sendDatagramChannel.connect(this.connectAddress);
                }
            }
            if (0 != Configuration.SOCKET_SNDBUF_LENGTH) {
                this.sendDatagramChannel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)Configuration.SOCKET_SNDBUF_LENGTH);
            }
            if (0 != Configuration.SOCKET_RCVBUF_LENGTH) {
                this.receiveDatagramChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)Configuration.SOCKET_RCVBUF_LENGTH);
            }
            this.sendDatagramChannel.configureBlocking(false);
            this.receiveDatagramChannel.configureBlocking(false);
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("channel \"%s\" : %s", this.udpChannel.originalUriString(), ex), ex);
        }
    }

    public void registerForRead(UdpTransportPoller transportPoller) {
        this.transportPoller = transportPoller;
        this.selectionKey = transportPoller.registerForRead(this);
    }

    public UdpChannel udpChannel() {
        return this.udpChannel;
    }

    public DatagramChannel receiveDatagramChannel() {
        return this.receiveDatagramChannel;
    }

    public int multicastTtl() {
        int result = this.udpChannel.multicastTtl();
        if (this.isMulticast() && 0 == this.udpChannel.multicastTtl()) {
            try {
                result = this.sendDatagramChannel.getOption(StandardSocketOptions.IP_MULTICAST_TTL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public void close() {
        try {
            if (null != this.selectionKey) {
                this.selectionKey.cancel();
            }
            if (null != this.transportPoller) {
                this.transportPoller.cancelRead(this);
                this.transportPoller.selectNowWithoutProcessing();
            }
            if (null != this.sendDatagramChannel) {
                this.sendDatagramChannel.close();
            }
            if (this.receiveDatagramChannel != this.sendDatagramChannel && null != this.receiveDatagramChannel) {
                this.receiveDatagramChannel.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.errorLog.record((Throwable)ex);
        }
    }

    public boolean isMulticast() {
        return this.udpChannel.isMulticast();
    }

    public <T> T getOption(SocketOption<T> name) {
        T option = null;
        try {
            option = this.sendDatagramChannel.getOption(name);
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return option;
    }

    public int receiveBufferCapacity() {
        return this.receiveByteBuffer.capacity();
    }

    public abstract int pollForData();

    public boolean isValidFrame(UnsafeBuffer receiveBuffer, int length) {
        boolean isFrameValid = true;
        if (FrameDescriptor.frameVersion((UnsafeBuffer)receiveBuffer, (int)0) != 0) {
            isFrameValid = false;
        } else if (length < 8) {
            isFrameValid = false;
        }
        return isFrameValid;
    }

    protected InetSocketAddress receive() {
        this.receiveByteBuffer.clear();
        InetSocketAddress address = null;
        try {
            address = (InetSocketAddress)this.receiveDatagramChannel.receive(this.receiveByteBuffer);
        }
        catch (PortUnreachableException | ClosedChannelException iOException) {
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return address;
    }
}

