/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.status;

import java.nio.charset.StandardCharsets;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.CountersManager;
import org.agrona.concurrent.status.Position;
import org.agrona.concurrent.status.UnsafeBufferPosition;

public class StreamPositionCounter {
    public static final int REGISTRATION_ID_OFFSET = 0;
    public static final int SESSION_ID_OFFSET = 8;
    public static final int STREAM_ID_OFFSET = 12;
    public static final int CHANNEL_OFFSET = 16;
    public static final int MAX_CHANNEL_LENGTH = 100;

    public static Position allocate(String name, int typeId, CountersManager countersManager, long registrationId, int sessionId, int streamId, String channel) {
        String label = name + ": " + registrationId + ' ' + sessionId + ' ' + streamId + ' ' + channel;
        int counterId = countersManager.allocate(label, typeId, buffer -> {
            buffer.putLong(0, registrationId);
            buffer.putInt(8, sessionId);
            buffer.putInt(12, streamId);
            byte[] channelBytes = channel.getBytes(StandardCharsets.UTF_8);
            int length = Math.min(channelBytes.length, 100);
            buffer.putInt(16, length);
            buffer.putBytes(20, channelBytes, 0, length);
        });
        return new UnsafeBufferPosition((UnsafeBuffer)countersManager.valuesBuffer(), counterId, countersManager);
    }

    public static String labelName(int typeId) {
        switch (typeId) {
            case 1: {
                return "pub-lmt";
            }
            case 2: {
                return "snd-pos";
            }
            case 3: {
                return "rcv-hwm";
            }
            case 4: {
                return "sub-pos";
            }
        }
        return "<unknown>";
    }
}

