/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;

public class AeronClient
implements DriverManagedResource {
    private final long clientId;
    private final long clientLivenessTimeoutNs;
    private long timeOfLastKeepalive;
    private boolean reachedEndOfLife = false;

    public AeronClient(long clientId, long clientLivenessTimeoutNs, long now) {
        this.clientId = clientId;
        this.clientLivenessTimeoutNs = clientLivenessTimeoutNs;
        this.timeOfLastKeepalive = now;
    }

    public long clientId() {
        return this.clientId;
    }

    public long timeOfLastKeepalive() {
        return this.timeOfLastKeepalive;
    }

    public void timeOfLastKeepalive(long now) {
        this.timeOfLastKeepalive = now;
    }

    public boolean hasTimedOut(long now) {
        return now > this.timeOfLastKeepalive + this.clientLivenessTimeoutNs;
    }

    @Override
    public void onTimeEvent(long time, DriverConductor conductor) {
        if (time > this.timeOfLastKeepalive + this.clientLivenessTimeoutNs) {
            this.reachedEndOfLife = true;
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }

    public void timeOfLastStateChange(long time) {
        this.timeOfLastKeepalive = time;
    }

    public long timeOfLastStateChange() {
        return this.timeOfLastKeepalive;
    }

    public void delete() {
    }
}

