/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.FeedbackDelayGenerator;
import io.aeron.driver.LossHandler;
import io.aeron.logbuffer.TermGapScanner;
import org.agrona.concurrent.UnsafeBuffer;

public class LossDetector
implements TermGapScanner.GapHandler {
    private static final long TIMER_INACTIVE = -1L;
    private final FeedbackDelayGenerator delayGenerator;
    private final LossHandler lossHandler;
    private final Gap scannedGap = new Gap();
    private final Gap activeGap = new Gap();
    private long expiry = -1L;

    public LossDetector(FeedbackDelayGenerator delayGenerator, LossHandler lossHandler) {
        this.delayGenerator = delayGenerator;
        this.lossHandler = lossHandler;
    }

    public long scan(UnsafeBuffer termBuffer, long rebuildPosition, long hwmPosition, long now, int termLengthMask, int positionBitsToShift, int initialTermId) {
        boolean lossFound = false;
        int rebuildOffset = (int)rebuildPosition & termLengthMask;
        if (rebuildPosition < hwmPosition) {
            int rebuildTermCount = (int)(rebuildPosition >>> positionBitsToShift);
            int hwmTermCount = (int)(hwmPosition >>> positionBitsToShift);
            int rebuildTermId = initialTermId + rebuildTermCount;
            int hwmTermOffset = (int)hwmPosition & termLengthMask;
            int limitOffset = rebuildTermCount == hwmTermCount ? hwmTermOffset : termBuffer.capacity();
            if ((rebuildOffset = TermGapScanner.scanForGap((UnsafeBuffer)termBuffer, (int)rebuildTermId, (int)rebuildOffset, (int)limitOffset, (TermGapScanner.GapHandler)this)) < limitOffset) {
                if (!this.scannedGap.matches(this.activeGap)) {
                    this.activateGap(now, this.scannedGap);
                    lossFound = true;
                }
                this.checkTimerExpiry(now);
            }
        }
        return LossDetector.pack(rebuildOffset, lossFound);
    }

    public void onGap(int termId, int offset, int length) {
        this.scannedGap.set(termId, offset, length);
    }

    public static long pack(int rebuildOffset, boolean lossFound) {
        return (long)rebuildOffset << 32 | (long)(lossFound ? 1 : 0);
    }

    public static boolean lossFound(long scanOutcome) {
        return (int)scanOutcome != 0;
    }

    public static int rebuildOffset(long scanOutcome) {
        return (int)(scanOutcome >>> 32);
    }

    private void activateGap(long now, Gap gap) {
        this.activeGap.set(gap.termId, gap.termOffset, gap.length);
        this.expiry = this.delayGenerator.shouldFeedbackImmediately() ? now : now + this.delayGenerator.generateDelay();
    }

    private void checkTimerExpiry(long now) {
        if (now >= this.expiry) {
            this.lossHandler.onGapDetected(this.activeGap.termId, this.activeGap.termOffset, this.activeGap.length);
            this.expiry = now + this.delayGenerator.generateDelay();
        }
    }

    static final class Gap {
        int termId;
        int termOffset = -1;
        int length;

        Gap() {
        }

        public void set(int termId, int termOffset, int length) {
            this.termId = termId;
            this.termOffset = termOffset;
            this.length = length;
        }

        public boolean matches(Gap other) {
            return other.termId == this.termId && other.termOffset == this.termOffset;
        }
    }
}

