/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.narayana;

import io.agroal.api.transaction.TransactionAware;
import io.agroal.api.transaction.TransactionIntegration;
import io.agroal.narayana.BaseXAResource;
import io.agroal.narayana.ConnectableLocalXAResource;
import io.agroal.narayana.LocalXAResource;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAResource;
import org.jboss.tm.XAResourceRecovery;
import org.jboss.tm.XAResourceRecoveryRegistry;

public class NarayanaTransactionIntegration
implements TransactionIntegration {
    private static final ConcurrentMap<TransactionIntegration.ResourceRecoveryFactory, XAResourceRecovery> resourceRecoveryCache = new ConcurrentHashMap<TransactionIntegration.ResourceRecoveryFactory, XAResourceRecovery>();
    private final TransactionManager transactionManager;
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private final String jndiName;
    private final boolean connectable;
    private final XAResourceRecoveryRegistry recoveryRegistry;
    private final UUID key = UUID.randomUUID();

    public NarayanaTransactionIntegration(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        this(transactionManager, transactionSynchronizationRegistry, null, false);
    }

    public NarayanaTransactionIntegration(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry, String jndiName) {
        this(transactionManager, transactionSynchronizationRegistry, jndiName, false);
    }

    public NarayanaTransactionIntegration(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry, String jndiName, boolean connectable) {
        this(transactionManager, transactionSynchronizationRegistry, jndiName, connectable, null);
    }

    public NarayanaTransactionIntegration(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry, String jndiName, boolean connectable, XAResourceRecoveryRegistry recoveryRegistry) {
        this.transactionManager = transactionManager;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        this.jndiName = jndiName;
        this.connectable = connectable;
        this.recoveryRegistry = recoveryRegistry;
    }

    public TransactionAware getTransactionAware() throws SQLException {
        if (this.transactionRunning()) {
            return (TransactionAware)this.transactionSynchronizationRegistry.getResource((Object)this.key);
        }
        return null;
    }

    public void associate(TransactionAware transactionAware, XAResource xaResource) throws SQLException {
        try {
            if (this.transactionRunning()) {
                if (this.transactionSynchronizationRegistry.getResource((Object)this.key) == null) {
                    this.transactionSynchronizationRegistry.putResource((Object)this.key, (Object)transactionAware);
                    this.transactionSynchronizationRegistry.registerInterposedSynchronization((Synchronization)new InterposedSynchronization(transactionAware));
                    Object xaResourceToEnlist = xaResource != null ? new BaseXAResource(transactionAware, xaResource, this.jndiName) : (this.connectable ? new ConnectableLocalXAResource(transactionAware, this.jndiName) : new LocalXAResource(transactionAware, this.jndiName));
                    this.transactionManager.getTransaction().enlistResource((XAResource)xaResourceToEnlist);
                } else {
                    transactionAware.transactionStart();
                }
            } else {
                transactionAware.transactionCheckCallback(this::transactionRunning);
            }
        }
        catch (Exception e) {
            throw new SQLException("Exception in association of connection to existing transaction", e);
        }
    }

    public boolean disassociate(TransactionAware connection) throws SQLException {
        if (this.transactionRunning()) {
            this.transactionSynchronizationRegistry.putResource((Object)this.key, null);
        }
        return true;
    }

    private boolean transactionRunning() throws SQLException {
        try {
            Transaction transaction = this.transactionManager.getTransaction();
            return transaction != null && (transaction.getStatus() == 0 || transaction.getStatus() == 1);
        }
        catch (Exception e) {
            throw new SQLException("Exception in retrieving existing transaction", e);
        }
    }

    public void addResourceRecoveryFactory(TransactionIntegration.ResourceRecoveryFactory factory) {
        if (this.recoveryRegistry != null) {
            this.recoveryRegistry.addXAResourceRecovery(resourceRecoveryCache.computeIfAbsent(factory, f -> () -> ((TransactionIntegration.ResourceRecoveryFactory)f).recoveryResources()));
        }
    }

    public void removeResourceRecoveryFactory(TransactionIntegration.ResourceRecoveryFactory factory) {
        if (this.recoveryRegistry != null) {
            this.recoveryRegistry.removeXAResourceRecovery((XAResourceRecovery)resourceRecoveryCache.remove(factory));
        }
    }

    private static class InterposedSynchronization
    implements Synchronization {
        private final TransactionAware transactionAware;

        private InterposedSynchronization(TransactionAware transactionAware) {
            this.transactionAware = transactionAware;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            try {
                this.transactionAware.transactionEnd();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

