/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.service.local;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.service.local.AppiumServerHasNotBeenStartedLocallyException;
import io.appium.java_client.service.local.AppiumServiceBuilder;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.net.UrlChecker;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.remote.service.DriverService;

public final class AppiumDriverLocalService
extends DriverService {
    private static final String URL_MASK = "http://%s:%d/wd/hub";
    private final File nodeJSExec;
    private final int nodeJSPort;
    private final ImmutableList<String> nodeJSArgs;
    private final ImmutableMap<String, String> nodeJSEnvironment;
    private final String ipAddress;
    private final long startupTimeout;
    private final TimeUnit timeUnit;
    private CommandLine process = null;

    AppiumDriverLocalService(String ipAddress, File nodeJSExec, int nodeJSPort, ImmutableList<String> nodeJSArgs, ImmutableMap<String, String> nodeJSEnvironment, long startupTimeout, TimeUnit timeUnit) throws IOException {
        super(nodeJSExec, nodeJSPort, nodeJSArgs, nodeJSEnvironment);
        this.ipAddress = ipAddress;
        this.nodeJSExec = nodeJSExec;
        this.nodeJSPort = nodeJSPort;
        this.nodeJSArgs = nodeJSArgs;
        this.nodeJSEnvironment = nodeJSEnvironment;
        this.startupTimeout = startupTimeout;
        this.timeUnit = timeUnit;
    }

    public URL getUrl() {
        try {
            return new URL(String.format(URL_MASK, this.ipAddress, this.nodeJSPort));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isRunning() {
        if (this.process == null) {
            return false;
        }
        try {
            this.ping(500L, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (UrlChecker.TimeoutException timeoutException) {
            return false;
        }
    }

    private void ping(long time, TimeUnit timeUnit) throws UrlChecker.TimeoutException {
        URL url = this.getUrl();
        try {
            URL status = new URL(String.valueOf(url.toString()) + "/status");
            new UrlChecker().waitUntilAvailable(time, timeUnit, new URL[]{status});
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("There is something wrong with the URL " + url.toString().toString() + "/status");
        }
    }

    public synchronized void start() throws AppiumServerHasNotBeenStartedLocallyException {
        if (this.isRunning()) {
            return;
        }
        try {
            this.process = new CommandLine(this.nodeJSExec.getCanonicalPath(), (String[])this.nodeJSArgs.toArray((Object[])new String[0]));
            this.process.setEnvironmentVariables(this.nodeJSEnvironment);
            this.process.copyOutputTo((OutputStream)System.err);
            this.process.executeAsync();
            this.ping(this.startupTimeout, this.timeUnit);
        }
        catch (Throwable e) {
            this.destroyProcess();
            String msgTxt = "The local appium server has not been started. The given Node.js executable: " + this.nodeJSExec.getAbsolutePath() + " Arguments: " + this.nodeJSArgs.toString() + " " + "\n";
            String processStream = this.process.getStdOut();
            if (!StringUtils.isBlank((CharSequence)processStream)) {
                msgTxt = String.valueOf(msgTxt) + "Process output: " + processStream + "\n";
            }
            throw new AppiumServerHasNotBeenStartedLocallyException(msgTxt, e);
        }
    }

    public synchronized void stop() {
        this.destroyProcess();
    }

    private void destroyProcess() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public String getStdOut() {
        if (this.process != null) {
            return this.process.getStdOut();
        }
        return null;
    }

    public static AppiumDriverLocalService buildDefaultService() {
        return AppiumDriverLocalService.buildService(new AppiumServiceBuilder());
    }

    public static AppiumDriverLocalService buildService(AppiumServiceBuilder builder) {
        return (AppiumDriverLocalService)builder.build();
    }
}

