/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.service.local;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.service.local.AppiumDriverLocalService;
import io.appium.java_client.service.local.InvalidNodeJSInstance;
import io.appium.java_client.service.local.InvalidServerInstanceException;
import io.appium.java_client.service.local.flags.ServerArgument;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.service.DriverService;

public final class AppiumServiceBuilder
extends DriverService.Builder<AppiumDriverLocalService, AppiumServiceBuilder> {
    private static final String NODE_MODULES_FOLDER = "node_modules";
    private static final String APPIUM_FOLDER = "appium";
    private static final String BIN_FOLDER = "bin";
    private static final String APPIUM_JS = "appium.js";
    private static final String APPIUM_NODE_MASK = String.valueOf(File.separator) + "appium" + File.separator + "bin" + File.separator + "appium.js";
    public static final String APPIUM_NODE_PROPERTY = "appium.node.path";
    public static final String DEFAULT_LOCAL_IP_ADDRESS = "0.0.0.0";
    private static final int DEFAULT_APPIUM_PORT = 4723;
    private static final String COMMAND_WHICH_EXTRACTS_DEFAULT_PATH_TO_APPIUM = "npm -g ls --depth=0";
    private static final String COMMAND_WHICH_EXTRACTS_DEFAULT_PATH_TO_APPIUM_WIN = "npm.cmd -g ls --depth=0";
    private static final int REQUIRED_MAJOR_NODE_JS = 0;
    private static final int REQUIRED_MINOR_NODE_JS = 0;
    final Map<String, String> serverArguments = new HashMap<String, String>();
    private File appiumJS;
    private String ipAddress = "0.0.0.0";
    private long startupTimeout = 120L;
    private TimeUnit timeUnit = TimeUnit.SECONDS;

    private static String returnCommandThatSearchesForDefaultNode() {
        if (Platform.getCurrent().is(Platform.WINDOWS)) {
            return COMMAND_WHICH_EXTRACTS_DEFAULT_PATH_TO_APPIUM_WIN;
        }
        return COMMAND_WHICH_EXTRACTS_DEFAULT_PATH_TO_APPIUM;
    }

    private static String getProcessOutput(InputStream stream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String result = reader.readLine();
        reader.close();
        return result;
    }

    private static void validateNodeJSVersion() {
        Runtime rt = Runtime.getRuntime();
        String result = null;
        try {
            Process p = rt.exec("node -v");
            p.waitFor();
            result = AppiumServiceBuilder.getProcessOutput(p.getInputStream());
        }
        catch (Exception e) {
            throw new InvalidNodeJSInstance("Node.js is not installed", e);
        }
        String versionNum = result.replace("v", "");
        String[] tokens = versionNum.split("\\.");
        if (Integer.parseInt(tokens[0]) < 0 || Integer.parseInt(tokens[1]) < 0) {
            throw new InvalidNodeJSInstance("Current node.js version " + versionNum + "is lower than " + "required (" + 0 + "." + 0 + " or greater)");
        }
    }

    private static File findNodeInCurrentFileSystem() {
        File result;
        String instancePath;
        Runtime rt = Runtime.getRuntime();
        try {
            Process p = rt.exec(AppiumServiceBuilder.returnCommandThatSearchesForDefaultNode());
            p.waitFor();
            instancePath = AppiumServiceBuilder.getProcessOutput(p.getInputStream());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (StringUtils.isBlank((CharSequence)instancePath) || !(result = new File(String.valueOf(instancePath) + File.separator + NODE_MODULES_FOLDER + APPIUM_NODE_MASK)).exists()) {
            throw new InvalidServerInstanceException("There is no installed nodes! Please install  node via NPM (https://www.npmjs.com/package/appium#using-node-js) or download and install Appium app (http://appium.io/downloads.html)", new IOException("The installed appium node package has not been found."));
        }
        return result;
    }

    private static void validateNodeStructure(File node) {
        String absoluteNodePath = node.getAbsolutePath();
        if (!node.exists()) {
            throw new InvalidServerInstanceException("The invalid appium node " + absoluteNodePath + " has been defined", new IOException("The node " + absoluteNodePath + "doesn't exist"));
        }
        if (!absoluteNodePath.endsWith(APPIUM_NODE_MASK)) {
            throw new InvalidServerInstanceException("It is probably there is the corrupted appium server installation. Path " + absoluteNodePath + "doesn't match " + APPIUM_NODE_MASK);
        }
    }

    public AppiumServiceBuilder() {
        this.usingPort(4723);
    }

    protected File findDefaultExecutable() {
        Process p;
        AppiumServiceBuilder.validateNodeJSVersion();
        Runtime rt = Runtime.getRuntime();
        try {
            p = rt.exec("node");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        OutputStream outputStream = p.getOutputStream();
        PrintStream out = new PrintStream(outputStream);
        out.println("console.log(process.execPath);");
        out.close();
        try {
            return new File(AppiumServiceBuilder.getProcessOutput(p.getInputStream()));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public AppiumServiceBuilder withArgument(ServerArgument argument) {
        this.serverArguments.put(argument.getArgument(), "");
        return this;
    }

    public AppiumServiceBuilder withArgument(ServerArgument argument, String value) {
        this.serverArguments.put(argument.getArgument(), value);
        return this;
    }

    public AppiumServiceBuilder withAppiumJS(File appiumJS) {
        this.appiumJS = appiumJS;
        return this;
    }

    public AppiumServiceBuilder withIPAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public AppiumServiceBuilder withStartUpTimeOut(long time, TimeUnit timeUnit) {
        Preconditions.checkNotNull((Object)((Object)timeUnit));
        Preconditions.checkArgument((time > 0L ? 1 : 0) != 0, (String)"Time value should be greater than zero", (Object[])new Object[]{time});
        this.startupTimeout = time;
        this.timeUnit = timeUnit;
        return this;
    }

    void checkAppiumJS() {
        if (this.appiumJS != null) {
            AppiumServiceBuilder.validateNodeStructure(this.appiumJS);
            return;
        }
        String appiumJS = System.getProperty(APPIUM_NODE_PROPERTY);
        if (appiumJS != null) {
            File node = new File(appiumJS);
            AppiumServiceBuilder.validateNodeStructure(node);
            this.appiumJS = node;
            return;
        }
        this.appiumJS = AppiumServiceBuilder.findNodeInCurrentFileSystem();
    }

    protected ImmutableList<String> createArgs() {
        ArrayList<String> argList = new ArrayList<String>();
        this.checkAppiumJS();
        argList.add(this.appiumJS.getAbsolutePath());
        argList.add("--port");
        argList.add(String.valueOf(this.getPort()));
        if (StringUtils.isBlank((CharSequence)this.ipAddress)) {
            this.ipAddress = DEFAULT_LOCAL_IP_ADDRESS;
        } else {
            InetAddressValidator validator = InetAddressValidator.getInstance();
            if (!(validator.isValid(this.ipAddress) || validator.isValidInet4Address(this.ipAddress) || validator.isValidInet6Address(this.ipAddress))) {
                throw new IllegalArgumentException("The invalid IP address " + this.ipAddress + " is defined");
            }
        }
        argList.add("--address");
        argList.add(this.ipAddress);
        File log = this.getLogFile();
        if (log != null) {
            argList.add("--log");
            argList.add(log.getAbsolutePath());
        }
        Set<Map.Entry<String, String>> entries = this.serverArguments.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String argument = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.isBlank((CharSequence)argument) || value == null) continue;
            argList.add(argument);
            if (StringUtils.isBlank((CharSequence)value)) continue;
            argList.add(value);
        }
        ImmutableList result = new ImmutableList.Builder().addAll(argList).build();
        return result;
    }

    public AppiumServiceBuilder usingDriverExecutable(File nodeJSExecutable) {
        return (AppiumServiceBuilder)super.usingDriverExecutable(nodeJSExecutable);
    }

    public AppiumServiceBuilder usingPort(int port) {
        return (AppiumServiceBuilder)super.usingPort(port);
    }

    public AppiumServiceBuilder usingAnyFreePort() {
        return (AppiumServiceBuilder)super.usingAnyFreePort();
    }

    public AppiumServiceBuilder withEnvironment(Map<String, String> environment) {
        return (AppiumServiceBuilder)super.withEnvironment(environment);
    }

    public AppiumServiceBuilder withLogFile(File logFile) {
        return (AppiumServiceBuilder)super.withLogFile(logFile);
    }

    protected AppiumDriverLocalService createDriverService(File nodeJSExecutable, int nodeJSPort, ImmutableList<String> nodeArguments, ImmutableMap<String, String> nodeEnvironment) {
        try {
            return new AppiumDriverLocalService(this.ipAddress, nodeJSExecutable, nodeJSPort, nodeArguments, nodeEnvironment, this.startupTimeout, this.timeUnit);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

