package arrow.core.extensions.validated.foldable

import arrow.Kind
import arrow.core.Eval
import arrow.core.ForValidated
import arrow.core.Option
import arrow.core.Validated
import arrow.core.Validated.Companion
import arrow.core.extensions.ValidatedFoldable
import arrow.typeclasses.Applicative
import arrow.typeclasses.Monad
import arrow.typeclasses.Monoid
import kotlin.Any
import kotlin.Boolean
import kotlin.Function1
import kotlin.Function2
import kotlin.Long
import kotlin.PublishedApi
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * cached extension
 */
@PublishedApi()
internal val foldable_singleton: ValidatedFoldable<Any?> = object : ValidatedFoldable<Any?> {}

@JvmName("foldLeft")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A, B> Kind<Kind<ForValidated, E>, A>.foldLeft(arg1: B, arg2: Function2<B, A, B>): B =
    arrow.core.Validated.foldable<E>().run {
  this@foldLeft.foldLeft<A, B>(arg1, arg2) as B
}

@JvmName("foldRight")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A, B> Kind<Kind<ForValidated, E>, A>.foldRight(arg1: Eval<B>, arg2: Function2<A, Eval<B>,
    Eval<B>>): Eval<B> = arrow.core.Validated.foldable<E>().run {
  this@foldRight.foldRight<A, B>(arg1, arg2) as arrow.core.Eval<B>
}

@JvmName("fold")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.fold(arg1: Monoid<A>): A =
    arrow.core.Validated.foldable<E>().run {
  this@fold.fold<A>(arg1) as A
}

@JvmName("reduceLeftToOption")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A, B> Kind<Kind<ForValidated, E>, A>.reduceLeftToOption(arg1: Function1<A, B>,
    arg2: Function2<B, A, B>): Option<B> = arrow.core.Validated.foldable<E>().run {
  this@reduceLeftToOption.reduceLeftToOption<A, B>(arg1, arg2) as arrow.core.Option<B>
}

@JvmName("reduceRightToOption")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A, B> Kind<Kind<ForValidated, E>, A>.reduceRightToOption(arg1: Function1<A, B>,
    arg2: Function2<A, Eval<B>, Eval<B>>): Eval<Option<B>> =
    arrow.core.Validated.foldable<E>().run {
  this@reduceRightToOption.reduceRightToOption<A, B>(arg1, arg2) as
    arrow.core.Eval<arrow.core.Option<B>>
}

@JvmName("reduceLeftOption")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.reduceLeftOption(arg1: Function2<A, A, A>): Option<A> =
    arrow.core.Validated.foldable<E>().run {
  this@reduceLeftOption.reduceLeftOption<A>(arg1) as arrow.core.Option<A>
}

@JvmName("reduceRightOption")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.reduceRightOption(arg1: Function2<A, Eval<A>, Eval<A>>):
    Eval<Option<A>> = arrow.core.Validated.foldable<E>().run {
  this@reduceRightOption.reduceRightOption<A>(arg1) as arrow.core.Eval<arrow.core.Option<A>>
}

@JvmName("combineAll")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.combineAll(arg1: Monoid<A>): A =
    arrow.core.Validated.foldable<E>().run {
  this@combineAll.combineAll<A>(arg1) as A
}

@JvmName("foldMap")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A, B> Kind<Kind<ForValidated, E>, A>.foldMap(arg1: Monoid<B>, arg2: Function1<A, B>): B =
    arrow.core.Validated.foldable<E>().run {
  this@foldMap.foldMap<A, B>(arg1, arg2) as B
}

@JvmName("orEmpty")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A> orEmpty(arg0: Applicative<Kind<ForValidated, E>>, arg1: Monoid<A>): Validated<E, A> =
    arrow.core.Validated
   .foldable<E>()
   .orEmpty<A>(arg0, arg1) as arrow.core.Validated<E, A>

@JvmName("traverse_")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, G, A, B> Kind<Kind<ForValidated, E>, A>.traverse_(arg1: Applicative<G>, arg2: Function1<A,
    Kind<G, B>>): Kind<G, Unit> = arrow.core.Validated.foldable<E>().run {
  this@traverse_.traverse_<G, A, B>(arg1, arg2) as arrow.Kind<G, kotlin.Unit>
}

@JvmName("sequence_")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, G, A> Kind<Kind<ForValidated, E>, Kind<G, A>>.sequence_(arg1: Applicative<G>): Kind<G, Unit>
    = arrow.core.Validated.foldable<E>().run {
  this@sequence_.sequence_<G, A>(arg1) as arrow.Kind<G, kotlin.Unit>
}

@JvmName("find")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.find(arg1: Function1<A, Boolean>): Option<A> =
    arrow.core.Validated.foldable<E>().run {
  this@find.find<A>(arg1) as arrow.core.Option<A>
}

@JvmName("exists")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.exists(arg1: Function1<A, Boolean>): Boolean =
    arrow.core.Validated.foldable<E>().run {
  this@exists.exists<A>(arg1) as kotlin.Boolean
}

@JvmName("forAll")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.forAll(arg1: Function1<A, Boolean>): Boolean =
    arrow.core.Validated.foldable<E>().run {
  this@forAll.forAll<A>(arg1) as kotlin.Boolean
}

@JvmName("all")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.all(arg1: Function1<A, Boolean>): Boolean =
    arrow.core.Validated.foldable<E>().run {
  this@all.all<A>(arg1) as kotlin.Boolean
}

@JvmName("isEmpty")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.isEmpty(): Boolean =
    arrow.core.Validated.foldable<E>().run {
  this@isEmpty.isEmpty<A>() as kotlin.Boolean
}

@JvmName("nonEmpty")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.nonEmpty(): Boolean =
    arrow.core.Validated.foldable<E>().run {
  this@nonEmpty.nonEmpty<A>() as kotlin.Boolean
}

@JvmName("isNotEmpty")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.isNotEmpty(): Boolean =
    arrow.core.Validated.foldable<E>().run {
  this@isNotEmpty.isNotEmpty<A>() as kotlin.Boolean
}

@JvmName("size")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.size(arg1: Monoid<Long>): Long =
    arrow.core.Validated.foldable<E>().run {
  this@size.size<A>(arg1) as kotlin.Long
}

@JvmName("foldMapM")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, G, A, B, MA : Monad<G>, MO : Monoid<B>> Kind<Kind<ForValidated, E>, A>.foldMapM(
  arg1: MA,
  arg2: MO,
  arg3: Function1<A, Kind<G, B>>
): Kind<G, B> = arrow.core.Validated.foldable<E>().run {
  this@foldMapM.foldMapM<G, A, B, MA, MO>(arg1, arg2, arg3) as arrow.Kind<G, B>
}

@JvmName("foldM")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, G, A, B> Kind<Kind<ForValidated, E>, A>.foldM(
  arg1: Monad<G>,
  arg2: B,
  arg3: Function2<B, A, Kind<G, B>>
): Kind<G, B> = arrow.core.Validated.foldable<E>().run {
  this@foldM.foldM<G, A, B>(arg1, arg2, arg3) as arrow.Kind<G, B>
}

@JvmName("get")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.get(arg1: Long): Option<A> =
    arrow.core.Validated.foldable<E>().run {
  this@get.get<A>(arg1) as arrow.core.Option<A>
}

@JvmName("firstOption")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.firstOption(): Option<A> =
    arrow.core.Validated.foldable<E>().run {
  this@firstOption.firstOption<A>() as arrow.core.Option<A>
}

@JvmName("firstOption")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.firstOption(arg1: Function1<A, Boolean>): Option<A> =
    arrow.core.Validated.foldable<E>().run {
  this@firstOption.firstOption<A>(arg1) as arrow.core.Option<A>
}

@JvmName("firstOrNone")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.firstOrNone(): Option<A> =
    arrow.core.Validated.foldable<E>().run {
  this@firstOrNone.firstOrNone<A>() as arrow.core.Option<A>
}

@JvmName("firstOrNone")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.firstOrNone(arg1: Function1<A, Boolean>): Option<A> =
    arrow.core.Validated.foldable<E>().run {
  this@firstOrNone.firstOrNone<A>(arg1) as arrow.core.Option<A>
}

@JvmName("toList")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.toList(): List<A> =
    arrow.core.Validated.foldable<E>().run {
  this@toList.toList<A>() as kotlin.collections.List<A>
}

@Suppress(
  "UNCHECKED_CAST",
  "NOTHING_TO_INLINE"
)
inline fun <E> Companion.foldable(): ValidatedFoldable<E> = foldable_singleton as
    arrow.core.extensions.ValidatedFoldable<E>