package arrow.core.extensions.validated.functor

import arrow.Kind
import arrow.core.ForValidated
import arrow.core.Tuple2
import arrow.core.Validated
import arrow.core.Validated.Companion
import arrow.core.extensions.ValidatedFunctor
import kotlin.Any
import kotlin.Function1
import kotlin.PublishedApi
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * cached extension
 */
@PublishedApi()
internal val functor_singleton: ValidatedFunctor<Any?> = object : ValidatedFunctor<Any?> {}

@JvmName("map")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A, B> Kind<Kind<ForValidated, E>, A>.map(arg1: Function1<A, B>): Validated<E, B> =
    arrow.core.Validated.functor<E>().run {
  this@map.map<A, B>(arg1) as arrow.core.Validated<E, B>
}

@JvmName("imap")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A, B> Kind<Kind<ForValidated, E>, A>.imap(arg1: Function1<A, B>, arg2: Function1<B, A>):
    Validated<E, B> = arrow.core.Validated.functor<E>().run {
  this@imap.imap<A, B>(arg1, arg2) as arrow.core.Validated<E, B>
}

@JvmName("lift")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A, B> lift(arg0: Function1<A, B>): Function1<Kind<Kind<ForValidated, E>, A>,
    Kind<Kind<ForValidated, E>, B>> = arrow.core.Validated
   .functor<E>()
   .lift<A, B>(arg0) as kotlin.Function1<arrow.Kind<arrow.Kind<arrow.core.ForValidated, E>, A>,
    arrow.Kind<arrow.Kind<arrow.core.ForValidated, E>, B>>

@JvmName("void")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.void(): Validated<E, Unit> =
    arrow.core.Validated.functor<E>().run {
  this@void.void<A>() as arrow.core.Validated<E, kotlin.Unit>
}

@JvmName("unit")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A> Kind<Kind<ForValidated, E>, A>.unit(): Validated<E, Unit> =
    arrow.core.Validated.functor<E>().run {
  this@unit.unit<A>() as arrow.core.Validated<E, kotlin.Unit>
}

@JvmName("fproduct")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A, B> Kind<Kind<ForValidated, E>, A>.fproduct(arg1: Function1<A, B>): Validated<E, Tuple2<A,
    B>> = arrow.core.Validated.functor<E>().run {
  this@fproduct.fproduct<A, B>(arg1) as arrow.core.Validated<E, arrow.core.Tuple2<A, B>>
}

@JvmName("mapConst")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A, B> Kind<Kind<ForValidated, E>, A>.mapConst(arg1: B): Validated<E, B> =
    arrow.core.Validated.functor<E>().run {
  this@mapConst.mapConst<A, B>(arg1) as arrow.core.Validated<E, B>
}

@JvmName("mapConst")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A, B> A.mapConst(arg1: Kind<Kind<ForValidated, E>, B>): Validated<E, A> =
    arrow.core.Validated.functor<E>().run {
  this@mapConst.mapConst<A, B>(arg1) as arrow.core.Validated<E, A>
}

@JvmName("tupleLeft")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A, B> Kind<Kind<ForValidated, E>, A>.tupleLeft(arg1: B): Validated<E, Tuple2<B, A>> =
    arrow.core.Validated.functor<E>().run {
  this@tupleLeft.tupleLeft<A, B>(arg1) as arrow.core.Validated<E, arrow.core.Tuple2<B, A>>
}

@JvmName("tupleRight")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, A, B> Kind<Kind<ForValidated, E>, A>.tupleRight(arg1: B): Validated<E, Tuple2<A, B>> =
    arrow.core.Validated.functor<E>().run {
  this@tupleRight.tupleRight<A, B>(arg1) as arrow.core.Validated<E, arrow.core.Tuple2<A, B>>
}

@JvmName("widen")
@Suppress(
  "UNCHECKED_CAST",
  "USELESS_CAST",
  "EXTENSION_SHADOWED_BY_MEMBER",
  "UNUSED_PARAMETER"
)
fun <E, B, A : B> Kind<Kind<ForValidated, E>, A>.widen(): Validated<E, B> =
    arrow.core.Validated.functor<E>().run {
  this@widen.widen<B, A>() as arrow.core.Validated<E, B>
}

@Suppress(
  "UNCHECKED_CAST",
  "NOTHING_TO_INLINE"
)
inline fun <E> Companion.functor(): ValidatedFunctor<E> = functor_singleton as
    arrow.core.extensions.ValidatedFunctor<E>