/*
 * Decompiled with CFR 0.152.
 */
package io.astefanutti.metrics.aspectj;

import com.codahale.metrics.Metric;
import java.lang.annotation.Annotation;

public interface AnnotatedMetric<T extends Metric> {
    public boolean isPresent();

    public T getMetric();

    public <A extends Annotation> A getAnnotation(Class<A> var1);

    public static final class IsNotPresent<T extends Metric>
    implements AnnotatedMetric<T> {
        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public T getMetric() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> clazz) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class IsPresent<T extends Metric>
    implements AnnotatedMetric<T> {
        private final T metric;
        private final Annotation annotation;

        IsPresent(T metric, Annotation annotation) {
            this.metric = metric;
            this.annotation = annotation;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public T getMetric() {
            return this.metric;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> clazz) {
            return (A)this.annotation;
        }
    }
}

