/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.actions;

import io.atlasmap.spi.AtlasActionProcessor;
import io.atlasmap.spi.AtlasFieldAction;
import io.atlasmap.v2.AbsoluteValue;
import io.atlasmap.v2.Add;
import io.atlasmap.v2.AreaUnitType;
import io.atlasmap.v2.Average;
import io.atlasmap.v2.Ceiling;
import io.atlasmap.v2.ConvertAreaUnit;
import io.atlasmap.v2.ConvertDistanceUnit;
import io.atlasmap.v2.ConvertMassUnit;
import io.atlasmap.v2.ConvertVolumeUnit;
import io.atlasmap.v2.DistanceUnitType;
import io.atlasmap.v2.Divide;
import io.atlasmap.v2.Floor;
import io.atlasmap.v2.MassUnitType;
import io.atlasmap.v2.Maximum;
import io.atlasmap.v2.Minimum;
import io.atlasmap.v2.Multiply;
import io.atlasmap.v2.Round;
import io.atlasmap.v2.Subtract;
import io.atlasmap.v2.VolumeUnitType;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberFieldActions
implements AtlasFieldAction {
    private static final Logger LOG = LoggerFactory.getLogger(NumberFieldActions.class);
    private static final double KILO_GRAMS_IN_A_POUND = 0.45359237;
    private static final double YARDS_IN_A_MILE = 1760.0;
    private static final double FEET_IN_A_YARD = 3.0;
    private static final double INCHES_IN_A_FOOT = 12.0;
    private static final double METERS_IN_A_INCH = 0.0254;
    private static final double SQUARE_FEET_IN_A_SQUARE_METER = Math.pow(3.2808398950131235, 2.0);
    private static final double SQUARE_METERS_IN_A_SQUARE_MILE = Math.pow(1609.3439999999998, 2.0);
    private static final double SQUARE_FEET_IN_A_SQUARE_MILE = Math.pow(5280.0, 2.0);
    private static final double LITERS_IN_A_CUBIC_METER = 1000.0;
    private static final double CUBIC_FEET_IN_A_CUBIC_METER = Math.pow(3.2808398950131235, 3.0);
    private static final double GALLONS_US_FLUID_IN_A_CUBIC_METER = 264.17205236;
    private static Map<MassUnitType, Map<MassUnitType, Double>> massConvertionTable;
    private static Map<DistanceUnitType, Map<DistanceUnitType, Double>> distanceConvertionTable;
    private static Map<AreaUnitType, Map<AreaUnitType, Double>> areaConvertionTable;
    private static Map<VolumeUnitType, Map<VolumeUnitType, Double>> volumeConvertionTable;

    @AtlasActionProcessor
    public static Number absoluteValue(AbsoluteValue action, Number input) {
        if (input == null) {
            return 0;
        }
        if (input instanceof BigDecimal) {
            return ((BigDecimal)input).abs();
        }
        if (NumberFieldActions.requiresDoubleResult(input)) {
            return Math.abs(input.doubleValue());
        }
        return Math.abs(input.longValue());
    }

    @AtlasActionProcessor
    public static Number add(Add action, List<Number> inputs) {
        if (inputs == null) {
            return 0;
        }
        Number sum = 0L;
        for (Number entry : inputs) {
            if (entry instanceof Number) {
                if (sum instanceof BigDecimal) {
                    sum = ((BigDecimal)sum).add(BigDecimal.valueOf(entry.doubleValue()));
                    continue;
                }
                if (entry instanceof BigDecimal) {
                    sum = BigDecimal.valueOf(sum.doubleValue()).add((BigDecimal)entry);
                    continue;
                }
                if (NumberFieldActions.requiresDoubleResult(sum) || NumberFieldActions.requiresDoubleResult(entry)) {
                    sum = sum.doubleValue() + entry.doubleValue();
                    continue;
                }
                sum = sum.longValue() + entry.longValue();
                continue;
            }
            NumberFieldActions.warnIgnoringValue("Add", entry);
        }
        return sum;
    }

    @AtlasActionProcessor
    public static Number average(Average action, List<Number> inputs) {
        if (inputs == null) {
            return 0;
        }
        return NumberFieldActions.add(null, inputs).doubleValue() / (double)inputs.size();
    }

    @AtlasActionProcessor
    public static Number ceiling(Ceiling action, Number input) {
        return input == null ? 0L : (long)Math.ceil(input.doubleValue());
    }

    @AtlasActionProcessor
    public static Number convertMassUnit(ConvertMassUnit convertMassUnit, Number input) {
        if (input == null) {
            return 0;
        }
        if (convertMassUnit == null || convertMassUnit.getFromUnit() == null || convertMassUnit.getToUnit() == null) {
            throw new IllegalArgumentException("ConvertMassUnit must be specified  with fromUnit and toUnit");
        }
        MassUnitType fromUnit = convertMassUnit.getFromUnit();
        MassUnitType toUnit = convertMassUnit.getToUnit();
        double rate = massConvertionTable.get(fromUnit).get(toUnit);
        return NumberFieldActions.doMultiply(input, rate);
    }

    @AtlasActionProcessor
    public static Number convertDistanceUnit(ConvertDistanceUnit convertDistanceUnit, Number input) {
        if (input == null) {
            return 0;
        }
        if (convertDistanceUnit == null || convertDistanceUnit.getFromUnit() == null || convertDistanceUnit.getToUnit() == null) {
            throw new IllegalArgumentException("ConvertDistanceUnit must be specified  with fromUnit and toUnit");
        }
        DistanceUnitType fromUnit = convertDistanceUnit.getFromUnit();
        DistanceUnitType toUnit = convertDistanceUnit.getToUnit();
        double rate = distanceConvertionTable.get(fromUnit).get(toUnit);
        return NumberFieldActions.doMultiply(input, rate);
    }

    @AtlasActionProcessor
    public static Number convertAreaUnit(ConvertAreaUnit convertAreaUnit, Number input) {
        if (input == null) {
            return 0;
        }
        if (convertAreaUnit == null || convertAreaUnit.getFromUnit() == null || convertAreaUnit.getToUnit() == null) {
            throw new IllegalArgumentException("ConvertAreaUnit must be specified  with fromUnit and toUnit");
        }
        AreaUnitType fromUnit = convertAreaUnit.getFromUnit();
        AreaUnitType toUnit = convertAreaUnit.getToUnit();
        double rate = areaConvertionTable.get(fromUnit).get(toUnit);
        return NumberFieldActions.doMultiply(input, rate);
    }

    @AtlasActionProcessor
    public static Number convertVolumeUnit(ConvertVolumeUnit convertVolumeUnit, Number input) {
        if (input == null) {
            return 0;
        }
        if (convertVolumeUnit == null || convertVolumeUnit.getFromUnit() == null || convertVolumeUnit.getToUnit() == null) {
            throw new IllegalArgumentException("ConvertVolumeUnit must be specified  with fromUnit and toUnit");
        }
        VolumeUnitType fromUnit = convertVolumeUnit.getFromUnit();
        VolumeUnitType toUnit = convertVolumeUnit.getToUnit();
        double rate = volumeConvertionTable.get(fromUnit).get(toUnit);
        return NumberFieldActions.doMultiply(input, rate);
    }

    @AtlasActionProcessor
    public static Number divide(Divide divide, List<Number> inputs) {
        if (inputs == null) {
            return 0;
        }
        Number quotient = null;
        for (Number entry : inputs) {
            if (entry instanceof Number) {
                if (quotient == null) {
                    quotient = entry;
                    continue;
                }
                if (quotient instanceof BigDecimal) {
                    quotient = ((BigDecimal)quotient).divide(BigDecimal.valueOf(entry.doubleValue()));
                    continue;
                }
                if (entry instanceof BigDecimal) {
                    quotient = BigDecimal.valueOf(quotient.doubleValue()).divide((BigDecimal)entry);
                    continue;
                }
                quotient = quotient.doubleValue() / entry.doubleValue();
                continue;
            }
            NumberFieldActions.warnIgnoringValue("Divide", entry);
        }
        return quotient;
    }

    @AtlasActionProcessor
    public static Number floor(Floor floor, Number input) {
        return input == null ? 0L : (long)Math.floor(input.doubleValue());
    }

    @AtlasActionProcessor
    public static Number maximum(Maximum maximum, List<Number> inputs) {
        if (inputs == null) {
            return 0;
        }
        Number max = null;
        for (Number entry : inputs) {
            if (entry instanceof Number) {
                if (max instanceof BigDecimal && entry instanceof BigDecimal) {
                    max = ((BigDecimal)entry).max((BigDecimal)max);
                    continue;
                }
                if (max != null && !(entry.doubleValue() > max.doubleValue())) continue;
                max = entry;
                continue;
            }
            NumberFieldActions.warnIgnoringValue("Maximum", entry);
        }
        return max;
    }

    @AtlasActionProcessor
    public static Number minimum(Minimum minimum, List<Number> inputs) {
        if (inputs == null) {
            return 0;
        }
        Number min = null;
        for (Number entry : inputs) {
            if (entry instanceof Number) {
                if (min instanceof BigDecimal && entry instanceof BigDecimal) {
                    min = ((BigDecimal)entry).min((BigDecimal)min);
                    continue;
                }
                if (min != null && !(entry.doubleValue() < min.doubleValue())) continue;
                min = entry;
                continue;
            }
            NumberFieldActions.warnIgnoringValue("Minimum", entry);
        }
        return min;
    }

    @AtlasActionProcessor
    public static Number multiply(Multiply multiply, List<Number> inputs) {
        if (inputs == null) {
            return 0;
        }
        Number product = 1L;
        for (Number entry : inputs) {
            if (entry instanceof Number) {
                if (product instanceof BigDecimal) {
                    product = ((BigDecimal)product).multiply(BigDecimal.valueOf(entry.doubleValue()));
                    continue;
                }
                if (entry instanceof BigDecimal) {
                    product = BigDecimal.valueOf(product.doubleValue()).multiply((BigDecimal)entry);
                    continue;
                }
                if (NumberFieldActions.requiresDoubleResult(product) || NumberFieldActions.requiresDoubleResult(entry)) {
                    product = product.doubleValue() * entry.doubleValue();
                    continue;
                }
                product = product.longValue() * entry.longValue();
                continue;
            }
            NumberFieldActions.warnIgnoringValue("Multiply", entry);
        }
        return product;
    }

    @AtlasActionProcessor
    public static Number round(Round action, Number input) {
        return input == null ? 0L : Math.round(input.doubleValue());
    }

    @AtlasActionProcessor
    public static Number subtract(Subtract subtract, List<Number> inputs) {
        if (inputs == null) {
            return 0;
        }
        Number difference = null;
        for (Number entry : inputs) {
            if (entry instanceof Number) {
                if (difference == null) {
                    difference = entry;
                    continue;
                }
                if (difference instanceof BigDecimal) {
                    difference = ((BigDecimal)difference).subtract(BigDecimal.valueOf(entry.doubleValue()));
                    continue;
                }
                if (entry instanceof BigDecimal) {
                    difference = BigDecimal.valueOf(difference.doubleValue()).subtract((BigDecimal)entry);
                    continue;
                }
                if (NumberFieldActions.requiresDoubleResult(difference) || NumberFieldActions.requiresDoubleResult(entry)) {
                    difference = difference.doubleValue() - entry.doubleValue();
                    continue;
                }
                difference = difference.longValue() - entry.longValue();
                continue;
            }
            NumberFieldActions.warnIgnoringValue("Subtract", entry);
        }
        return difference;
    }

    private static Number doMultiply(Number input, double rate) {
        if (input instanceof BigDecimal) {
            return ((BigDecimal)input).multiply(BigDecimal.valueOf(rate));
        }
        return input.doubleValue() * rate;
    }

    private static boolean requiresDoubleResult(Object object) {
        return object instanceof Double || object instanceof Float;
    }

    private static void warnIgnoringValue(String action, Object value) {
        LOG.warn("The source collection/arry/map must only contain numbers for '{}' transformation - ignoring '{}'", (Object)action, value != null ? value : "null");
    }

    static {
        EnumMap rootTable = new EnumMap(MassUnitType.class);
        EnumMap<MassUnitType, Double> kgRates = new EnumMap<MassUnitType, Double>(MassUnitType.class);
        kgRates.put(MassUnitType.KILOGRAM_KG, 1.0);
        kgRates.put(MassUnitType.POUND_LB, 2.2046226218487757);
        rootTable.put(MassUnitType.KILOGRAM_KG, Collections.unmodifiableMap(kgRates));
        EnumMap<MassUnitType, Double> lbsRates = new EnumMap<MassUnitType, Double>(MassUnitType.class);
        lbsRates.put(MassUnitType.KILOGRAM_KG, 0.45359237);
        lbsRates.put(MassUnitType.POUND_LB, 1.0);
        rootTable.put(MassUnitType.POUND_LB, Collections.unmodifiableMap(lbsRates));
        massConvertionTable = Collections.unmodifiableMap(rootTable);
        rootTable = new EnumMap(DistanceUnitType.class);
        EnumMap<DistanceUnitType, Double> mRates = new EnumMap<DistanceUnitType, Double>(DistanceUnitType.class);
        mRates.put(DistanceUnitType.METER_M, 1.0);
        mRates.put(DistanceUnitType.FOOT_FT, 3.2808398950131235);
        mRates.put(DistanceUnitType.YARD_YD, 1.0936132983377078);
        mRates.put(DistanceUnitType.MILE_MI, 6.21371192237334E-4);
        mRates.put(DistanceUnitType.INCH_IN, 39.37007874015748);
        rootTable.put((MassUnitType)DistanceUnitType.METER_M, Collections.unmodifiableMap(mRates));
        EnumMap<DistanceUnitType, Double> ftRates = new EnumMap<DistanceUnitType, Double>(DistanceUnitType.class);
        ftRates.put(DistanceUnitType.METER_M, 0.30479999999999996);
        ftRates.put(DistanceUnitType.FOOT_FT, 1.0);
        ftRates.put(DistanceUnitType.YARD_YD, 0.3333333333333333);
        ftRates.put(DistanceUnitType.MILE_MI, 1.893939393939394E-4);
        ftRates.put(DistanceUnitType.INCH_IN, 12.0);
        rootTable.put((MassUnitType)DistanceUnitType.FOOT_FT, Collections.unmodifiableMap(ftRates));
        EnumMap<DistanceUnitType, Double> ydRates = new EnumMap<DistanceUnitType, Double>(DistanceUnitType.class);
        ydRates.put(DistanceUnitType.METER_M, 0.9144);
        ydRates.put(DistanceUnitType.FOOT_FT, 3.0);
        ydRates.put(DistanceUnitType.YARD_YD, 1.0);
        ydRates.put(DistanceUnitType.MILE_MI, 5.681818181818182E-4);
        ydRates.put(DistanceUnitType.INCH_IN, 36.0);
        rootTable.put((MassUnitType)DistanceUnitType.YARD_YD, Collections.unmodifiableMap(ydRates));
        EnumMap<DistanceUnitType, Double> miRates = new EnumMap<DistanceUnitType, Double>(DistanceUnitType.class);
        miRates.put(DistanceUnitType.METER_M, 1609.3439999999998);
        miRates.put(DistanceUnitType.FOOT_FT, 5280.0);
        miRates.put(DistanceUnitType.YARD_YD, 1760.0);
        miRates.put(DistanceUnitType.MILE_MI, 1.0);
        miRates.put(DistanceUnitType.INCH_IN, 63360.0);
        rootTable.put((MassUnitType)DistanceUnitType.MILE_MI, Collections.unmodifiableMap(miRates));
        EnumMap<DistanceUnitType, Double> inRates = new EnumMap<DistanceUnitType, Double>(DistanceUnitType.class);
        inRates.put(DistanceUnitType.METER_M, 0.0254);
        inRates.put(DistanceUnitType.FOOT_FT, 0.08333333333333333);
        inRates.put(DistanceUnitType.YARD_YD, 0.027777777777777776);
        inRates.put(DistanceUnitType.MILE_MI, 1.5782828282828283E-5);
        inRates.put(DistanceUnitType.INCH_IN, 1.0);
        rootTable.put((MassUnitType)DistanceUnitType.INCH_IN, Collections.unmodifiableMap(inRates));
        distanceConvertionTable = Collections.unmodifiableMap(rootTable);
        rootTable = new EnumMap(AreaUnitType.class);
        EnumMap<AreaUnitType, Double> m2Rates = new EnumMap<AreaUnitType, Double>(AreaUnitType.class);
        m2Rates.put(AreaUnitType.SQUARE_METER, 1.0);
        m2Rates.put(AreaUnitType.SQUARE_FOOT, SQUARE_FEET_IN_A_SQUARE_METER);
        m2Rates.put(AreaUnitType.SQUARE_MILE, 1.0 / SQUARE_METERS_IN_A_SQUARE_MILE);
        rootTable.put((MassUnitType)AreaUnitType.SQUARE_METER, Collections.unmodifiableMap(m2Rates));
        EnumMap<AreaUnitType, Double> ft2Rates = new EnumMap<AreaUnitType, Double>(AreaUnitType.class);
        ft2Rates.put(AreaUnitType.SQUARE_METER, 1.0 / SQUARE_FEET_IN_A_SQUARE_METER);
        ft2Rates.put(AreaUnitType.SQUARE_FOOT, 1.0);
        ft2Rates.put(AreaUnitType.SQUARE_MILE, 1.0 / SQUARE_FEET_IN_A_SQUARE_MILE);
        rootTable.put((MassUnitType)AreaUnitType.SQUARE_FOOT, Collections.unmodifiableMap(ft2Rates));
        EnumMap<AreaUnitType, Double> mi2Rates = new EnumMap<AreaUnitType, Double>(AreaUnitType.class);
        mi2Rates.put(AreaUnitType.SQUARE_METER, SQUARE_METERS_IN_A_SQUARE_MILE);
        mi2Rates.put(AreaUnitType.SQUARE_FOOT, SQUARE_FEET_IN_A_SQUARE_MILE);
        mi2Rates.put(AreaUnitType.SQUARE_MILE, 1.0);
        rootTable.put((MassUnitType)AreaUnitType.SQUARE_MILE, Collections.unmodifiableMap(mi2Rates));
        areaConvertionTable = Collections.unmodifiableMap(rootTable);
        rootTable = new EnumMap(VolumeUnitType.class);
        EnumMap<VolumeUnitType, Double> m3Rates = new EnumMap<VolumeUnitType, Double>(VolumeUnitType.class);
        m3Rates.put(VolumeUnitType.CUBIC_METER, 1.0);
        m3Rates.put(VolumeUnitType.LITER, 1000.0);
        m3Rates.put(VolumeUnitType.CUBIC_FOOT, CUBIC_FEET_IN_A_CUBIC_METER);
        m3Rates.put(VolumeUnitType.GALLON_US_FLUID, 264.17205236);
        rootTable.put((MassUnitType)VolumeUnitType.CUBIC_METER, Collections.unmodifiableMap(m3Rates));
        EnumMap<VolumeUnitType, Double> literRates = new EnumMap<VolumeUnitType, Double>(VolumeUnitType.class);
        literRates.put(VolumeUnitType.CUBIC_METER, 0.001);
        literRates.put(VolumeUnitType.LITER, 1.0);
        literRates.put(VolumeUnitType.CUBIC_FOOT, 0.001 * CUBIC_FEET_IN_A_CUBIC_METER);
        literRates.put(VolumeUnitType.GALLON_US_FLUID, 0.26417205236);
        rootTable.put((MassUnitType)VolumeUnitType.LITER, Collections.unmodifiableMap(literRates));
        EnumMap<VolumeUnitType, Double> cftRates = new EnumMap<VolumeUnitType, Double>(VolumeUnitType.class);
        cftRates.put(VolumeUnitType.CUBIC_METER, 1.0 / CUBIC_FEET_IN_A_CUBIC_METER);
        cftRates.put(VolumeUnitType.LITER, 1.0 / CUBIC_FEET_IN_A_CUBIC_METER * 1000.0);
        cftRates.put(VolumeUnitType.CUBIC_FOOT, 1.0);
        cftRates.put(VolumeUnitType.GALLON_US_FLUID, 1.0 / CUBIC_FEET_IN_A_CUBIC_METER * 264.17205236);
        rootTable.put((MassUnitType)VolumeUnitType.CUBIC_FOOT, Collections.unmodifiableMap(cftRates));
        EnumMap<VolumeUnitType, Double> galUsFluidRates = new EnumMap<VolumeUnitType, Double>(VolumeUnitType.class);
        galUsFluidRates.put(VolumeUnitType.CUBIC_METER, 0.003785411783973468);
        galUsFluidRates.put(VolumeUnitType.LITER, 3.785411783973468);
        galUsFluidRates.put(VolumeUnitType.CUBIC_FOOT, 0.003785411783973468 * CUBIC_FEET_IN_A_CUBIC_METER);
        galUsFluidRates.put(VolumeUnitType.GALLON_US_FLUID, 1.0);
        rootTable.put((MassUnitType)VolumeUnitType.GALLON_US_FLUID, Collections.unmodifiableMap(galUsFluidRates));
        volumeConvertionTable = Collections.unmodifiableMap(rootTable);
    }
}

