/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.spi.AtlasConverter;
import io.atlasmap.v2.FieldType;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class SqlTimeConverter
implements AtlasConverter<Time> {
    @AtlasConversionInfo(sourceType=FieldType.TIME, targetType=FieldType.DATE_TIME_TZ)
    public Calendar toCalendar(Time time, String sourceFormat, String targetFormat) {
        return time != null ? GregorianCalendar.from(ZonedDateTime.ofInstant(Instant.ofEpochMilli(time.getTime()), ZoneId.systemDefault())) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.TIME, targetType=FieldType.DATE_TIME)
    public Date toDate(Time time, String sourceFormat, String targetFormat) {
        return time != null ? new Date(time.getTime()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.TIME, targetType=FieldType.DATE_TIME_TZ)
    public GregorianCalendar toGregorianCalendar(Time time, String sourceFormat, String targetFormat) {
        return time != null ? GregorianCalendar.from(ZonedDateTime.ofInstant(Instant.ofEpochMilli(time.getTime()), ZoneId.systemDefault())) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.TIME, targetType=FieldType.TIME)
    public LocalTime toLocalTime(Time time, String sourceFormat, String targetFormat) {
        return time != null ? time.toLocalTime() : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.TIME, targetType=FieldType.DATE_TIME)
    public LocalDateTime toLocalDateTime(Time time, String sourceFormat, String targetFormat) {
        return time != null ? time.toLocalTime().atDate(LocalDate.now()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.TIME, targetType=FieldType.DATE_TIME)
    public Timestamp toSqlTimestamp(Time time, String sourceFormat, String targetFormat) {
        return time != null ? new Timestamp(time.getTime()) : null;
    }

    @AtlasConversionInfo(sourceType=FieldType.TIME, targetType=FieldType.DATE_TIME_TZ)
    public ZonedDateTime toZonedDateTime(Time time, String sourceFormat, String targetFormat) {
        return time != null ? ZonedDateTime.ofInstant(Instant.ofEpochMilli(time.getTime()), ZoneId.systemDefault()) : null;
    }
}

