/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasPreviewContext;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.BaseAtlasModule;
import io.atlasmap.core.DefaultAtlasContext;
import io.atlasmap.core.DefaultAtlasContextFactory;
import io.atlasmap.core.DefaultAtlasSession;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.spi.AtlasModule;
import io.atlasmap.spi.FieldDirection;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.Audits;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultAtlasPreviewContext
extends DefaultAtlasContext
implements AtlasPreviewContext {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAtlasPreviewContext.class);
    private Mapping mapping;
    private PreviewModule previewModule = new PreviewModule();

    DefaultAtlasPreviewContext(DefaultAtlasContextFactory factory) {
        super(factory, new AtlasMapping());
    }

    @Override
    public Audits processPreview(Mapping mapping) throws AtlasException {
        Field targetField;
        DefaultAtlasSession session = new DefaultAtlasSession(this);
        this.mapping = mapping;
        session.head().setMapping(mapping);
        MappingType mappingType = mapping.getMappingType();
        String expression = mapping.getExpression();
        FieldGroup sourceFieldGroup = mapping.getInputFieldGroup();
        List sourceFields = mapping.getInputField();
        List targetFields = mapping.getOutputField();
        targetFields.forEach(tf -> tf.setValue(null));
        if (sourceFieldGroup == null && sourceFields.isEmpty() || targetFields.isEmpty()) {
            return session.getAudits();
        }
        if (sourceFieldGroup != null) {
            sourceFields = sourceFieldGroup.getField();
        }
        for (Field sf : sourceFields) {
            if (sf.getFieldType() == null || sf.getValue() == null || sf.getValue() instanceof String && ((String)sf.getValue()).isEmpty() || this.restoreSourceFieldType(session, sf)) continue;
            return session.getAudits();
        }
        this.processSourceFieldMapping(session);
        if (session.hasErrors()) {
            return session.getAudits();
        }
        Field sourceField = session.head().getSourceField();
        if (mappingType == null || mappingType == MappingType.MAP) {
            sourceFieldGroup = sourceField instanceof FieldGroup ? (FieldGroup)sourceField : null;
            Iterator iterator = targetFields.iterator();
            while (iterator.hasNext()) {
                Field f;
                targetField = f = (Field)iterator.next();
                session.head().setTargetField(targetField);
                if (sourceFieldGroup != null) {
                    if (sourceFieldGroup.getField().size() == 0) {
                        AtlasUtil.addAudit((AtlasSession)session, targetField.getDocId(), String.format("The group field '%s:%s' Empty group field is detected, skipping", sourceField.getDocId(), sourceField.getPath()), targetField.getPath(), AuditStatus.WARN, null);
                        continue;
                    }
                    Integer index = targetField.getIndex();
                    AtlasPath targetPath = new AtlasPath(targetField.getPath());
                    if (targetPath.hasCollection() && !targetPath.isIndexedCollection()) {
                        if (targetFields.size() > 1) {
                            AtlasUtil.addAudit((AtlasSession)session, targetField.getDocId(), "It's not yet supported to have a collection field as a part of multiple target fields in a same mapping", targetField.getPath(), AuditStatus.ERROR, null);
                            return session.getAudits();
                        }
                        session.head().setSourceField((Field)sourceFieldGroup);
                    } else if (index == null) {
                        session.head().setSourceField((Field)sourceFieldGroup.getField().get(sourceFieldGroup.getField().size() - 1));
                    } else if (sourceFieldGroup.getField().size() > index) {
                        session.head().setSourceField((Field)sourceFieldGroup.getField().get(index));
                    } else {
                        AtlasUtil.addAudit((AtlasSession)session, targetField.getDocId(), String.format("The number of source fields '%s' is fewer than expected via target field index '%s'", sourceFieldGroup.getField().size(), targetField.getIndex()), targetField.getPath(), AuditStatus.WARN, null);
                        continue;
                    }
                }
                if (session.hasErrors()) {
                    return session.getAudits();
                }
                if (!this.convertSourceToTarget(session, session.head().getSourceField(), targetField)) {
                    return session.getAudits();
                }
                Field processed = targetField;
                if (expression == null || expression.isEmpty()) {
                    processed = this.applyFieldActions(session, targetField);
                }
                targetField.setValue(processed.getValue());
            }
        } else if (mappingType == MappingType.COMBINE) {
            targetField = (Field)targetFields.get(0);
            Field combined = this.processCombineField(session, mapping, sourceFields, targetField);
            if (!this.convertSourceToTarget(session, combined, targetField)) {
                return session.getAudits();
            }
            this.applyFieldActions(session, targetField);
        } else if (mappingType == MappingType.SEPARATE) {
            List<Field> separatedFields;
            try {
                separatedFields = this.processSeparateField(session, mapping, sourceField);
            }
            catch (AtlasException e) {
                AtlasUtil.addAudit((AtlasSession)session, sourceField.getDocId(), String.format("Failed to separate field: %s", AtlasUtil.getChainedMessage(e)), sourceField.getPath(), AuditStatus.ERROR, null);
                if (LOG.isDebugEnabled()) {
                    LOG.error("", (Throwable)e);
                }
                return session.getAudits();
            }
            if (separatedFields == null) {
                return session.getAudits();
            }
            for (Field f : targetFields) {
                targetField = f;
                if (targetField.getIndex() == null || targetField.getIndex() < 0) {
                    AtlasUtil.addAudit((AtlasSession)session, targetField.getDocId(), String.format("Separate requires zero or positive Index value to be set on targetField targetField.path=%s", targetField.getPath()), targetField.getPath(), AuditStatus.WARN, null);
                    continue;
                }
                if (separatedFields.size() <= targetField.getIndex()) {
                    String errorMessage = String.format("Separate returned fewer segments count=%s when targetField.path=%s requested index=%s", separatedFields.size(), targetField.getPath(), targetField.getIndex());
                    AtlasUtil.addAudit((AtlasSession)session, targetField.getDocId(), errorMessage, targetField.getPath(), AuditStatus.WARN, null);
                } else if (this.convertSourceToTarget(session, separatedFields.get(targetField.getIndex()), targetField)) {
                    this.applyFieldActions(session, targetField);
                    continue;
                }
                break;
            }
        } else {
            AtlasUtil.addAudit((AtlasSession)session, null, String.format("Unsupported mappingType=%s detected", mapping.getMappingType()), null, AuditStatus.ERROR, null);
        }
        return session.getAudits();
    }

    private boolean restoreSourceFieldType(DefaultAtlasSession session, Field sourceField) throws AtlasException {
        try {
            Object sourceValue = this.getContextFactory().getConversionService().convertType(sourceField.getValue(), null, sourceField.getFieldType(), null);
            sourceField.setValue(sourceValue);
        }
        catch (AtlasConversionException e) {
            AtlasUtil.addAudit((AtlasSession)session, sourceField.getDocId(), String.format("Wrong format for source value : %s", AtlasUtil.getChainedMessage(e)), sourceField.getPath(), AuditStatus.ERROR, null);
            if (LOG.isDebugEnabled()) {
                LOG.error("", (Throwable)e);
            }
            return false;
        }
        return true;
    }

    private boolean convertSourceToTarget(DefaultAtlasSession session, Field sourceField, Field targetField) throws AtlasException {
        Object targetValue = null;
        if (sourceField.getFieldType() != null && sourceField.getFieldType().equals((Object)targetField.getFieldType())) {
            targetValue = sourceField.getValue();
        } else if (sourceField.getValue() != null) {
            try {
                targetValue = this.getContextFactory().getConversionService().convertType(sourceField.getValue(), sourceField.getFormat(), targetField.getFieldType(), targetField.getFormat());
            }
            catch (AtlasConversionException e) {
                AtlasUtil.addAudit((AtlasSession)session, targetField.getDocId(), String.format("Failed to convert source value to target type: %s", AtlasUtil.getChainedMessage(e)), targetField.getPath(), AuditStatus.ERROR, null);
                if (LOG.isDebugEnabled()) {
                    LOG.error("", (Throwable)e);
                }
                return false;
            }
        }
        targetField.setValue(targetValue);
        return true;
    }

    @Override
    public Map<String, AtlasModule> getSourceModules() {
        return new HashMap<String, AtlasModule>(){
            private static final long serialVersionUID = 1L;

            @Override
            public AtlasModule get(Object key) {
                return DefaultAtlasPreviewContext.this.previewModule;
            }
        };
    }

    @Override
    protected AtlasModule resolveModule(FieldDirection direction, Field field) {
        return this.previewModule;
    }

    private class PreviewModule
    extends BaseAtlasModule {
        private PreviewModule() {
        }

        public void readSourceValue(AtlasInternalSession session) throws AtlasException {
            Field sourceField = session.head().getSourceField();
            String docId = sourceField.getDocId();
            String path = sourceField.getPath();
            FieldGroup sourceFieldGroup = DefaultAtlasPreviewContext.this.mapping.getInputFieldGroup();
            if (sourceFieldGroup != null) {
                Field f = this.readFromGroup(sourceFieldGroup, path);
                session.head().setSourceField(f);
                return;
            }
            for (Field f : DefaultAtlasPreviewContext.this.mapping.getInputField()) {
                if (docId == null && f.getDocId() != null || docId != null && f.getDocId() == null || docId != null && !docId.equals(f.getDocId()) || f.getPath() == null || !f.getPath().equals(path)) continue;
                session.head().setSourceField(f);
                return;
            }
        }

        private Field readFromGroup(FieldGroup group, String path) {
            if (group.getField() == null) {
                return null;
            }
            String docId = group.getDocId();
            for (Field f : group.getField()) {
                Field deeper;
                if (docId == null && f.getDocId() != null || docId != null && f.getDocId() == null || docId != null && !docId.equals(f.getDocId())) continue;
                if (f.getPath() != null && f.getPath().equals(path)) {
                    return f;
                }
                if (!(f instanceof FieldGroup) || (deeper = this.readFromGroup((FieldGroup)f, path)) == null) continue;
                return deeper;
            }
            return null;
        }

        public void processPreValidation(AtlasInternalSession session) throws AtlasException {
        }

        public void processPreSourceExecution(AtlasInternalSession session) throws AtlasException {
        }

        public void processPreTargetExecution(AtlasInternalSession session) throws AtlasException {
        }

        public void writeTargetValue(AtlasInternalSession session) throws AtlasException {
        }

        public void processPostSourceExecution(AtlasInternalSession session) throws AtlasException {
        }

        public void processPostTargetExecution(AtlasInternalSession session) throws AtlasException {
        }

        public Field cloneField(Field field) throws AtlasException {
            return null;
        }
    }
}

