/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.functions;

import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.BaseFunctionFactory;
import io.atlasmap.expression.Expression;
import io.atlasmap.expression.parser.ParseException;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SELECT
extends BaseFunctionFactory {
    public Expression create(List<Expression> args) throws ParseException {
        if (args.size() != 2) {
            throw new ParseException("SELECT expects 2 arguments.");
        }
        Expression parentExpression = args.get(0);
        Expression selectExpression = args.get(1);
        return ctx -> {
            Field parent = parentExpression.evaluate(ctx);
            List<Field> collection = parent instanceof FieldGroup ? ((FieldGroup)parent).getField() : Arrays.asList(parent);
            ArrayList<Field> selected = new ArrayList<Field>();
            FieldGroup answer = AtlasModelFactory.createFieldGroupFrom((Field)parent, (boolean)true);
            answer.setPath("$ATLASMAP");
            for (Field f : collection) {
                Field fs = selectExpression.evaluate(subCtx -> {
                    if (subCtx != null && "$ATLASMAP".equals(answer.getPath())) {
                        answer.setPath(parent.getPath() + (subCtx.startsWith("/") ? subCtx : "/" + subCtx));
                    }
                    return AtlasPath.extractChildren(f, subCtx);
                });
                selected.add(fs);
            }
            if (selected.size() == 1) {
                return (Field)selected.get(0);
            }
            answer.getField().addAll(selected);
            return answer;
        };
    }
}

