/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.java.inspect;

import io.atlasmap.java.inspect.ClassInspectionService;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarClassLoader
extends ClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ClassInspectionService.class);
    private URLClassLoader loader;

    public JarClassLoader(String ... paths) {
        HashSet<URL> urls = new HashSet<URL>();
        for (String path : paths) {
            File f = new File(path);
            if (!f.exists()) continue;
            this.populateFileUrl(f, urls);
        }
        this.loader = new URLClassLoader(urls.toArray(new URL[0]));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void populateFileUrl(File file, Set<URL> urls) {
        if (file.isDirectory()) {
            for (File subf : file.listFiles()) {
                this.populateFileUrl(subf, urls);
            }
            return;
        } else {
            if (!file.getName().toLowerCase().endsWith(".jar")) return;
            try {
                urls.add(file.toURI().toURL());
                return;
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) return;
                LOG.debug("Ignoring invalid file name: {}", (Object)file.getName());
            }
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loader.loadClass(name);
    }

    @Override
    public URL getResource(String name) {
        return this.loader.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.loader.getResourceAsStream(name);
    }
}

