/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.s3;

import io.awspring.cloud.s3.Location;
import io.awspring.cloud.s3.ObjectMetadata;
import io.awspring.cloud.s3.S3ObjectContentTypeResolver;
import io.awspring.cloud.s3.S3OutputStream;
import io.awspring.cloud.s3.S3OutputStreamProvider;
import io.awspring.cloud.s3.TransferManagerS3OutputStream;
import java.io.IOException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import software.amazon.awssdk.transfer.s3.S3TransferManager;

public class TransferManagerS3OutputStreamProvider
implements S3OutputStreamProvider {
    private final S3TransferManager s3TransferManager;
    @Nullable
    private final S3ObjectContentTypeResolver contentTypeResolver;

    public TransferManagerS3OutputStreamProvider(S3TransferManager s3TransferManager, @Nullable S3ObjectContentTypeResolver contentTypeResolver) {
        Assert.notNull((Object)s3TransferManager, (String)"s3TransferManager is required");
        this.s3TransferManager = s3TransferManager;
        this.contentTypeResolver = contentTypeResolver;
    }

    @Override
    public S3OutputStream create(String bucket, String key, @Nullable ObjectMetadata metadata) throws IOException {
        return new TransferManagerS3OutputStream(new Location(bucket, key, null), this.s3TransferManager, metadata, this.contentTypeResolver);
    }
}

