/*
 * Decompiled with CFR 0.152.
 */
package io.beanmapper.spring.converter;

import io.beanmapper.BeanMapper;
import io.beanmapper.core.BeanPropertyMatch;
import io.beanmapper.core.converter.BeanConverter;
import javax.persistence.EntityNotFoundException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.support.Repositories;

public class IdToEntityBeanConverter
implements BeanConverter {
    private final Repositories repositories;

    public IdToEntityBeanConverter(ApplicationContext applicationContext) {
        this.repositories = new Repositories((ListableBeanFactory)applicationContext);
    }

    public Object convert(BeanMapper beanMapper, Object source, Class<?> targetClass, BeanPropertyMatch beanFieldMatch) {
        if (source == null) {
            return null;
        }
        CrudRepository repository = (CrudRepository)this.repositories.getRepositoryFor(targetClass).orElseThrow(() -> new EntityNotFoundException("No repository found for " + targetClass.getName()));
        return repository.findById(source).orElse(null);
    }

    public boolean match(Class<?> sourceClass, Class<?> targetClass) {
        if (targetClass.isAssignableFrom(sourceClass)) {
            return false;
        }
        if (!this.repositories.hasRepositoryFor(targetClass)) {
            return false;
        }
        boolean match = false;
        EntityInformation information = this.repositories.getEntityInformationFor(targetClass);
        if (information != null) {
            match = sourceClass.equals(information.getIdType());
        }
        return match;
    }
}

