/*
 * Decompiled with CFR 0.152.
 */
package io.beanmapper.spring.web;

import io.beanmapper.BeanMapper;
import io.beanmapper.spring.web.EntityFinder;
import io.beanmapper.spring.web.MergedForm;

public class MergePair<T> {
    private T beforeMerge;
    private T afterMerge;
    private final BeanMapper beanMapper;
    private final EntityFinder entityFinder;
    private final Class<?> entityClass;
    private final MergedForm annotation;

    public MergePair(BeanMapper beanMapper, EntityFinder entityFinder, Class<?> entityClass, MergedForm annotation) {
        this.beanMapper = beanMapper;
        this.entityFinder = entityFinder;
        this.entityClass = entityClass;
        this.annotation = annotation;
    }

    public void initNew(Object source) {
        this.setAfterMerge(this.beanMapper.map(source, this.targetEntityClass()));
    }

    public void merge(Object source, Long id) {
        if (this.isMergePair()) {
            this.setBeforeMerge(this.entityFinder.findAndDetach(id, this.targetEntityClass()));
        }
        T target = this.entityFinder.find(id, this.targetEntityClass());
        this.setAfterMerge(this.beanMapper.map(source, target));
    }

    public T getBeforeMerge() {
        return this.beforeMerge;
    }

    public T getAfterMerge() {
        return this.afterMerge;
    }

    public Object result() {
        return this.isMergePair() ? this : this.getAfterMerge();
    }

    private boolean isMergePair() {
        return this.entityClass.equals(MergePair.class);
    }

    private Class<T> targetEntityClass() {
        return this.isMergePair() ? this.annotation.mergePairClass() : this.entityClass;
    }

    private void setBeforeMerge(T beforeMerge) {
        this.beforeMerge = beforeMerge;
    }

    private void setAfterMerge(T afterMerge) {
        this.afterMerge = afterMerge;
    }
}

