/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authorizer.provider;

import io.confluent.security.authorizer.AuthorizeResult;
import io.confluent.security.authorizer.provider.AuditLogProvider;
import io.confluent.security.authorizer.provider.AuthorizationLogData;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.UnaryOperator;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuditLogProvider
implements AuditLogProvider {
    protected static final Logger log = LoggerFactory.getLogger((String)"kafka.authorizer.logger");
    protected UnaryOperator<AuthorizationLogData> sanitizer;

    public void configure(Map<String, ?> configs) {
    }

    public Set<String> reconfigurableConfigs() {
        return Collections.emptySet();
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
    }

    public void reconfigure(Map<String, ?> configs) {
    }

    @Override
    public CompletionStage<Void> start(AuthorizerServerInfo serverInfo, Map<String, ?> interBrokerListenerConfigs) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public String providerName() {
        return "DEFAULT";
    }

    @Override
    public boolean usesMetadataFromThisKafkaCluster() {
        return false;
    }

    @Override
    public boolean providerConfigured(Map<String, ?> configs) {
        return true;
    }

    @Override
    public void setSanitizer(UnaryOperator<AuthorizationLogData> sanitizer) {
        this.sanitizer = sanitizer;
    }

    @Override
    public void logAuthorization(AuthorizationLogData data) {
        if (this.sanitizer != null) {
            data = (AuthorizationLogData)this.sanitizer.apply(data);
        }
        String logMessage = "Principal = {} is {} Operation = {} from host = {} on resource = {}";
        KafkaPrincipal principal = data.requestContext.principal();
        String host = data.requestContext.clientAddress().getHostAddress();
        String operation = data.action.operation().name();
        String resource = SecurityUtils.toPascalCase((String)data.action.resourceType().name()) + ":" + data.action.resourcePattern().patternType() + ":" + data.action.resourceName();
        if (data.authorizeResult == AuthorizeResult.ALLOWED) {
            if (data.action.logIfAllowed()) {
                log.debug(logMessage, new Object[]{principal, "Allowed", operation, host, resource});
            } else {
                log.trace(logMessage, new Object[]{principal, "Allowed", operation, host, resource});
            }
        } else if (data.action.logIfDenied()) {
            log.info(logMessage, new Object[]{principal, "Denied", operation, host, resource});
        } else {
            log.trace(logMessage, new Object[]{principal, "Denied", operation, host, resource});
        }
    }

    @Override
    public void close() throws IOException {
    }
}

