/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authorizer.provider;

import io.confluent.security.authorizer.provider.AccessRuleProvider;
import io.confluent.security.authorizer.provider.GroupProvider;
import io.confluent.security.authorizer.provider.MetadataProvider;
import io.confluent.security.authorizer.provider.Provider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Utils;

public class ConfluentBuiltInProviders {
    private static final Map<String, String> OLD_PROVIDER_NAMES = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"ACL", (Object)AccessRuleProviders.ZK_ACL.name()), Utils.mkEntry((Object)"RBAC", (Object)AccessRuleProviders.CONFLUENT.name())});

    public static Set<String> builtInAccessRuleProviders() {
        return Utils.mkSet((Object[])AccessRuleProviders.values()).stream().map(Enum::name).collect(Collectors.toSet());
    }

    public static List<AccessRuleProvider> loadAccessRuleProviders(List<String> names) {
        HashMap<String, AccessRuleProvider> authProviders = new HashMap<String, AccessRuleProvider>(names.size());
        ServiceLoader<AccessRuleProvider> providers = ServiceLoader.load(AccessRuleProvider.class);
        for (AccessRuleProvider provider : providers) {
            String name2 = provider.providerName();
            if (names.contains(name2)) {
                authProviders.putIfAbsent(name2, provider);
            }
            if (authProviders.size() != names.size()) continue;
            break;
        }
        if (authProviders.size() != names.size()) {
            HashSet<String> remainingNames = new HashSet<String>(names);
            remainingNames.removeAll(authProviders.keySet());
            if (OLD_PROVIDER_NAMES.keySet().containsAll(remainingNames)) {
                StringBuilder error = new StringBuilder();
                remainingNames.forEach(name -> {
                    error.append((String)name);
                    error.append(" is supported by the provider named ");
                    error.append(OLD_PROVIDER_NAMES.get(name));
                    error.append(", ");
                });
                error.append("you should configure '");
                error.append("confluent.authorizer.access.rule.providers");
                error.append('=');
                Collection newProviders = names.stream().map(OLD_PROVIDER_NAMES::get).collect(Collectors.toSet());
                error.append(Utils.join((Collection)newProviders, (String)","));
                error.append("'");
                throw new ConfigException(error.toString());
            }
            throw new ConfigException("Access rule provider not found for " + remainingNames);
        }
        return names.stream().map(authProviders::get).collect(Collectors.toList());
    }

    public static GroupProvider loadGroupProvider(Map<String, ?> configs) {
        ServiceLoader<GroupProvider> providers = ServiceLoader.load(GroupProvider.class);
        for (GroupProvider provider : providers) {
            if (!ConfluentBuiltInProviders.providerEnabled(provider, configs) || !provider.providerConfigured(configs)) continue;
            return provider;
        }
        return new EmptyGroupProvider();
    }

    public static MetadataProvider loadMetadataProvider(Map<String, ?> configs) {
        ServiceLoader<MetadataProvider> providers = ServiceLoader.load(MetadataProvider.class);
        for (MetadataProvider provider : providers) {
            if (!ConfluentBuiltInProviders.providerEnabled(provider, configs) || !provider.providerConfigured(configs)) continue;
            return provider;
        }
        return new EmptyMetadataProvider();
    }

    private static boolean providerEnabled(Provider provider, Map<String, ?> configs) {
        String providerName = provider.providerName();
        Object accessRuleProviders = configs.get("confluent.authorizer.access.rule.providers");
        if (provider.providerName().equals("LDAP")) {
            return String.valueOf(configs.get("authorizer.class.name")).endsWith(".LdapAuthorizer");
        }
        if (accessRuleProviders == null) {
            return false;
        }
        if (accessRuleProviders instanceof String) {
            return Arrays.stream(((String)accessRuleProviders).split(",")).anyMatch(providerName::equals);
        }
        if (accessRuleProviders instanceof List) {
            return ((List)accessRuleProviders).stream().anyMatch(providerName::equals);
        }
        return false;
    }

    private static class EmptyMetadataProvider
    implements MetadataProvider {
        private EmptyMetadataProvider() {
        }

        public void configure(Map<String, ?> configs) {
        }

        @Override
        public String providerName() {
            return MetadataProviders.NONE.name();
        }

        @Override
        public boolean usesMetadataFromThisKafkaCluster() {
            return false;
        }

        @Override
        public boolean providerConfigured(Map<String, ?> configs) {
            return true;
        }

        @Override
        public void close() {
        }
    }

    private static class EmptyGroupProvider
    implements GroupProvider {
        private EmptyGroupProvider() {
        }

        public void configure(Map<String, ?> configs) {
        }

        @Override
        public Set<KafkaPrincipal> groups(KafkaPrincipal sessionPrincipal) {
            return Collections.emptySet();
        }

        @Override
        public boolean usesMetadataFromThisKafkaCluster() {
            return false;
        }

        @Override
        public String providerName() {
            return GroupProviders.NONE.name();
        }

        @Override
        public boolean providerConfigured(Map<String, ?> configs) {
            return true;
        }

        @Override
        public void close() {
        }
    }

    public static enum MetadataProviders {
        CONFLUENT,
        NONE;

    }

    public static enum GroupProviders {
        LDAP,
        CONFLUENT,
        NONE;

    }

    public static enum AccessRuleProviders {
        ZK_ACL,
        MULTI_TENANT,
        CONFLUENT;

    }
}

