/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authorizer;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.security.authorizer.ResourcePatternFilter;
import io.confluent.security.roledefinitions.ResourceType;
import java.util.Objects;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.utils.SecurityUtils;

public class ResourcePattern
implements Comparable<ResourcePattern> {
    public static final ResourcePattern ALL = new ResourcePattern(ResourceType.ALL, "*", PatternType.LITERAL);
    private final String name;
    private final ResourceType resourceType;
    private final PatternType patternType;

    public ResourcePattern(String type, String name, PatternType patternType) {
        this(ResourceType.resourceType((String)type), name, patternType);
    }

    public ResourcePattern(@JsonProperty(value="resourceType") ResourceType resourceType, @JsonInclude(value=JsonInclude.Include.NON_NULL) @JsonProperty(value="name") String name, @JsonProperty(value="patternType") PatternType patternType) {
        this.name = Objects.requireNonNull(name, "name");
        this.resourceType = Objects.requireNonNull(resourceType, "resourceType");
        this.patternType = patternType == null ? PatternType.LITERAL : patternType;
    }

    @JsonProperty
    public String name() {
        return this.name;
    }

    @JsonProperty
    public ResourceType resourceType() {
        return this.resourceType;
    }

    @JsonProperty
    public PatternType patternType() {
        return this.patternType;
    }

    public ResourcePatternFilter toFilter() {
        return new ResourcePatternFilter(this.resourceType, this.name, this.patternType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourcePattern)) {
            return false;
        }
        ResourcePattern that = (ResourcePattern)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.resourceType, that.resourceType) && Objects.equals(this.patternType, that.patternType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.resourceType, this.patternType.name());
    }

    @Override
    public int compareTo(ResourcePattern other) {
        int result = this.resourceType().name().compareTo(other.resourceType().name());
        if (result == 0 && (result = this.patternType().compareTo((Enum)other.patternType())) == 0) {
            result = other.name().compareTo(this.name());
        }
        return result;
    }

    public String toString() {
        return String.format("%s:%s:%s", this.resourceType, this.patternType, this.name);
    }

    public static ResourcePattern all(ResourceType resourceType) {
        return new ResourcePattern(resourceType, "*", PatternType.LITERAL);
    }

    public static ResourcePattern from(org.apache.kafka.common.resource.ResourcePattern resourcePattern) {
        return new ResourcePattern(SecurityUtils.toPascalCase((String)resourcePattern.resourceType().name()), resourcePattern.name(), resourcePattern.patternType());
    }

    public static org.apache.kafka.common.resource.ResourcePattern to(ResourcePattern resourcePattern) {
        return new org.apache.kafka.common.resource.ResourcePattern(SecurityUtils.resourceType((String)resourcePattern.resourceType.name()), resourcePattern.name(), resourcePattern.patternType());
    }

    public static ResourcePattern from(org.apache.kafka.common.resource.ResourcePatternFilter resourcePattern) {
        return new ResourcePattern(SecurityUtils.toPascalCase((String)resourcePattern.resourceType().name()), resourcePattern.name(), resourcePattern.patternType());
    }
}

