/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authorizer.provider;

import io.confluent.security.authorizer.AccessRule;
import io.confluent.security.roledefinitions.PermissionType;
import java.util.HashMap;
import java.util.Map;

public class ResourceAuthorizeRules {
    private Map<String, AccessRule> allowLiteralRules = new HashMap<String, AccessRule>();
    private Map<String, AccessRule> denyLiteralRules = new HashMap<String, AccessRule>();
    private Map<String, AccessRule> allowPrefixedRules = new HashMap<String, AccessRule>();
    private Map<String, AccessRule> denyPrefixedRules = new HashMap<String, AccessRule>();

    public Map<String, AccessRule> allowLiteralRules() {
        return this.allowLiteralRules;
    }

    public Map<String, AccessRule> denyLiteralRules() {
        return this.denyLiteralRules;
    }

    public Map<String, AccessRule> allowPrefixedRules() {
        return this.allowPrefixedRules;
    }

    public Map<String, AccessRule> denyPrefixedRules() {
        return this.denyPrefixedRules;
    }

    public void addRuleIfNotExist(AccessRule rule) {
        (switch (rule.permissionType()) {
            case PermissionType.DENY -> {
                switch (rule.resourcePattern().patternType()) {
                    case LITERAL: {
                        yield this.denyLiteralRules;
                    }
                    case PREFIXED: {
                        yield this.denyPrefixedRules;
                    }
                }
                throw new IllegalArgumentException("Unsupported access rule pattern type " + String.valueOf(rule.resourcePattern().patternType()));
            }
            case PermissionType.ALLOW -> {
                switch (rule.resourcePattern().patternType()) {
                    case LITERAL: {
                        yield this.allowLiteralRules;
                    }
                    case PREFIXED: {
                        yield this.allowPrefixedRules;
                    }
                }
                throw new IllegalArgumentException("Unsupported access rule pattern type " + String.valueOf(rule.resourcePattern().patternType()));
            }
            default -> throw new IllegalArgumentException("Unsupported access rule permission type " + String.valueOf(rule.permissionType()));
        }).putIfAbsent(rule.resourcePattern().name(), rule);
    }

    public String toString() {
        return "ResourceAuthorizeRules{denyLiterals=" + String.valueOf(this.denyLiteralRules) + ", denyPrefixes=" + String.valueOf(this.denyPrefixedRules) + ", allowLiterals=" + String.valueOf(this.allowLiteralRules) + ", allowPrefixes=" + String.valueOf(this.allowPrefixedRules) + "}";
    }
}

