/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.clients.plugins.auth.jwt;

import io.confluent.kafka.clients.plugins.auth.jwt.CloseableVerificationKeyResolver;
import io.confluent.kafka.clients.plugins.auth.jwt.JwtAuthenticator;
import io.confluent.kafka.clients.plugins.auth.jwt.JwtVerificationException;
import io.confluent.kafka.clients.plugins.auth.jwt.PublicKeyJwks;
import io.confluent.kafka.clients.plugins.auth.jwt.PublicKeyVerificationKeyResolver;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.lang.JoseException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JwtAuthenticatorTest {
    private static CloseableVerificationKeyResolver keyResolver;
    private static List<String> audiences;
    private static PrivateKey privateKey;
    private JwtClaims claims;
    private static Map<String, Boolean> claimOptions;

    @BeforeAll
    public static void beforeAllSetup() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        privateKey = keyPair.getPrivate();
        HashSet<PublicKey> publicKeys = new HashSet<PublicKey>();
        publicKeys.add(publicKey);
        keyResolver = new PublicKeyVerificationKeyResolver(new PublicKeyJwks(publicKeys));
        audiences = Arrays.asList("aud1", "aud2");
    }

    @BeforeEach
    public void beforeEachSetUp() {
        this.claims = new JwtClaims();
        this.claims.setExpirationTime(NumericDate.fromMilliseconds((long)(System.currentTimeMillis() + 3600000L)));
        claimOptions = new HashMap<String, Boolean>();
    }

    @Test
    public void testJtiNotRequiredAndNotPresentInJws() throws JwtVerificationException, JoseException {
        this.claims.setSubject("example");
        this.claims.setAudience("aud1");
        this.claims.setIssuedAt(NumericDate.now());
        this.claims.setIssuer("https://example.com");
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(this.claims.toJson());
        jws.setKey((Key)privateKey);
        jws.setAlgorithmHeaderValue("RS256");
        String signedJWT = jws.getCompactSerialization();
        claimOptions.put("jtiRequired", false);
        JwtAuthenticator jwtAuthenticator = new JwtAuthenticator("https://example.com", keyResolver, audiences, claimOptions);
        OAuthBearerToken bearerToken = jwtAuthenticator.login(signedJWT);
        Assertions.assertNotNull((Object)bearerToken);
    }

    @Test
    public void testJtiNotRequiredAndPresentInJws() throws JwtVerificationException, JoseException {
        this.claims.setSubject("example");
        this.claims.setJwtId("testJwtId");
        this.claims.setAudience("aud1");
        this.claims.setIssuedAt(NumericDate.now());
        this.claims.setIssuer("https://example.com");
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(this.claims.toJson());
        jws.setKey((Key)privateKey);
        jws.setAlgorithmHeaderValue("RS256");
        String signedJWT = jws.getCompactSerialization();
        JwtAuthenticator jwtAuthenticator = new JwtAuthenticator("https://example.com", keyResolver, audiences, claimOptions);
        OAuthBearerToken bearerToken = jwtAuthenticator.login(signedJWT);
        Assertions.assertNotNull((Object)bearerToken);
    }

    @Test
    public void testJtiRequiredAndPresentInJws() throws JoseException, JwtVerificationException {
        this.claims.setSubject("example");
        this.claims.setJwtId("testJwtId");
        this.claims.setAudience("aud1");
        this.claims.setIssuedAt(NumericDate.now());
        this.claims.setIssuer("https://example.com");
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(this.claims.toJson());
        jws.setKey((Key)privateKey);
        jws.setAlgorithmHeaderValue("RS256");
        String signedJWT = jws.getCompactSerialization();
        JwtAuthenticator jwtAuthenticator = new JwtAuthenticator("https://example.com", keyResolver, audiences, true);
        OAuthBearerToken bearerToken = jwtAuthenticator.login(signedJWT);
        Assertions.assertNotNull((Object)bearerToken);
    }

    @Test
    public void testJtiRequiredAndNotPresentInToken() throws JoseException {
        this.claims.setSubject("example");
        this.claims.setAudience("aud1");
        this.claims.setIssuedAt(NumericDate.now());
        this.claims.setIssuer("https://example.com");
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(this.claims.toJson());
        jws.setKey((Key)privateKey);
        jws.setAlgorithmHeaderValue("RS256");
        String signedJWT = jws.getCompactSerialization();
        claimOptions.put("jtiRequired", true);
        JwtAuthenticator jwtAuthenticator = new JwtAuthenticator("https://example.com", keyResolver, audiences, claimOptions);
        JwtVerificationException exception = (JwtVerificationException)Assertions.assertThrows(JwtVerificationException.class, () -> jwtAuthenticator.login(signedJWT));
        String expectedMessage = "The JWT had no JWT Id {jti} claim but it is configured to be required.";
        Assertions.assertTrue((boolean)exception.getMessage().contains(expectedMessage));
    }

    @Test
    public void testAudNotConfiguredButPresentInToken() throws JoseException, JwtVerificationException {
        this.claims.setSubject("example");
        this.claims.setIssuedAt(NumericDate.now());
        this.claims.setIssuer("https://example.com");
        this.claims.setJwtId("testJwtId");
        this.claims.setAudience(Arrays.asList("aud1", "aud2"));
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(this.claims.toJson());
        jws.setKey((Key)privateKey);
        jws.setAlgorithmHeaderValue("RS256");
        String signedJWT = jws.getCompactSerialization();
        JwtAuthenticator jwtAuthenticator = new JwtAuthenticator("https://example.com", keyResolver, Collections.emptyList(), claimOptions);
        OAuthBearerToken bearerToken = jwtAuthenticator.login(signedJWT);
        Assertions.assertNotNull((Object)bearerToken);
    }

    @Test
    public void testIatIsNotRequired() throws JoseException, JwtVerificationException {
        this.claims.setSubject("example");
        this.claims.setAudience("aud1");
        this.claims.setJwtId("testJwtId");
        this.claims.setIssuer("https://example.com");
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(this.claims.toJson());
        jws.setKey((Key)privateKey);
        jws.setAlgorithmHeaderValue("RS256");
        String signedJWT = jws.getCompactSerialization();
        claimOptions.put("iatRequired", false);
        JwtAuthenticator jwtAuthenticator = new JwtAuthenticator("https://example.com", keyResolver, audiences, claimOptions);
        OAuthBearerToken bearerToken = jwtAuthenticator.login(signedJWT);
        Assertions.assertNotNull((Object)bearerToken);
    }

    @Test
    public void testIssIsRequired() throws JoseException, JwtVerificationException {
        this.claims.setSubject("example");
        this.claims.setAudience("aud1");
        this.claims.setJwtId("testJwtId");
        this.claims.setIssuedAt(NumericDate.now());
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(this.claims.toJson());
        jws.setKey((Key)privateKey);
        jws.setAlgorithmHeaderValue("RS256");
        String signedJWT = jws.getCompactSerialization();
        JwtAuthenticator jwtAuthenticator = new JwtAuthenticator("https://example.com", keyResolver, audiences, claimOptions);
        JwtVerificationException exception = (JwtVerificationException)Assertions.assertThrows(JwtVerificationException.class, () -> jwtAuthenticator.login(signedJWT));
        String expectedMessage = "The JWT had no Issuer {iss} claim but it is configured to be required.";
        Assertions.assertTrue((boolean)exception.getMessage().contains(expectedMessage));
    }

    @Test
    public void testSubIsNotRequiredFromNonConfluentToken() throws JoseException, JwtVerificationException {
        this.claims.setAudience("aud1");
        this.claims.setJwtId("testJwtId");
        this.claims.setIssuer("https://example.com");
        this.claims.setIssuedAt(NumericDate.now());
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(this.claims.toJson());
        jws.setKey((Key)privateKey);
        jws.setAlgorithmHeaderValue("RS256");
        String signedJWT = jws.getCompactSerialization();
        JwtAuthenticator jwtAuthenticator = new JwtAuthenticator("https://example.com", keyResolver, audiences, claimOptions);
        OAuthBearerToken bearerToken = jwtAuthenticator.login(signedJWT);
        Assertions.assertNotNull((Object)bearerToken);
    }

    @Test
    public void testSubIsRequiredFromConfluentToken() throws JoseException, JwtVerificationException {
        this.claims.setAudience("aud1");
        this.claims.setJwtId("testJwtId");
        this.claims.setIssuer("Confluent");
        this.claims.setIssuedAt(NumericDate.now());
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(this.claims.toJson());
        jws.setKey((Key)privateKey);
        jws.setAlgorithmHeaderValue("RS256");
        String signedJWT = jws.getCompactSerialization();
        JwtAuthenticator jwtAuthenticator = new JwtAuthenticator("Confluent", keyResolver, audiences, claimOptions);
        JwtVerificationException exception = (JwtVerificationException)Assertions.assertThrows(JwtVerificationException.class, () -> jwtAuthenticator.login(signedJWT));
        String expectedMessage = "The JWT had no Subject {sub} claim but it is configured to be required";
        Assertions.assertTrue((boolean)exception.getMessage().contains(expectedMessage));
    }
}

