/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.MultiTenantInterceptor;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelMetadataRegistry;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.DefaultChannelMetadataRegistry;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MultiTenantInterceptorTest {
    private MultiTenantInterceptor interceptor;
    private Metrics metrics;
    private ChannelMetadataRegistry metadataRegistry;

    private void callOnApiVersionsRequest(MultiTenantInterceptor interceptor, String softwareName, String softwareVersion, String clientId, Metrics metrics) {
        ClientInformation clientInformation = new ClientInformation(softwareName, softwareVersion);
        MultiTenantPrincipal multiTenantPrincipal = new MultiTenantPrincipal("user", "saslAuthenticationId", new TenantMetadata("tenantName", "clusterId", "organizationId", "environmentId", "userResourceID", true, true, true));
        interceptor.onApiVersionsRequest(clientInformation, clientId, (KafkaPrincipal)multiTenantPrincipal, metrics);
    }

    private void callOnAuthenticatedConnection(MultiTenantInterceptor interceptor, Metrics metrics, ChannelMetadataRegistry metadataRegistry) {
        MultiTenantPrincipal multiTenantPrincipal = new MultiTenantPrincipal("user", "saslAuthenticationId", new TenantMetadata("tenantName", "clusterId", "organizationId", "environmentId", "userResourceID", true, true, true));
        interceptor.onAuthenticatedConnection("connectionId", InetAddress.getLoopbackAddress(), (KafkaPrincipal)multiTenantPrincipal, metrics, metadataRegistry);
    }

    private Map<String, Object> defaultConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("confluent.multitenant.listener.hostname.cluster.prefix.enable", false);
        config.put("confluent.schema.validator.multitenant.enable", false);
        config.put("confluent.multitenant.interceptor.balancer.apis.enabled", false);
        config.put("confluent.multitenant.listener.hostname.subdomain.suffix.enable", ConfluentConfigs.MULTITENANT_LISTENER_HOSTNAME_SUBDOMAIN_SUFFIX_ENABLE_DEFAULT);
        config.put("confluent.valid.broker.rack.set", ConfluentConfigs.VALID_BROKER_RACK_SET_DEFAULT);
        config.put("confluent.subdomain.separator.map", ConfluentConfigs.SUBDOMAIN_SEPARATOR_MAP_DEFAULT);
        config.put("confluent.subdomain.separator.variable", "%sep");
        config.put("confluent.fetch.from.follower.require.leader.epoch.enable", false);
        config.put("confluent.broker.limit.producer.bytes.per.second", ConfluentConfigs.BROKER_LIMIT_PRODUCER_DEFAULT);
        config.put("confluent.broker.limit.consumer.bytes.per.second", ConfluentConfigs.BROKER_LIMIT_CONSUMER_DEFAULT);
        config.put("confluent.hot.partition.ratio", 0.8);
        config.put("group.coordinator.new.enable", false);
        config.put("confluent.ppv2.endpoint.scheme.enable", false);
        return config;
    }

    @BeforeEach
    public void setUp() {
        this.interceptor = new MultiTenantInterceptor();
        this.metrics = new Metrics();
        this.metadataRegistry = new DefaultChannelMetadataRegistry();
    }

    @AfterEach
    public void tearDown() {
        this.metrics.close();
    }

    @Test
    public void testOnAuthenticatedConnection_DisableRecordApiVersions() {
        Map<String, Object> disabledConfig = this.defaultConfig();
        disabledConfig.put("confluent.multitenant.interceptor.collect.client.apiversions.metric", false);
        this.interceptor.configure(disabledConfig);
        this.metadataRegistry.registerClientId("should-not-be-logged");
        this.metadataRegistry.registerClientInformation(new ClientInformation("should-not-be-logged", "should-not-be-logged"));
        this.callOnAuthenticatedConnection(this.interceptor, this.metrics, this.metadataRegistry);
        Assertions.assertTrue((boolean)this.metrics.metrics().keySet().stream().noneMatch(metricName -> metricName.name().equals("connection-info-rate")), (String)"Metric shouldn't be logged when feature is gated");
    }

    @Test
    public void testOnAuthenticatedConnection_DefaultConfiguration() {
        this.interceptor.configure(this.defaultConfig());
        this.metadataRegistry.registerClientId("should-not-be-logged");
        this.metadataRegistry.registerClientInformation(new ClientInformation("should-not-be-logged", "should-not-be-logged"));
        this.callOnAuthenticatedConnection(this.interceptor, this.metrics, this.metadataRegistry);
        Assertions.assertTrue((boolean)this.metrics.metrics().keySet().stream().noneMatch(metricName -> metricName.name().equals("connection-info-rate")), (String)"Metric shouldn't be logged when the config value isn't specified (default is false)");
    }

    @Test
    public void testOnAuthenticatedConnection_EmitWhenAllInformationIsAvailable() {
        Map<String, Object> enabledConfig = this.defaultConfig();
        enabledConfig.put("confluent.multitenant.interceptor.collect.client.apiversions.metric", true);
        this.interceptor.configure(enabledConfig);
        this.metadataRegistry.registerClientInformation(new ClientInformation("some-software-name", "some-software-version"));
        this.metadataRegistry.registerClientId("api-versions-before-auth");
        this.callOnAuthenticatedConnection(this.interceptor, this.metrics, this.metadataRegistry);
        List matches = this.metrics.metrics().entrySet().stream().filter(e -> ((MetricName)e.getKey()).name().equals("connection-info-rate")).map(Map.Entry::getValue).collect(Collectors.toList());
        Assertions.assertFalse((boolean)matches.isEmpty(), (String)"Metric should be logged when config option is true");
        Assertions.assertTrue((boolean)matches.stream().anyMatch(metric -> ((String)metric.metricName().tags().get("client-id")).equals("api-versions-before-auth")), (String)"Can't find the logged client-id");
    }

    @Test
    public void testOnAuthenticatedConnection_NotEmitWhenClientInformationIsEmpty() {
        Map<String, Object> enabledConfig = this.defaultConfig();
        enabledConfig.put("confluent.multitenant.interceptor.collect.client.apiversions.metric", true);
        this.interceptor.configure(enabledConfig);
        this.metadataRegistry.registerClientInformation(ClientInformation.EMPTY);
        this.metadataRegistry.registerClientId("auth-before-api-versions");
        this.callOnAuthenticatedConnection(this.interceptor, this.metrics, this.metadataRegistry);
        List matches = this.metrics.metrics().entrySet().stream().filter(e -> ((MetricName)e.getKey()).name().equals("connection-info-rate")).map(Map.Entry::getValue).collect(Collectors.toList());
        Assertions.assertFalse((boolean)matches.stream().anyMatch(metric -> ((String)metric.metricName().tags().get("client-id")).equals("auth-before-api-versions")), (String)"Expected no connection-info-rate metric is emitted");
    }

    @Test
    public void testOnAuthenticatedConnection_NotEmitWhenClientInformationIsNull() {
        Map<String, Object> enabledConfig = this.defaultConfig();
        enabledConfig.put("confluent.multitenant.interceptor.collect.client.apiversions.metric", true);
        this.interceptor.configure(enabledConfig);
        this.metadataRegistry.registerClientId("auth-before-api-versions");
        this.callOnAuthenticatedConnection(this.interceptor, this.metrics, this.metadataRegistry);
        List matches = this.metrics.metrics().entrySet().stream().filter(e -> ((MetricName)e.getKey()).name().equals("connection-info-rate")).map(Map.Entry::getValue).collect(Collectors.toList());
        Assertions.assertFalse((boolean)matches.stream().anyMatch(metric -> ((String)metric.metricName().tags().get("client-id")).equals("auth-before-api-versions")), (String)"Expected no connection-info-rate metric is emitted");
    }

    @Test
    public void testOnAuthenticatedConnection_NotEmitWhenClientIdIsNull() {
        Map<String, Object> enabledConfig = this.defaultConfig();
        enabledConfig.put("confluent.multitenant.interceptor.collect.client.apiversions.metric", true);
        this.interceptor.configure(enabledConfig);
        this.metadataRegistry.registerClientInformation(new ClientInformation("some-software-name", "some-software-version"));
        this.callOnAuthenticatedConnection(this.interceptor, this.metrics, this.metadataRegistry);
        List matches = this.metrics.metrics().entrySet().stream().filter(e -> ((MetricName)e.getKey()).name().equals("connection-info-rate")).map(Map.Entry::getValue).collect(Collectors.toList());
        Assertions.assertTrue((boolean)matches.isEmpty(), (String)"Expected no connection-info-rate metric is emitted");
    }

    @Test
    public void testOnApiVersionsRequest_DisableRecordApiVersions() {
        Map<String, Object> disabledConfig = this.defaultConfig();
        disabledConfig.put("confluent.multitenant.interceptor.collect.client.apiversions.metric", false);
        this.interceptor.configure(disabledConfig);
        this.callOnApiVersionsRequest(this.interceptor, "should-not-be-logged", "should-not-be-logged", "should-not-be-logged", this.metrics);
        Assertions.assertTrue((boolean)this.metrics.metrics().keySet().stream().noneMatch(metricName -> metricName.name().equals("connection-info-rate")), (String)"Metric shouldn't be logged when feature is gated");
    }

    @Test
    public void testOnApiVersionsRequest_DefaultConfiguration() {
        this.interceptor.configure(this.defaultConfig());
        this.callOnApiVersionsRequest(this.interceptor, "should-not-be-logged", "should-not-be-logged", "should-not-be-logged", this.metrics);
        Assertions.assertTrue((boolean)this.metrics.metrics().keySet().stream().noneMatch(metricName -> metricName.name().equals("connection-info-rate")), (String)"Metric shouldn't be logged when the config value isn't specified (default is false)");
    }

    @Test
    public void testOnApiVersionsRequest_EnableRecordApiVersions() {
        Map<String, Object> enabledConfig = this.defaultConfig();
        enabledConfig.put("confluent.multitenant.interceptor.collect.client.apiversions.metric", true);
        this.interceptor.configure(enabledConfig);
        this.callOnApiVersionsRequest(this.interceptor, "some-software-name", "some-software-version", "foobar", this.metrics);
        List matches = this.metrics.metrics().entrySet().stream().filter(e -> ((MetricName)e.getKey()).name().equals("connection-info-rate")).map(Map.Entry::getValue).collect(Collectors.toList());
        Assertions.assertFalse((boolean)matches.isEmpty(), (String)"Metric should be logged when config option is true");
        Assertions.assertTrue((boolean)matches.stream().anyMatch(metric -> ((String)metric.metricName().tags().get("client-id")).equals("foobar")), (String)"Can't find the logged client-id");
    }

    @Test
    public void testMultipleRecordApiVersionsRecordsAtMostOnce() {
        Map<String, Object> enabledConfig = this.defaultConfig();
        enabledConfig.put("confluent.multitenant.interceptor.collect.client.apiversions.metric", true);
        this.interceptor.configure(enabledConfig);
        this.callOnApiVersionsRequest(this.interceptor, "some-software-name", "some-software-version", "foobar", this.metrics);
        this.callOnApiVersionsRequest(this.interceptor, "alternative-name", "alternative-version", "barfoo", this.metrics);
        List matches = this.metrics.metrics().entrySet().stream().filter(e -> ((MetricName)e.getKey()).name().equals("connection-info-rate")).map(Map.Entry::getValue).collect(Collectors.toList());
        Assertions.assertFalse((boolean)matches.isEmpty(), (String)"Metric should be logged when config option is true");
        Assertions.assertTrue((boolean)matches.stream().anyMatch(metric -> ((String)metric.metricName().tags().get("client-id")).equals("foobar")), (String)"Can't find the logged client-id");
    }
}

