/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.cluster;

import io.confluent.kafka.multitenant.integration.cluster.TestPlainLoginModule;
import io.confluent.kafka.multitenant.integration.cluster.UserMetadata;
import io.confluent.kafka.server.plugins.auth.DefaultDataPolicyValidationMode;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslConfigEntry;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslSecrets;
import io.confluent.kafka.server.plugins.auth.SniValidationMode;
import io.confluent.kafka.server.plugins.auth.TopicBasedPlainSaslAuthenticator;
import io.confluent.kafka.server.plugins.auth.TrafficNetworkIdValidationMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.network.CCloudTrafficType;
import org.mindrot.jbcrypt.BCrypt;

public class TestPlainSaslAuthenticator
extends TopicBasedPlainSaslAuthenticator {
    private static Map<String, Map<String, MultiTenantSaslConfigEntry>> brokersCredentials = new HashMap<String, Map<String, MultiTenantSaslConfigEntry>>();

    public TestPlainSaslAuthenticator(Map<String, ?> props) {
        super(props);
    }

    public static void addUser(String brokerSessionUuid, UserMetadata user, String logicalClusterId) {
        Map<String, MultiTenantSaslConfigEntry> brokerCred = brokersCredentials.get(brokerSessionUuid);
        if (brokerCred == null) {
            brokerCred = new HashMap<String, MultiTenantSaslConfigEntry>();
            brokersCredentials.put(brokerSessionUuid, brokerCred);
        }
        String hashedPassword = BCrypt.hashpw((String)user.apiSecret(), (String)BCrypt.gensalt((int)10));
        String saslUser = logicalClusterId + "_" + user.apiKey();
        MultiTenantSaslConfigEntry userEntry = new MultiTenantSaslConfigEntry("PLAIN", hashedPassword, "bcrypt", saslUser, logicalClusterId, user.isServiceAccount(), user.userResourceId());
        brokerCred.put(saslUser, userEntry);
    }

    public static void removeUser(String brokerSessionUuid, UserMetadata user, String logicalClusterId) {
        Map<String, MultiTenantSaslConfigEntry> brokerCred = brokersCredentials.get(brokerSessionUuid);
        if (brokerCred == null) {
            return;
        }
        String saslUser = logicalClusterId + "_" + user.apiKey();
        brokerCred.remove(saslUser);
    }

    public void initialize(List<AppConfigurationEntry> jaasContextEntries) {
        this.mode = SniValidationMode.fromString((String)TestPlainSaslAuthenticator.configEntryOption(jaasContextEntries, (String)"sni_host_name_validation_mode", (String)TestPlainLoginModule.class.getName()));
        this.networkIdValidationMode = TrafficNetworkIdValidationMode.fromConfigs((CCloudTrafficType)this.trafficType, () -> TestPlainSaslAuthenticator.configEntryOption((List)jaasContextEntries, (String)"traffic_network_id_validation_mode", (String)TestPlainLoginModule.class.getName()));
        this.defaultDataPolicyValidationMode = DefaultDataPolicyValidationMode.fromConfigs(() -> TestPlainSaslAuthenticator.configEntryOption((List)jaasContextEntries, (String)"default_data_policy_validation_mode", (String)TestPlainLoginModule.class.getName()));
        this.log.debug("TestPlainSaslAuthenticator initialized with mode: {}, networkIdValidationMode:{}, defaultDataPolicyValidationMode:{}", new Object[]{this.mode.getText(), this.networkIdValidationMode.name(), this.defaultDataPolicyValidationMode.name()});
    }

    protected MultiTenantSaslSecrets loadSecrets() {
        Map<String, MultiTenantSaslConfigEntry> brokerCred = brokersCredentials.get(this.brokerSessionUuid);
        if (brokerCred == null) {
            return new MultiTenantSaslSecrets(Collections.emptyMap());
        }
        return new MultiTenantSaslSecrets(brokerCred);
    }
}

