/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.metrics.ConnectionInformationSensors;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import io.confluent.kafka.multitenant.metrics.TenantMetricsTestUtils;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.MetricsBuilderContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ConnectionInformationSensorsTest {
    private MockTime time;
    private TenantMetricsTestUtils utils;
    private Metrics metrics;
    private MultiTenantPrincipal principal;

    @BeforeEach
    public void setUp() {
        String tenantName = "tenant";
        String userName = "user1";
        this.time = new MockTime();
        this.metrics = new Metrics((Time)this.time);
        TenantMetadata metadata = new TenantMetadata.Builder(tenantName, "u-1").build();
        this.principal = new MultiTenantPrincipal(userName, metadata);
        this.utils = new TenantMetricsTestUtils(this.metrics);
    }

    @AfterEach
    public void tearDown() {
        this.metrics.close();
    }

    @Test
    public void testRecordAuthenticatedConnectionAndDisconnection() {
        ClientInformation clientInformation = new ClientInformation("name", "version");
        TenantMetrics.TenantConnectionInformationMetricsContext context = new TenantMetrics.TenantConnectionInformationMetricsContext(this.principal, clientInformation, "client-id");
        ConnectionInformationSensors connectionInformationSensors = new ConnectionInformationSensors(this.metrics, this.principal, clientInformation, "client-id", 1000);
        Sensor sensor = connectionInformationSensors.recordAuthenticatedConnection();
        Assertions.assertNotNull((Object)sensor);
        Map<String, KafkaMetric> metricsByName = this.utils.verifyTenantMetrics((MetricsBuilderContext)context, "connection-info-rate");
        Assertions.assertEquals((double)1.0, (double)metricsByName.get("connection-info-rate").measurableValue());
        Sensor removed = connectionInformationSensors.recordAuthenticatedDisconnection();
        Assertions.assertNull((Object)removed);
        Sensor removedFromMetrics = TenantMetricsTestUtils.sensorForMetric(this.metrics, context.sensorSuffix(), "connection-info-rate");
        Assertions.assertNull((Object)removedFromMetrics);
    }

    @Test
    public void testRecordAuthenticatedConnectionsAndDisconnectionsPerClient() {
        ClientInformation clientInformation = new ClientInformation("name", "version");
        TenantMetrics.TenantConnectionInformationMetricsContext context1 = new TenantMetrics.TenantConnectionInformationMetricsContext(this.principal, clientInformation, "client-id1");
        Sensor sensor1 = new ConnectionInformationSensors(this.metrics, this.principal, clientInformation, "client-id1", 1000).recordAuthenticatedConnection();
        Assertions.assertNotNull((Object)sensor1);
        TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, (MetricsBuilderContext)context1, false, "connection-info-rate");
        TenantMetrics.TenantConnectionInformationMetricsContext context2 = new TenantMetrics.TenantConnectionInformationMetricsContext(this.principal, clientInformation, "client-id2");
        Sensor sensor2 = new ConnectionInformationSensors(this.metrics, this.principal, clientInformation, "client-id2", 1000).recordAuthenticatedConnection();
        Assertions.assertNotNull((Object)sensor2);
        TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, (MetricsBuilderContext)context2, false, "connection-info-rate");
        ClientInformation clientInformation2 = new ClientInformation("another-name", "another-version");
        TenantMetrics.TenantConnectionInformationMetricsContext context3 = new TenantMetrics.TenantConnectionInformationMetricsContext(this.principal, clientInformation2, "client-id1");
        ConnectionInformationSensors connectionInformationSensors3 = new ConnectionInformationSensors(this.metrics, this.principal, clientInformation2, "client-id1", 1000);
        Sensor sensor3 = connectionInformationSensors3.recordAuthenticatedConnection();
        Assertions.assertNotNull((Object)sensor3);
        TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, (MetricsBuilderContext)context3, false, "connection-info-rate");
        Sensor sensor3Removed = connectionInformationSensors3.recordAuthenticatedDisconnection();
        Assertions.assertNull((Object)sensor3Removed);
        Sensor removedFromMetrics = TenantMetricsTestUtils.sensorForMetric(this.metrics, context3.sensorSuffix(), "connection-info-rate");
        Assertions.assertNull((Object)removedFromMetrics);
        TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, (MetricsBuilderContext)context1, false, "connection-info-rate");
        TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, (MetricsBuilderContext)context2, false, "connection-info-rate");
    }

    @Test
    public void testConcurrentAuthenticatedConnectionsAndDisconnections() throws Exception {
        int i;
        ClientInformation clientInformation = new ClientInformation("name", "version");
        TenantMetrics.TenantConnectionInformationMetricsContext context = new TenantMetrics.TenantConnectionInformationMetricsContext(this.principal, clientInformation, "client-id");
        Runnable connectAndDisconnect = () -> this.lambda$testConcurrentAuthenticatedConnectionsAndDisconnections$0(clientInformation, (MetricsBuilderContext)context);
        Runnable connect = () -> this.lambda$testConcurrentAuthenticatedConnectionsAndDisconnections$1(clientInformation, (MetricsBuilderContext)context);
        ExecutorService executorService = Executors.newCachedThreadPool();
        for (i = 0; i < 12; ++i) {
            executorService.submit(connect);
        }
        for (i = 0; i < 50; ++i) {
            executorService.submit(connectAndDisconnect);
        }
        executorService.shutdown();
        boolean terminated = executorService.awaitTermination(15L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)terminated);
        Map<String, KafkaMetric> metricByName = TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, (MetricsBuilderContext)context, false, "connection-info-rate");
        Assertions.assertEquals((double)12.0, (double)metricByName.get("connection-info-rate").measurableValue());
    }

    @Test
    public void testConcurrentAuthenticatedConnectionsAndDisconnectionsWithCap() throws Exception {
        int i;
        ClientInformation clientInformation = new ClientInformation("name", "version");
        TenantMetrics.TenantConnectionInformationMetricsContext context1 = new TenantMetrics.TenantConnectionInformationMetricsContext(this.principal, clientInformation, "client-id1");
        TenantMetrics.TenantConnectionInformationMetricsContext context2 = new TenantMetrics.TenantConnectionInformationMetricsContext(this.principal, clientInformation, "client-id2");
        int maxConnectionInfoMetricsPerTenant = 1;
        CountDownLatch overQuotaConnections = new CountDownLatch(25);
        CountDownLatch quotaNotViolated = new CountDownLatch(1);
        ConnectionInformationSensors connectionInformationSensors1 = new ConnectionInformationSensors(this.metrics, this.principal, clientInformation, "client-id1", maxConnectionInfoMetricsPerTenant);
        connectionInformationSensors1.recordAuthenticatedConnection();
        Runnable connectAndDisconnect = () -> this.lambda$testConcurrentAuthenticatedConnectionsAndDisconnectionsWithCap$2(clientInformation, maxConnectionInfoMetricsPerTenant, (MetricsBuilderContext)context2, overQuotaConnections, quotaNotViolated);
        Runnable disconnect = () -> this.lambda$testConcurrentAuthenticatedConnectionsAndDisconnectionsWithCap$3(overQuotaConnections, connectionInformationSensors1, (MetricsBuilderContext)context1, quotaNotViolated);
        Runnable connect = () -> this.lambda$testConcurrentAuthenticatedConnectionsAndDisconnectionsWithCap$4(quotaNotViolated, clientInformation, maxConnectionInfoMetricsPerTenant, (MetricsBuilderContext)context2);
        ExecutorService executorService = Executors.newFixedThreadPool(30);
        executorService.submit(disconnect);
        for (i = 0; i < 4; ++i) {
            executorService.submit(connect);
        }
        for (i = 0; i < 25; ++i) {
            executorService.submit(connectAndDisconnect);
        }
        executorService.shutdown();
        boolean terminated = executorService.awaitTermination(15L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)terminated);
        Map<String, KafkaMetric> metricByName = TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, (MetricsBuilderContext)context2, false, "connection-info-rate");
        Assertions.assertEquals((double)4.0, (double)metricByName.get("connection-info-rate").measurableValue());
    }

    private /* synthetic */ void lambda$testConcurrentAuthenticatedConnectionsAndDisconnectionsWithCap$4(CountDownLatch quotaNotViolated, ClientInformation clientInformation, int maxConnectionInfoMetricsPerTenant, MetricsBuilderContext context2) {
        try {
            quotaNotViolated.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        ConnectionInformationSensors connectionInformationSensors2 = new ConnectionInformationSensors(this.metrics, this.principal, clientInformation, "client-id2", maxConnectionInfoMetricsPerTenant);
        Sensor sensor = connectionInformationSensors2.recordAuthenticatedConnection();
        Assertions.assertNotNull((Object)sensor);
        TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, context2, false, "connection-info-rate");
    }

    private /* synthetic */ void lambda$testConcurrentAuthenticatedConnectionsAndDisconnectionsWithCap$3(CountDownLatch overQuotaConnections, ConnectionInformationSensors connectionInformationSensors1, MetricsBuilderContext context1, CountDownLatch quotaNotViolated) {
        try {
            overQuotaConnections.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Sensor removed = connectionInformationSensors1.recordAuthenticatedDisconnection();
        Assertions.assertNull((Object)removed);
        Sensor removedFromMetrics = TenantMetricsTestUtils.sensorForMetric(this.metrics, context1.sensorSuffix(), "connection-info-rate");
        Assertions.assertNull((Object)removedFromMetrics);
        quotaNotViolated.countDown();
    }

    private /* synthetic */ void lambda$testConcurrentAuthenticatedConnectionsAndDisconnectionsWithCap$2(ClientInformation clientInformation, int maxConnectionInfoMetricsPerTenant, MetricsBuilderContext context2, CountDownLatch overQuotaConnections, CountDownLatch quotaNotViolated) {
        ConnectionInformationSensors connectionInformationSensors2 = new ConnectionInformationSensors(this.metrics, this.principal, clientInformation, "client-id2", maxConnectionInfoMetricsPerTenant);
        Sensor notCreated = connectionInformationSensors2.recordAuthenticatedConnection();
        Assertions.assertNull((Object)notCreated);
        Sensor notCreatedInMetrics = TenantMetricsTestUtils.sensorForMetric(this.metrics, context2.sensorSuffix(), "connection-info-rate");
        Assertions.assertNull((Object)notCreatedInMetrics);
        overQuotaConnections.countDown();
        try {
            quotaNotViolated.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        connectionInformationSensors2.recordAuthenticatedDisconnection();
    }

    private /* synthetic */ void lambda$testConcurrentAuthenticatedConnectionsAndDisconnections$1(ClientInformation clientInformation, MetricsBuilderContext context) {
        Sensor sensor = new ConnectionInformationSensors(this.metrics, this.principal, clientInformation, "client-id", 25).recordAuthenticatedConnection();
        Assertions.assertNotNull((Object)sensor);
        TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, context, false, "connection-info-rate");
    }

    private /* synthetic */ void lambda$testConcurrentAuthenticatedConnectionsAndDisconnections$0(ClientInformation clientInformation, MetricsBuilderContext context) {
        ConnectionInformationSensors connectionInformationSensors = new ConnectionInformationSensors(this.metrics, this.principal, clientInformation, "client-id", 25);
        Sensor sensor = connectionInformationSensors.recordAuthenticatedConnection();
        Assertions.assertNotNull((Object)sensor);
        TenantMetricsTestUtils.verifyTenantMetrics(this.metrics, context, false, "connection-info-rate");
        connectionInformationSensors.recordAuthenticatedDisconnection();
    }
}

