/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.metrics;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.metrics.DeprecatedRequestSensors;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.utils.MetricUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@Timeout(value=60L)
public class DeprecatedRequestSensorsTest {
    private static final String DEPRECATED_REQUEST_NAME = "deprecated-request";
    private static final String UNIQUE_DEPRECATED_REQUEST_METRICS_NAME = "unique-deprecated-request-metrics";
    private static final int MAX_DEPRECATED_REQUEST_METRICS_PER_TENANT = 10;
    private static final String TENANT_1 = "lkc-abcde";
    private static final String TENANT_2 = "lkc-fghij";
    private static final String U_1 = "u-1";
    private static final String U_2 = "u-2";
    private static final List<DeprecatedRequestOccurrence> DEPRECATED_REQUEST_OCCURRENCES = Arrays.asList(DeprecatedRequestOccurrence.of(ApiKeys.PRODUCE, "lkc-abcde", "u-1", "producer-0"), DeprecatedRequestOccurrence.of(ApiKeys.FETCH, "lkc-abcde", "u-1", "consumer-0"), DeprecatedRequestOccurrence.of(ApiKeys.PRODUCE, "lkc-abcde", "u-1", "producer-1"), DeprecatedRequestOccurrence.of(ApiKeys.FETCH, "lkc-abcde", "u-1", "consumer-1"), DeprecatedRequestOccurrence.of(ApiKeys.PRODUCE, "lkc-abcde", "u-1", "producer-2"), DeprecatedRequestOccurrence.of(ApiKeys.FETCH, "lkc-abcde", "u-1", "consumer-2"), DeprecatedRequestOccurrence.of(ApiKeys.PRODUCE, "lkc-abcde", "u-1", "producer-3"), DeprecatedRequestOccurrence.of(ApiKeys.FETCH, "lkc-abcde", "u-1", "consumer-3"), DeprecatedRequestOccurrence.of(ApiKeys.PRODUCE, "lkc-abcde", "u-1", "producer-4"), DeprecatedRequestOccurrence.of(ApiKeys.FETCH, "lkc-abcde", "u-1", "consumer-4"), DeprecatedRequestOccurrence.of(ApiKeys.PRODUCE, "lkc-abcde", "u-1", "producer-5"), DeprecatedRequestOccurrence.of(ApiKeys.FETCH, "lkc-abcde", "u-1", "consumer-5"), DeprecatedRequestOccurrence.of(ApiKeys.PRODUCE, "lkc-fghij", "u-2", "producer-0"), DeprecatedRequestOccurrence.of(ApiKeys.FETCH, "lkc-fghij", "u-2", "consumer-0"));
    private MockTime time;
    private Metrics metrics;
    private ExecutorService executor;

    @BeforeEach
    public void setUp() {
        this.time = new MockTime();
        this.metrics = new Metrics((Time)this.time);
        this.executor = Executors.newFixedThreadPool(DEPRECATED_REQUEST_OCCURRENCES.size());
    }

    @AfterEach
    public void tearDown() {
        this.metrics.close();
        this.executor.shutdown();
    }

    @ParameterizedTest(name="testRecordTotalDeprecatedRequests")
    @MethodSource(value={"singleOccurrence"})
    public void testRecordTotalDeprecatedRequests(TestContext context) {
        long then = MockTime.SYSTEM.milliseconds();
        this.time.setCurrentTimeMs(then);
        DeprecatedRequestOccurrence deprecatedRequestOccurrence = context.deprecatedRequestOccurrences.get(0);
        Runnable r = () -> deprecatedRequestOccurrence.deprecatedRequestSensors(this.metrics).recordDeprecatedRequest();
        CompletableFuture<?> future1 = context.submit(r, this.executor);
        CompletableFuture<?> future2 = context.submit(r, this.executor);
        context.join(future1, future2);
        Assertions.assertEquals(Optional.of(2.0), deprecatedRequestOccurrence.deprecatedRequestMetricValue(this.metrics, then));
        Assertions.assertEquals(Optional.of(1.0), deprecatedRequestOccurrence.uniqueDeprecatedRequestMetricsMetricValue(this.metrics, then));
        this.time.sleep(TimeUnit.MINUTES.toMillis(1L));
        long now = this.time.milliseconds();
        Assertions.assertEquals(Optional.of(1.0), deprecatedRequestOccurrence.uniqueDeprecatedRequestMetricsMetricValue(this.metrics, now));
        CompletableFuture<?> future3 = context.submit(r, this.executor);
        CompletableFuture<?> future4 = context.submit(r, this.executor);
        context.join(future3, future4);
        Assertions.assertEquals(Optional.of(4.0), deprecatedRequestOccurrence.deprecatedRequestMetricValue(this.metrics, now));
        Assertions.assertEquals(Optional.of(1.0), deprecatedRequestOccurrence.uniqueDeprecatedRequestMetricsMetricValue(this.metrics, now));
    }

    @ParameterizedTest(name="testDeprecatedRequestOccurrenceQuota")
    @MethodSource(value={"allOccurrences"})
    public void testDeprecatedRequestOccurrenceQuota(TestContext context) {
        DeprecatedRequestOccurrence tenant1Occurrence = context.deprecatedRequestOccurrences.get(0);
        DeprecatedRequestOccurrence tenant2Occurrence = context.deprecatedRequestOccurrences.get(12);
        long then = MockTime.SYSTEM.milliseconds();
        this.time.setCurrentTimeMs(then);
        CompletableFuture[] futures = (CompletableFuture[])context.deprecatedRequestOccurrences.stream().map(occurrence -> context.submit(() -> occurrence.deprecatedRequestSensors(this.metrics).recordDeprecatedRequest(), this.executor)).toArray(CompletableFuture[]::new);
        context.join(futures);
        Assertions.assertEquals(Optional.of(10.0), tenant1Occurrence.uniqueDeprecatedRequestMetricsMetricValue(this.metrics, then));
        Assertions.assertEquals(Optional.of(2.0), tenant2Occurrence.uniqueDeprecatedRequestMetricsMetricValue(this.metrics, then));
        this.time.sleep(TimeUnit.MINUTES.toMillis(1L));
        long now = this.time.milliseconds();
        Assertions.assertEquals(Optional.of(10.0), tenant1Occurrence.uniqueDeprecatedRequestMetricsMetricValue(this.metrics, now));
        Assertions.assertEquals(Optional.of(2.0), tenant2Occurrence.uniqueDeprecatedRequestMetricsMetricValue(this.metrics, now));
        for (DeprecatedRequestOccurrence occurrence2 : context.deprecatedRequestOccurrences) {
            if (!occurrence2.deprecatedRequestMetricValue(this.metrics, now).isPresent()) continue;
            this.metrics.removeSensor(occurrence2.deprecatedRequestSensorName());
            break;
        }
        Assertions.assertEquals(Optional.of(9.0), tenant1Occurrence.uniqueDeprecatedRequestMetricsMetricValue(this.metrics, now));
        Assertions.assertEquals(Optional.of(2.0), tenant2Occurrence.uniqueDeprecatedRequestMetricsMetricValue(this.metrics, now));
    }

    private static Stream<TestContext> singleOccurrence() {
        return Stream.of(new TestContext(Collections.singletonList(DEPRECATED_REQUEST_OCCURRENCES.get(0))));
    }

    private static Stream<TestContext> allOccurrences() {
        return Stream.of(new TestContext(DEPRECATED_REQUEST_OCCURRENCES));
    }

    public static class TestContext {
        private final List<DeprecatedRequestOccurrence> deprecatedRequestOccurrences;

        public TestContext(List<DeprecatedRequestOccurrence> deprecatedRequestOccurrences) {
            this.deprecatedRequestOccurrences = deprecatedRequestOccurrences;
        }

        public CompletableFuture<?> submit(Runnable r, Executor executor) {
            return CompletableFuture.runAsync(r, executor);
        }

        public void join(CompletableFuture<?> ... futures) {
            CompletableFuture.allOf(futures).join();
        }
    }

    public record DeprecatedRequestOccurrence(ApiKeys apiKey, String tenantName, String userResourceId, String clientId) {
        public static DeprecatedRequestOccurrence of(ApiKeys apiKey, String tenantName, String userResourceId, String clientId) {
            return new DeprecatedRequestOccurrence(apiKey, tenantName, userResourceId, clientId);
        }

        public DeprecatedRequestSensors deprecatedRequestSensors(Metrics metrics) {
            String userName = "user1";
            TenantMetadata metadata = new TenantMetadata.Builder(this.tenantName, this.userResourceId).build();
            MultiTenantPrincipal principal = new MultiTenantPrincipal(userName, metadata);
            return new DeprecatedRequestSensors(metrics, principal, this.apiKey, this.clientId, 10);
        }

        public String deprecatedRequestSensorName() {
            return DeprecatedRequestSensorsTest.DEPRECATED_REQUEST_NAME + MetricUtils.tagsToSensorSuffix(this.deprecatedRequestMetricTags());
        }

        public Optional<Double> deprecatedRequestMetricValue(Metrics metrics, long timeMs) {
            return Optional.ofNullable(metrics.metric(MetricUtils.totalMetricName((Metrics)metrics, (String)"tenant-metrics", this.deprecatedRequestMetricTags(), (String)DeprecatedRequestSensorsTest.DEPRECATED_REQUEST_NAME, (String)DeprecatedRequestSensorsTest.DEPRECATED_REQUEST_NAME))).map(m -> m.measurableValue(timeMs));
        }

        private Map<String, String> deprecatedRequestMetricTags() {
            LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
            tags.put("io-confluent-jmx-ignore", "");
            tags.put("request", this.apiKey.name);
            tags.put("tenant", this.tenantName);
            tags.put("user-resource-id", this.userResourceId);
            tags.put("client-id", this.clientId);
            return tags;
        }

        public Optional<Double> uniqueDeprecatedRequestMetricsMetricValue(Metrics metrics, long timeMs) {
            LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
            tags.put("io-confluent-jmx-ignore", "");
            tags.put("tenant", this.tenantName);
            return Optional.ofNullable(metrics.metric(metrics.metricName(DeprecatedRequestSensorsTest.UNIQUE_DEPRECATED_REQUEST_METRICS_NAME, "tenant-metrics", tags))).map(m -> m.measurableValue(timeMs));
        }
    }
}

