/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.schema;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.schema.TenantContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TenantContextTest {
    @Test
    public void testTenantNameCannotIncludePrefixDelimeter() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TenantContext(new MultiTenantPrincipal("user", new TenantMetadata("foo_bar", "cluster"))));
    }

    @Test
    public void testTenantNameIsValidTopicPrefix() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new TenantContext(new MultiTenantPrincipal("user", new TenantMetadata("foo|bar", "cluster"))));
    }

    @Test
    public void shouldExtractValidPrefix() throws Exception {
        Assertions.assertEquals((Object)"confluent_", (Object)TenantContext.extractTenantPrefix((String)"confluent_foo"));
    }

    @Test
    public void shouldFailExtractingMissingPrefix() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> TenantContext.extractTenantPrefix((String)"blah"));
    }

    @Test
    public void shouldIdentifyPrefixedTopics() throws Exception {
        Assertions.assertTrue((boolean)TenantContext.isTenantPrefixed((String)"confluent_foo"));
        Assertions.assertFalse((boolean)TenantContext.isTenantPrefixed((String)"blah"));
        Assertions.assertFalse((boolean)TenantContext.isTenantPrefixed(null));
        Assertions.assertFalse((boolean)TenantContext.isTenantPrefixed((String)"__consumer_offsets"));
        Assertions.assertFalse((boolean)TenantContext.isTenantPrefixed((String)"_confluent_metrics"));
    }

    @Test
    public void shouldIdentifyTopicsWithTenantPrefix() throws Exception {
        Assertions.assertTrue((boolean)TenantContext.hasTenantPrefix((String)"confluent_", (String)"confluent_foo"));
        Assertions.assertFalse((boolean)TenantContext.hasTenantPrefix((String)"xyz_", (String)"confluent_foo"));
        Assertions.assertFalse((boolean)TenantContext.hasTenantPrefix((String)"blah", (String)"blah"));
        Assertions.assertFalse((boolean)TenantContext.hasTenantPrefix((String)"confluent_", null));
    }

    @Test
    public void shouldRemoveAllTenantPrefixes() throws Exception {
        TenantContext context = new TenantContext(new MultiTenantPrincipal("user", new TenantMetadata("tenant", "cluster")));
        String uncleaned = "Failed to create topics tenant_foo, tenant_tenantbar, and tenant_tenant_blah";
        Assertions.assertEquals((int)("tenant_".length() * 4), (int)context.sizeOfRemovedPrefixes(uncleaned));
        String cleaned = context.removeAllTenantPrefixes(uncleaned);
        Assertions.assertEquals((Object)"Failed to create topics foo, tenantbar, and blah", (Object)cleaned);
    }

    @Test
    public void shouldQuoteTenantNameInPattern() throws Exception {
        TenantContext context = new TenantContext(new MultiTenantPrincipal("user", new TenantMetadata("bl.h", "cluster")));
        String uncleaned = "This matches 'bl.h_foo'. This does not: blah_foo";
        String cleaned = context.removeAllTenantPrefixes(uncleaned);
        Assertions.assertEquals((Object)"This matches 'foo'. This does not: blah_foo", (Object)cleaned);
    }

    @Test
    public void shouldPermitEmptyGroupId() throws Exception {
        TenantContext context = new TenantContext(new MultiTenantPrincipal("user", new TenantMetadata("tenant", "cluster")));
        String groupId = context.addTenantPrefix("");
        Assertions.assertEquals((Object)"tenant_", (Object)groupId);
        Assertions.assertEquals((Object)"", (Object)context.removeTenantPrefix("tenant_"));
        String message = "This is a message referring to the empty group 'tenant_'";
        Assertions.assertTrue((boolean)message.contains(context.prefix()));
        String cleanedMessage = context.removeAllTenantPrefixes(message);
        Assertions.assertFalse((boolean)cleanedMessage.contains(context.prefix()));
    }
}

