/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.authorizer;

import io.confluent.kafka.security.authorizer.ConfluentServerAuthorizer;
import io.confluent.security.authorizer.provider.ConfluentBuiltInProviders;
import java.util.Collections;
import java.util.Properties;
import kafka.api.SaslEndToEndAuthorizationTest;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.metadata.storage.Formatter;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import scala.collection.JavaConverters;
import scala.collection.immutable.List;

@Tag(value="bazel:shard_count:4")
public class AclEndToEndAuthorizationTest
extends SaslEndToEndAuthorizationTest {
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Properties serverConfig = this.serverConfig();
        serverConfig.put("authorizer.class.name", ConfluentServerAuthorizer.class.getName());
        serverConfig.put("confluent.authorizer.access.rule.providers", ConfluentBuiltInProviders.AccessRuleProviders.KRAFT_ACL.name());
        super.setUp(testInfo);
        this.createScramCredentialsViaPrivilegedAdminClient("scram-user", "scram-user-secret");
        this.createScramCredentialsViaPrivilegedAdminClient("scram-user2", "scram-user2-secret");
    }

    public String kafkaClientSaslMechanism() {
        return "SCRAM-SHA-256";
    }

    public void addFormatterSettings(Formatter formatter) {
        formatter.setClusterId("XcZZOzUqS4yHOjhMQB6JLQ");
        formatter.setScramArguments(Collections.singletonList("SCRAM-SHA-256=[name=scram-admin,password=scram-admin-secret]"));
    }

    public Admin createPrivilegedAdminClient() {
        return this.createScramAdminClient(this.kafkaClientSaslMechanism(), this.kafkaPrincipal().getName(), "scram-admin-secret");
    }

    public List<String> kafkaServerSaslMechanisms() {
        return JavaConverters.asScalaBuffer(Collections.singletonList("SCRAM-SHA-256")).toList();
    }

    public KafkaPrincipal clientPrincipal() {
        return new KafkaPrincipal("User", "scram-user");
    }

    public KafkaPrincipal kafkaPrincipal() {
        return new KafkaPrincipal("User", "scram-admin");
    }

    public void configureSecurityBeforeServersStart(TestInfo testInfo) {
        super.configureSecurityBeforeServersStart(testInfo);
    }
}

