/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.server.plugins.auth.DefaultUserMetaDataStore;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.util.KafkaBasedLog;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class DefaultUserMetaDataStoreTest {
    private static final String SSL_LISTENER_NAME = "SSL";
    private static final String TOPIC = "user-metadata";
    private static final ConfluentAuthorizerServerInfo SERVER_INFO = KafkaTestUtils.serverInfo("clusterA", SecurityProtocol.SSL);
    static final String KEY1 = String.join((CharSequence)"\n", "{", "  \"UserResourceId\": \"r1\",", "  \"OrgResourceId\": \"org1\"", "}");
    static final String VALUE1 = String.join((CharSequence)"\n", "{", "  \"UserId\": \"u1\",", "  \"ActiveLkcIds\": [\"lkc1\", \"lkc2\"]", "}");
    static final String KEY2 = String.join((CharSequence)"\n", "{", "  \"UserResourceId\": \"r2\",", "  \"OrgResourceId\": \"org2\"", "}");
    static final String VALUE2 = String.join((CharSequence)"\n", "{", "  \"UserId\": \"u2\",", "  \"ActiveLkcIds\": [\"lkc3\", \"lkc4\"]", "}");
    static final String KEY3 = String.join((CharSequence)"\n", "{", "  \"UserResourceId\": \"r3\",", "  \"OrgResourceId\": \"org1\"", "}");
    static final String KEY5 = String.join((CharSequence)"\n", "{", "  \"UserResourceId\": \"r1\",", "  \"OrgResourceId\": \"org2\",", "  \"PkcId\": \"pkc1\"", "}");
    static final String KEY4 = String.join((CharSequence)"\n", "{", "  \"UserResourceId\": \"r1\",", "  \"OrgResourceId\": \"org2\"", "}");
    static final String USER1 = "u1";
    static final String USER2 = "u2";
    static final String RESOURCE_ID1 = "r1";
    static final String RESOURCE_ID2 = "r2";
    private String sessionUuid;
    private KafkaBasedLog<String, String> kafkaBasedLog;
    private DefaultUserMetaDataStore store;
    private ObjectMapper objectMapper;
    private Metrics metrics;

    DefaultUserMetaDataStoreTest() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.sessionUuid = UUID.randomUUID().toString();
        this.kafkaBasedLog = (KafkaBasedLog)Mockito.mock(KafkaBasedLog.class);
        this.objectMapper = new ObjectMapper();
        this.metrics = new Metrics();
        this.store = new DefaultUserMetaDataStore(new HashMap(), this.metrics, (Time)new MockTime());
        this.store.configure(this.kafkaBasedLog, this.sessionUuid, Collections.singletonList(SSL_LISTENER_NAME));
        this.storeStart();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.closeStore();
    }

    private void closeStore() {
        this.store.close();
        Assertions.assertNull((Object)DefaultUserMetaDataStore.getInstance((String)this.sessionUuid));
    }

    private void storeStart() {
        Map endpointFutures = this.store.start((AuthorizerServerInfo)SERVER_INFO);
        Assertions.assertEquals((int)1, (int)endpointFutures.size(), (String)"More endpoints futures returned than expected!");
        SERVER_INFO.endpoints().forEach(endpoint -> ((CompletableFuture)endpointFutures.get(endpoint)).join());
    }

    private ConsumerRecord<String, String> createConsumerRecord(long seqId, String key, String value) {
        RecordHeaders headers = KafkaTestUtils.createGoodSequenceIdRecordHeaders(seqId);
        return new ConsumerRecord(TOPIC, 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, -1, -1, (Object)key, (Object)value, (Headers)headers, Optional.empty());
    }

    @Test
    public void testAddInstance() {
        this.store.configure(this.kafkaBasedLog, this.sessionUuid, Collections.singletonList(SSL_LISTENER_NAME));
        DefaultUserMetaDataStore store1 = new DefaultUserMetaDataStore(new HashMap(), new Metrics(), (Time)new MockTime());
        Assertions.assertThrows(IllegalStateException.class, () -> store1.configure(this.kafkaBasedLog, this.sessionUuid, Collections.singletonList(SSL_LISTENER_NAME)));
    }

    @Test
    public void testMultipleStarts() {
        Assertions.assertTrue((boolean)((DefaultUserMetaDataStore.State)this.store.state.get()).equals((Object)DefaultUserMetaDataStore.State.RUNNING));
        Assertions.assertThrows(IllegalStateException.class, () -> this.storeStart());
    }

    @Test
    public void testRead() {
        this.store.read(this.createConsumerRecord(1L, KEY1, VALUE1));
        this.store.read(this.createConsumerRecord(2L, KEY1, VALUE1));
        this.store.read(this.createConsumerRecord(2L, KEY2, VALUE2));
        this.store.read(this.createConsumerRecord(1L, KEY2, VALUE1));
        this.store.read(this.createConsumerRecord(1L, KEY4, VALUE1));
        Assertions.assertEquals((int)this.store.lastSequenceId().size(), (int)3);
        Assertions.assertEquals(this.store.userResourceIdToUserId(RESOURCE_ID1).get(), (Object)USER1);
        Assertions.assertEquals(this.store.userIdToUserResourceId(USER2).get(), (Object)RESOURCE_ID2);
        Assertions.assertEquals((int)this.store.numOfMapping(), (int)2);
        Assertions.assertEquals((double)TestUtils.getMetricValue((Metrics)this.metrics, (String)"user-metadata-count"), (double)3.0);
        Assertions.assertTrue((TestUtils.getMetricValue((Metrics)this.metrics, (String)"user-metadata-event-rate") > 0.0 ? 1 : 0) != 0);
        this.store.read(this.createConsumerRecord(3L, KEY1, null));
        this.store.read(this.createConsumerRecord(4L, KEY3, null));
        Assertions.assertEquals((double)TestUtils.getMetricValue((Metrics)this.metrics, (String)"user-metadata-count"), (double)2.0);
        this.store.read(this.createConsumerRecord(2L, KEY4, null));
        this.store.read(this.createConsumerRecord(3L, KEY2, null));
        Assertions.assertEquals((int)this.store.numOfMapping(), (int)0);
        Assertions.assertEquals((double)TestUtils.getMetricValue((Metrics)this.metrics, (String)"user-metadata-count"), (double)0.0);
        this.store.read(this.createConsumerRecord(5L, "invalid-key", VALUE1));
        this.store.read(this.createConsumerRecord(6L, KEY1, "invalid-value"));
        Assertions.assertEquals((double)TestUtils.getMetricValue((Metrics)this.metrics, (String)"user-metadata-count"), (double)0.0);
        Assertions.assertEquals((Long)((Long)this.store.lastSequenceId().get("invalid-key")), (long)5L);
        Assertions.assertEquals((Long)((Long)this.store.lastSequenceId().get(KEY1)), (long)6L);
        Assertions.assertTrue((TestUtils.getMetricValue((Metrics)this.metrics, (String)"user-metadata-event-failure-rate") > 0.0 ? 1 : 0) != 0);
        this.store.read(this.createConsumerRecord(1L, KEY5, VALUE1));
        Assertions.assertEquals((double)TestUtils.getMetricValue((Metrics)this.metrics, (String)"user-metadata-count"), (double)1.0);
    }
}

