/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth.token;

import dasniko.testcontainers.keycloak.KeycloakContainer;
import java.time.Duration;

public class IdentityProviderService {
    private static final String DEFAULT_REALM_CONFIG_PATH = "/IntegrationTestsRealm.json";
    private static final String ARM64_IMAGE_NAME = "mihaibob/keycloak:17.0.0-legacy";
    private static final String DEFAULT_IMAGE_NAME = "quay.io/keycloak/keycloak:17.0.0-legacy";
    private static final String ISSUER_FORMAT = "/realms/IntegrationTestsRealm";
    private static final String JWKS_ENDPOINT_FORMAT = "/realms/IntegrationTestsRealm/protocol/openid-connect/certs";
    private static final String TOKEN_ENDPOINT_FORMAT = "/realms/IntegrationTestsRealm/protocol/openid-connect/token";
    private KeycloakContainer keycloak;

    public IdentityProviderService() {
        this(DEFAULT_REALM_CONFIG_PATH);
    }

    public IdentityProviderService(String realmConfigPath) {
        String arch = System.getProperty("os.arch");
        String osName = System.getProperty("os.name");
        this.keycloak = arch != null && arch.contains("aarch64") || arch != null && osName != null && arch.startsWith("x86_64") && osName.contains("Mac") ? new KeycloakContainer(ARM64_IMAGE_NAME).withRealmImportFile(realmConfigPath) : new KeycloakContainer(DEFAULT_IMAGE_NAME).withRealmImportFile(realmConfigPath);
    }

    public void start() {
        this.keycloak.start();
    }

    public String getJwksEndpoint() {
        return this.keycloak.getAuthServerUrl() + JWKS_ENDPOINT_FORMAT;
    }

    public String getTokenEndpoint() {
        return this.keycloak.getAuthServerUrl() + TOKEN_ENDPOINT_FORMAT;
    }

    public String getIssuer() {
        return this.keycloak.getAuthServerUrl() + ISSUER_FORMAT;
    }

    public void shutdown() {
        this.keycloak.stop();
    }

    public void setStartupTimeout(Duration duration) {
        this.keycloak.withStartupTimeout(duration);
    }

    public void setCommand(String cmd) {
        this.keycloak.withCommand(cmd);
    }
}

