/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.test.cluster;

import io.confluent.kafka.multitenant.KafkaLogicalClusterMetadata;
import io.confluent.kafka.multitenant.KafkaLogicalClusterUtils;
import io.confluent.kafka.server.plugins.auth.BaseMultiTenantSaslSecretsStore;
import io.confluent.kafka.test.cluster.EmbeddedKafka;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kafka.server.ControllerServer;
import kafka.server.K2StackBuilderWrapper;
import kafka.server.KRaftQuorumImplementation;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.QuorumTestHarness;
import kafka.server.TestDataBalancer;
import kafka.utils.EmptyTestInfo;
import kafka.utils.TestInfoUtils;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class EmbeddedKafkaCluster {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedKafkaCluster.class);
    private static final int DEFAULT_BROKER_PORT = 0;
    private static final int DEFAULT_ZK_CLIENT_SESSION_TIMEOUT_MS = 10000;
    private static final int DEFAULT_ZK_CLIENT_CONNECTION_TIMEOUT_MS = 8000;
    private final Time time;
    private final TestInfo testInfo;
    private final List<EmbeddedKafka> brokers;
    private final AtomicInteger apiKeySeqId = new AtomicInteger();
    private KRaftQuorumImplementation kraftQuorum;
    private volatile ExecutorService controllerStartExecutor;
    private final CompletableFuture<Void> controllerStartFuture;

    public EmbeddedKafkaCluster() {
        this((Time)new MockTime());
    }

    public EmbeddedKafkaCluster(Time time) {
        this(time, (TestInfo)new EmptyTestInfo());
    }

    public EmbeddedKafkaCluster(Time time, TestInfo testInfo) {
        this.time = time;
        this.brokers = new ArrayList<EmbeddedKafka>();
        this.testInfo = testInfo;
        this.controllerStartExecutor = null;
        this.controllerStartFuture = new CompletableFuture();
    }

    @Deprecated
    public void startZooKeeper() {
        log.warn("You are using a deprecated 'startZookeeper' method in EmbeddedKafkaClusterThis will be removed in a future version. This method starts a raft or zk quorumdepending on the test mode and is only retained as convenience and to avoid breaking other code");
        this.startQuorum();
    }

    public void startQuorum() {
        this.startQuorum(new Properties());
    }

    public void startQuorum(Properties kraftControllerOverrides) {
        if (this.kraftQuorum == null) {
            log.debug("Starting a KRaft quorum instance.");
            this.kraftQuorum = new KRaftQuorumBuilder().addOverrideProps(kraftControllerOverrides, this.testInfo).build(this.testInfo);
            this.controllerStartExecutor = Executors.newSingleThreadScheduledExecutor(runnable -> {
                Thread thread = new Thread(runnable, "embedded-kafka-cluster-controller-server-start");
                thread.setDaemon(true);
                return thread;
            });
            this.controllerStartExecutor.submit(() -> {
                try {
                    this.kraftQuorum.controllerServer().startup();
                    this.controllerStartFuture.complete(null);
                    this.controllerStartExecutor.shutdown();
                }
                catch (Exception e) {
                    this.controllerStartFuture.completeExceptionally(e);
                }
            });
        }
    }

    public void waitForQuorumStart() {
        try {
            this.controllerStartFuture.get(10L, TimeUnit.MINUTES);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public void waitForListenerStart(ListenerName listenerName) throws InterruptedException {
        TestUtils.waitForCondition(() -> {
            List<KafkaBroker> brokers = this.kafkaBrokers();
            return !brokers.isEmpty() && brokers.stream().allMatch(broker -> {
                try {
                    return broker.boundPort(listenerName) != 0;
                }
                catch (Exception e) {
                    return false;
                }
            });
        }, (String)"Socket server is not open");
    }

    public void startBrokers(int numBrokers, Properties overrideProps) {
        this.startBrokers(numBrokers, overrideProps, Optional.empty());
    }

    public void startBrokers(int numBrokers, Properties overrideProps, Optional<K2StackBuilderWrapper> stackBuilderOverride) {
        log.debug("Initiating embedded Kafka cluster startup with config {}", (Object)overrideProps);
        int brokerIdStart = Integer.parseInt(overrideProps.getOrDefault((Object)"broker.id", "0").toString());
        for (int i = 0; i < numBrokers; ++i) {
            this.startBroker(brokerIdStart + i, overrideProps, stackBuilderOverride);
        }
    }

    public void startBroker(int brokerId, Properties overrideProps, Optional<K2StackBuilderWrapper> stackBuilderOverride) {
        Properties brokerConfig = this.createBrokerConfig(brokerId, overrideProps);
        log.debug("Starting a Kafka instance on {}", brokerConfig.get("listeners"));
        EmbeddedKafka.Builder builder = new EmbeddedKafka.Builder(this.time).addConfigs(brokerConfig).setStackBuilderOverride(stackBuilderOverride);
        builder.setControllerServer(this.kraftQuorum.controllerServer());
        EmbeddedKafka kafka = builder.build(this.testInfo);
        this.brokers.add(kafka);
        kafka.startKafkaBroker();
        log.debug("Kafka instance started: {}", (Object)kafka);
    }

    public Properties createBrokerConfig(int brokerId, Properties overrideProps) {
        log.debug("Initiating embedded Kafka cluster startup with config {}", (Object)overrideProps);
        Properties brokerConfig = new Properties();
        brokerConfig.put("node.id", Integer.toString(brokerId));
        brokerConfig.put("broker.id", Integer.toString(brokerId));
        brokerConfig.put("listeners", "PLAINTEXT://localhost:0");
        brokerConfig.put("replica.socket.timeout.ms", (Object)1500);
        brokerConfig.put("controller.socket.timeout.ms", (Object)1500);
        brokerConfig.put("broker.heartbeat.interval.ms", (Object)50);
        brokerConfig.put("log.cleaner.dedupe.buffer.size", (Object)0x200000);
        this.putIfAbsent(brokerConfig, "offsets.topic.replication.factor", (short)1);
        this.putIfAbsent(brokerConfig, "confluent.license.topic.replication.factor", (short)1);
        this.putIfAbsent(brokerConfig, "confluent.security.event.logger.exporter.kafka.topic.replicas", (short)1);
        brokerConfig.putAll((Map<?, ?>)overrideProps);
        this.putIfAbsent(brokerConfig, "connection.failed.authentication.delay.ms", 0);
        this.putIfAbsent(brokerConfig, "group.initial.rebalance.delay.ms", 0);
        this.putIfAbsent(brokerConfig, "offsets.topic.num.partitions", 5);
        this.putIfAbsent(brokerConfig, "auto.create.topics.enable", true);
        this.putIfAbsent(brokerConfig, KafkaConfig.BrokerSessionUuidProp(), Uuid.randomUuid().toString());
        if (brokerId > 0) {
            brokerConfig.put(KafkaConfig.BrokerSessionUuidProp(), brokerConfig.getProperty(KafkaConfig.BrokerSessionUuidProp()) + brokerId);
        }
        brokerConfig.put("broker.id", (Object)brokerId);
        brokerConfig.put("node.id", (Object)brokerId);
        this.putIfAbsent(brokerConfig, "log.cleaner.dedupe.buffer.size", "2097152");
        this.putIfAbsent(brokerConfig, "confluent.balancer.class", TestDataBalancer.class.getCanonicalName());
        this.putIfAbsent(brokerConfig, "confluent.metadata.server.listeners", "");
        this.putIfAbsent(brokerConfig, "unstable.feature.versions.enable", "true");
        this.putIfAbsent(brokerConfig, "unstable.api.versions.enable", "true");
        return brokerConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void concurrentStartBrokers(List<Properties> brokerConfigs, Duration timeout) throws Exception {
        int numBrokers = brokerConfigs.size();
        ArrayList<Future<EmbeddedKafka>> brokerFutures = new ArrayList<Future<EmbeddedKafka>>(numBrokers);
        ExecutorService executorService = Executors.newFixedThreadPool(numBrokers);
        try {
            for (Properties brokerConfig : brokerConfigs) {
                if (TestInfoUtils.isCombinedKRaft((TestInfo)this.testInfo)) {
                    brokerConfig.setProperty("process.roles", "broker,controller");
                }
                brokerFutures.add(executorService.submit(() -> {
                    log.debug("Starting a Kafka instance on {} ...", brokerConfig.get("listeners"));
                    EmbeddedKafka.Builder builder = new EmbeddedKafka.Builder(this.time).addConfigs(brokerConfig);
                    builder.setControllerServer(this.kraftQuorum.controllerServer());
                    EmbeddedKafka kafka = builder.build(this.testInfo);
                    kafka.startKafkaBroker();
                    return kafka;
                }));
            }
            AtomicReference<Exception> firstException = new AtomicReference<Exception>();
            for (Future future : brokerFutures) {
                try {
                    EmbeddedKafka broker = (EmbeddedKafka)future.get(timeout.toMillis(), TimeUnit.MILLISECONDS);
                    this.brokers.add(broker);
                    log.debug("Kafka instance started: {}", (Object)broker);
                }
                catch (Exception t) {
                    firstException.compareAndSet(null, t);
                }
            }
            if (firstException.get() != null) {
                throw (Exception)firstException.get();
            }
        }
        finally {
            executorService.shutdownNow();
            executorService.awaitTermination(30L, TimeUnit.SECONDS);
        }
    }

    private void putIfAbsent(Properties brokerConfig, String propertyKey, Object propertyValue) {
        if (!brokerConfig.containsKey(propertyKey)) {
            brokerConfig.put(propertyKey, propertyValue);
        }
    }

    public void shutdownBrokers() {
        for (EmbeddedKafka broker : this.brokers) {
            if (broker == null) continue;
            broker.shutdown();
        }
        this.brokers.clear();
    }

    private void shutdownQuorum() {
        Optional.ofNullable(this.controllerStartExecutor).ifPresent(ExecutorService::shutdownNow);
        if (this.kraftQuorum != null) {
            try {
                this.kraftQuorum.shutdown();
            }
            catch (Throwable e) {
                log.error("Error shutting down KRaft quorum", e);
                throw e;
            }
            finally {
                this.kraftQuorum = null;
            }
        }
    }

    public void shutdown() {
        for (EmbeddedKafka broker : this.brokers) {
            if (broker == null) continue;
            broker.shutdownAndCleanup();
        }
        this.shutdownQuorum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void concurrentShutdown() {
        try {
            int numBrokers = this.brokers.size();
            if (numBrokers <= 1) {
                this.shutdownBrokers();
                return;
            }
            ExecutorService executorService = Executors.newFixedThreadPool(numBrokers);
            ArrayList<Future<Object>> shutdownFutures = new ArrayList<Future<Object>>(numBrokers);
            try {
                for (EmbeddedKafka embeddedKafka : this.brokers) {
                    if (embeddedKafka == null) continue;
                    shutdownFutures.add(executorService.submit(embeddedKafka::shutdownAndCleanup, null));
                }
                for (Future future : shutdownFutures) {
                    future.get(60L, TimeUnit.SECONDS);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                executorService.shutdownNow();
            }
        }
        finally {
            this.shutdownQuorum();
        }
    }

    public String zkConnect() {
        return null;
    }

    public String bootstrapServers(String listener) {
        return this.brokers.stream().map(broker -> broker.brokerConnect(listener)).collect(Collectors.joining(","));
    }

    public String bootstrapServers() {
        List<String> listeners = this.brokers.get(0).listeners();
        if (listeners.size() > 2) {
            throw new IllegalStateException("Listener name not specified for listeners " + String.valueOf(listeners));
        }
        String listener = listeners.get(0);
        if (listeners.size() > 1 && this.brokers.get(0).kafkaBroker().config().interBrokerListenerName().value().equals(listener)) {
            listener = listeners.get(1);
        }
        return this.bootstrapServers(listener);
    }

    public void createTopic(String topic, int partitions, int replication) {
        this.createTopic(topic, partitions, replication, new Properties());
    }

    public void createTopic(String topic, int partitions, int replication, Properties propOverrides) {
        this.brokers.get(0).createTopic(new ListenerName("INTERNAL"), topic, partitions, replication, propOverrides);
        ArrayList<TopicPartition> topicPartitions = new ArrayList<TopicPartition>();
        for (int partition = 0; partition < partitions; ++partition) {
            topicPartitions.add(new TopicPartition(topic, partition));
        }
    }

    public List<EmbeddedKafka> kafkas() {
        return Collections.unmodifiableList(this.brokers);
    }

    public List<KafkaBroker> kafkaBrokers() {
        return this.brokers.stream().map(EmbeddedKafka::kafkaBroker).collect(Collectors.toList());
    }

    public ControllerServer kraftController() {
        return this.kraftQuorum.controllerServer();
    }

    public void restartBrokers() throws IOException {
        for (EmbeddedKafka kafka : this.brokers) {
            kafka.shutdown();
            kafka.startBroker();
        }
    }

    public void produceData(String topic, int numMessages) {
        KafkaProducer<String, String> producer = KafkaTestUtils.createProducer(this.bootstrapServers(), SecurityProtocol.PLAINTEXT, "PLAIN", "");
        List messages = IntStream.range(1, numMessages).asLongStream().mapToObj(num -> String.format("test-%d", num)).collect(Collectors.toList());
        for (String message : messages) {
            try {
                producer.send(new ProducerRecord(topic, (Object)topic, (Object)message)).get();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        producer.flush();
        producer.close();
    }

    public void produceData(String topic, long sequenceId, String key, String value) {
        try (KafkaProducer<String, String> producer = KafkaTestUtils.createProducer(this.bootstrapServers("INTERNAL"), SecurityProtocol.PLAINTEXT, "PLAIN", "");){
            RecordHeaders headers = KafkaTestUtils.createGoodSequenceIdRecordHeaders(sequenceId);
            producer.send(new ProducerRecord(topic, Integer.valueOf(0), (Object)key, (Object)value, (Iterable)headers)).get();
            producer.flush();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void produceApiKeysData(String topic, String messageKey, String apiKeys, boolean doVerify) {
        this.produceData(topic, this.apiKeySeqId.incrementAndGet(), messageKey, apiKeys);
        if (doVerify) {
            this.verifyApiKeyDataPropagated(messageKey, apiKeys != null);
        }
    }

    public void verifyApiKeyDataPropagated(String apiKey, boolean expectApiKeyPresent) {
        try {
            TestUtils.waitForCondition(() -> this.brokers.stream().allMatch(kafka -> this.keyUpdatedInStore((EmbeddedKafka)kafka, apiKey, expectApiKeyPresent)), (String)"Timed out waiting for api key data to propagate to secrets");
        }
        catch (Exception e) {
            Assertions.fail((String)"Timed out waiting for api key data propagation");
        }
    }

    private boolean keyUpdatedInStore(EmbeddedKafka kafka, String apiKey, boolean expectKeyPresent) {
        Map secrets = BaseMultiTenantSaslSecretsStore.getInstance((String)kafka.brokerSessionUuid()).load().entries();
        if (expectKeyPresent) {
            return secrets.containsKey(apiKey);
        }
        return !secrets.containsKey(apiKey);
    }

    public void produceLCMData(String topic, long sequenceId, String lkcId, KafkaLogicalClusterMetadata lcm) {
        try (KafkaProducer<String, byte[]> producer = KafkaTestUtils.createByteProducer(this.bootstrapServers("INTERNAL"), SecurityProtocol.PLAINTEXT, "PLAIN", "");){
            RecordHeaders headers = KafkaTestUtils.createGoodSequenceIdRecordHeaders(sequenceId);
            byte[] message = null;
            if (lcm != null) {
                message = KafkaLogicalClusterUtils.protoFromMetadata((KafkaLogicalClusterMetadata)lcm).toByteArray();
            }
            producer.send(new ProducerRecord(topic, Integer.valueOf(0), (Object)lkcId, (Object)message, (Iterable)headers)).get();
            producer.flush();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void waitUntilAclsPropagated(AclBinding aclBinding) throws Exception {
        TestUtils.waitForCondition(() -> this.kafkaBrokers().stream().map(KafkaBroker::authorizer).allMatch(authorizer -> authorizer.forall(authz -> authz.acls(aclBinding.toFilter()).iterator().hasNext())), (String)"ACLs not propagated");
    }

    static class KRaftQuorumBuilder
    extends QuorumTestHarness {
        private final Properties overrideProps = new Properties();

        KRaftQuorumBuilder() {
        }

        public KRaftQuorumBuilder addOverrideProps(Properties props, TestInfo testInfo) {
            int nodeId = Integer.parseInt(props.getOrDefault((Object)"node.id", props.getOrDefault((Object)"broker.id", "1000")).toString());
            if (!TestInfoUtils.isCombinedKRaft((TestInfo)testInfo) && nodeId < 1000) {
                nodeId += 1000;
            }
            props.setProperty("node.id", Integer.toString(nodeId));
            props.setProperty("broker.id", Integer.toString(nodeId));
            this.overrideProps.putAll((Map<?, ?>)props);
            return this;
        }

        public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
            List nodeProperties = JavaConverters.seqAsJavaList((Seq)super.kraftControllerConfigs(testInfo));
            List overriddenNodeProperties = nodeProperties.stream().map(baseProps -> {
                Properties props = new Properties();
                props.putAll((Map<?, ?>)baseProps);
                props.putAll((Map<?, ?>)this.overrideProps);
                return props;
            }).collect(Collectors.toList());
            return JavaConverters.asScalaBuffer(overriddenNodeProperties);
        }

        KRaftQuorumImplementation build(TestInfo testInfo) {
            return this.newKRaftQuorum(testInfo, new Properties(), false);
        }
    }
}

