/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.test.utils;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import io.confluent.kafka.clients.plugins.auth.oauth.OAuthBearerLoginCallbackHandler;
import io.confluent.kafka.server.plugins.auth.oauth.OAuthBearerServerLoginCallbackHandler;
import io.confluent.kafka.server.plugins.auth.oauth.OAuthBearerValidatorCallbackHandler;
import io.confluent.kafka.server.plugins.auth.oauth.OAuthUtils;
import io.confluent.kafka.test.cluster.EmbeddedKafkaCluster;
import io.confluent.license.validator.ConfluentLicenseValidator;
import java.io.File;
import java.security.Security;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.security.auth.login.Configuration;
import kafka.admin.ConfigCommand;
import kafka.server.KafkaBroker;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.authenticator.LoginManager;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;

public class SecurityTestUtils {
    public static String createScramUser(EmbeddedKafkaCluster kafkaCluster, String userName, String password) {
        String mechanism = ScramMechanism.SCRAM_SHA_256.mechanismName();
        String credentials = String.format("%s=[iterations=4096,password=%s]", mechanism, password);
        String[] args = new String[]{"--alter", "--add-config", credentials, "--entity-type", "users", "--entity-name", userName};
        ConfigCommand.main((String[])args);
        for (KafkaBroker server : kafkaCluster.kafkaBrokers()) {
            CredentialCache.Cache cache = server.credentialProvider().credentialCache().cache(mechanism, ScramCredential.class);
            try {
                TestUtils.waitForCondition(() -> cache.get(userName) != null, (String)("SCRAM credentials not created for user " + userName));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return password;
    }

    public static void deleteScramUser(EmbeddedKafkaCluster kafkaCluster, String userName) {
        String mechanism = ScramMechanism.SCRAM_SHA_256.mechanismName();
        String[] args = new String[]{"--alter", "--delete-config", mechanism, "--entity-type", "users", "--entity-name", userName};
        ConfigCommand.main((String[])args);
        for (KafkaBroker broker : kafkaCluster.kafkaBrokers()) {
            CredentialCache.Cache cache = broker.credentialProvider().credentialCache().cache(mechanism, ScramCredential.class);
            try {
                TestUtils.waitForCondition(() -> cache.get(userName) == null, (String)("SCRAM credentials not deleted for user " + userName));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static String scramSaslJaasConfig(String username, String password) {
        return "org.apache.kafka.common.security.scram.ScramLoginModule required\nusername=\"" + username + "\"\npassword=\"" + password + "\";\n";
    }

    public static String gssapiSaslJaasConfig(File keytabFile, String principal, String serviceName) {
        StringBuilder builder = new StringBuilder();
        builder.append("com.sun.security.auth.module.Krb5LoginModule required\n");
        builder.append("debug=true\n");
        if (serviceName != null) {
            builder.append("serviceName=\"");
            builder.append(serviceName);
            builder.append("\"\n");
        }
        builder.append("keyTab=\"" + keytabFile.getAbsolutePath() + "\"\n");
        builder.append("principal=\"");
        builder.append(principal);
        builder.append("\"\n");
        builder.append("storeKey=\"true\"\n");
        builder.append("useKeyTab=\"true\";\n");
        return builder.toString();
    }

    public static String oauthBearerSaslJaasConfig(String clientId, String clientSecret) {
        StringBuilder builder = new StringBuilder();
        builder.append("org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required\n");
        builder.append("clientId=\"");
        builder.append(clientId);
        builder.append("\"\n");
        builder.append("clientSecret=\"");
        builder.append(clientSecret);
        builder.append("\";");
        return builder.toString();
    }

    public static void clearSecurityConfigs() {
        System.getProperties().stringPropertyNames().stream().filter(name -> name.startsWith("java.security.krb5")).forEach(System::clearProperty);
        System.clearProperty("org.apache.kafka.sasl.oauthbearer.allowed.urls");
        LoginManager.closeAll();
        Configuration.setConfiguration(null);
        Security.removeProvider("ConfluentTrustProvider");
    }

    public static void waitForAclUpdate(Authorizer authorizer, KafkaPrincipal principal, ResourcePattern resourcePattern, AclOperation op, boolean deleted) {
        try {
            TestUtils.waitForCondition(() -> {
                Iterable acls = authorizer.acls(new AclBindingFilter(resourcePattern.toFilter(), AccessControlEntryFilter.ANY));
                boolean matches = false;
                for (AclBinding acl : acls) {
                    AccessControlEntry entry = acl.entry();
                    if (!entry.operation().equals((Object)op) || !entry.principal().equals(principal.toString())) continue;
                    matches = true;
                    break;
                }
                return deleted != matches;
            }, (String)"ACLs not updated");
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Wait was interrupted", e);
        }
    }

    public static void verifyConfluentLicense(EmbeddedKafkaCluster kafkaCluster, ConfluentLicenseValidator.LicenseStatus expectedStatus) {
        Map<String, Metric> metrics = KafkaYammerMetrics.defaultRegistry().allMetrics().entrySet().stream().filter(e -> ((MetricName)e.getKey()).getName().equals("licenseStatus")).collect(Collectors.toMap(e -> ((MetricName)e.getKey()).getGroup(), Map.Entry::getValue));
        if (expectedStatus != null) {
            metrics.forEach((k, v) -> Assertions.assertEquals((Object)expectedStatus.name().toLowerCase(Locale.ROOT), (Object)((Gauge)v).value(), (String)("Unexpected license metric for " + k)));
        }
    }

    public static void attachServerOAuthConfigs(Map<String, Object> configs, List<String> serverMechanisms, String listenerPrefix, OAuthUtils.JwsContainer jwsContainer) {
        configs.put("sasl.enabled.mechanisms", serverMechanisms);
        configs.put(listenerPrefix + ".oauthbearer.sasl.login.callback.handler.class", OAuthBearerServerLoginCallbackHandler.class.getName());
        configs.put(listenerPrefix + ".oauthbearer.sasl.server.callback.handler.class", OAuthBearerValidatorCallbackHandler.class.getName());
        configs.put(listenerPrefix + ".oauthbearer.sasl.jaas.config", "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required publicKeyPath=\"" + String.valueOf(jwsContainer.getPublicKeyFile().toPath()) + "\";");
    }

    public static void attachMechanisms(Map<String, Object> saslClientConfigs, String clientMechanism, OAuthUtils.JwsContainer jwsContainer, String allowedCluster) {
        saslClientConfigs.put("sasl.mechanism", clientMechanism);
        saslClientConfigs.put("sasl.login.callback.handler.class", OAuthBearerLoginCallbackHandler.class.getName());
        saslClientConfigs.put("sasl.jaas.config", "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule Required token=\"" + jwsContainer.getJwsToken() + "\" cluster=\"" + allowedCluster + "\";");
    }
}

