/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.audit;

import io.confluent.kafka.multitenant.BasePhysicalClusterMetadata;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.audit.TenantSanitizer;
import io.confluent.kafka.security.audit.event.ConfluentAuthenticationEvent;
import io.confluent.security.authorizer.AclAccessRule;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.AuthorizePolicy;
import io.confluent.security.authorizer.RequestContext;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.ConfluentAuthorizationEvent;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.network.BrokerFqdnBuilder;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.security.auth.IdentityMetadata;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.server.audit.AuditEvent;
import org.apache.kafka.server.audit.AuditEventType;
import org.apache.kafka.server.audit.AuthenticationEvent;
import org.apache.kafka.server.audit.DefaultAuthenticationEvent;
import org.apache.kafka.server.multitenant.LogicalClusterMetadata;

public class DefaultTenantSanitizer
implements TenantSanitizer {
    public static final String PRINCIPAL_RESOURCE_ID = "principal-resource-id";
    private Map<String, ?> configs;

    private KafkaPrincipal tenantPrincipal(MultiTenantPrincipal principal) {
        String user = principal.maybeGetIdentityMetadata().flatMap(IdentityMetadata::maybeGetPoolId).orElse(principal.user());
        return new KafkaPrincipal("User", user);
    }

    private KafkaPrincipal tenantPrincipal(KafkaPrincipal principal) {
        int index;
        if ("TenantUser".equals(principal.getPrincipalType()) && (index = principal.getName().indexOf("_")) > 0) {
            return new KafkaPrincipal("User", principal.getName().substring(index + 1));
        }
        throw new NotTenantPrefixedException("Expected a multi-tenant principal: " + String.valueOf(principal));
    }

    private Scope tenantScope(Scope scope, String tenantClusterId, String organizationId, String environmentId) {
        Scope.Builder builder = new Scope.Builder(new String[0]);
        scope.path().forEach(arg_0 -> ((Scope.Builder)builder).addPath(arg_0));
        if (organizationId != null && environmentId != null) {
            builder.addPath("organization=" + organizationId).addPath("environment=" + environmentId).addPath("cloud-cluster=" + tenantClusterId);
        }
        scope.clusters().forEach((k, v) -> {
            if (k.equals("kafka-cluster")) {
                builder.withKafkaCluster(tenantClusterId);
            } else {
                builder.withCluster(k, v);
            }
        });
        return builder.build();
    }

    private io.confluent.security.authorizer.ResourcePattern tenantResourcePattern(io.confluent.security.authorizer.ResourcePattern resourcePattern, String tenantPrefix) {
        if (!resourcePattern.name().startsWith(tenantPrefix)) {
            throw new NotTenantPrefixedException("Expected a multi-tenant prefix: " + resourcePattern.name());
        }
        return new io.confluent.security.authorizer.ResourcePattern(resourcePattern.resourceType(), resourcePattern.name().substring(tenantPrefix.length()), resourcePattern.patternType());
    }

    private RequestContext tenantRequestContext(final RequestContext requestContext) {
        return new RequestContext(){

            public KafkaPrincipal principal() {
                return DefaultTenantSanitizer.this.tenantPrincipal((MultiTenantPrincipal)requestContext.principal());
            }

            public String requestSource() {
                return requestContext.requestSource();
            }

            public String listenerName() {
                return requestContext.listenerName();
            }

            public SecurityProtocol securityProtocol() {
                return requestContext.securityProtocol();
            }

            public InetAddress clientAddress() {
                return requestContext.clientAddress();
            }

            public boolean isProxyModeLocal() {
                return requestContext.isProxyModeLocal();
            }

            public BrokerFqdnBuilder.FQDNPropertiesFromPPV2 fqdnPropertiesFromPpv2() {
                return requestContext.fqdnPropertiesFromPpv2();
            }

            public int requestType() {
                return requestContext.requestType();
            }

            public int requestVersion() {
                return requestContext.requestVersion();
            }

            public String clientId() {
                return requestContext.clientId();
            }

            public int correlationId() {
                return requestContext.correlationId();
            }

            public long kafkaRequestId() {
                return requestContext.kafkaRequestId();
            }

            public long sessionId() {
                return requestContext.sessionId();
            }
        };
    }

    private AccessControlEntry tenantAccessControlEntry(AccessControlEntry entry) {
        return new AccessControlEntry(this.tenantPrincipal(SecurityUtils.parseKafkaPrincipal((String)entry.principal())).toString(), entry.host(), entry.operation(), entry.permissionType(), entry.clusterLinkIds());
    }

    private AclAccessRule tenantAclAccessRule(AclAccessRule accessRule, String tenantPrefix) {
        AclBinding aclBinding = accessRule.aclBinding();
        AclBinding tenantAclBinding = new AclBinding(io.confluent.security.authorizer.ResourcePattern.to((io.confluent.security.authorizer.ResourcePattern)this.tenantResourcePattern(io.confluent.security.authorizer.ResourcePattern.from((ResourcePattern)aclBinding.pattern()), tenantPrefix)), this.tenantAccessControlEntry(aclBinding.entry()));
        return new AclAccessRule(this.tenantResourcePattern(accessRule.resourcePattern(), tenantPrefix), this.tenantPrincipal(accessRule.principal()), accessRule.permissionType(), accessRule.host(), accessRule.operation(), accessRule.policyType(), tenantAclBinding);
    }

    private AuthorizePolicy tenantAuthorizePolicy(AuthorizePolicy authorizePolicy, String tenantPrefix) {
        switch (authorizePolicy.policyType()) {
            case DENY_ACL: 
            case ALLOW_ACL: {
                return this.tenantAclAccessRule((AclAccessRule)authorizePolicy, tenantPrefix);
            }
        }
        return authorizePolicy;
    }

    @Override
    public AuditEvent tenantAuditEvent(AuditEvent auditEvent, String defaultKafkaClusterId) {
        if (auditEvent.type() == AuditEventType.AUTHORIZATION) {
            return this.handleAuthorizationEvent((ConfluentAuthorizationEvent)auditEvent);
        }
        if (auditEvent.type() == AuditEventType.AUTHENTICATION) {
            AuditEvent auditEvent1 = this.handleAuthenticationEvent((ConfluentAuthenticationEvent)auditEvent, defaultKafkaClusterId);
            return auditEvent1;
        }
        return auditEvent;
    }

    @Override
    public AuditEvent tenantAuditEvent(AuditEvent auditEvent) {
        return this.tenantAuditEvent(auditEvent, null);
    }

    public void configure(Map<String, ?> configs) {
        this.configs = configs;
    }

    private Map<String, Object> getData(String userResourceId, AuditEvent auditEvent) {
        if (auditEvent.data().isEmpty()) {
            return Collections.singletonMap(PRINCIPAL_RESOURCE_ID, userResourceId);
        }
        HashMap<String, Object> data = new HashMap<String, Object>(auditEvent.data());
        data.put(PRINCIPAL_RESOURCE_ID, userResourceId);
        return data;
    }

    AuditEvent handleAuthorizationEvent(ConfluentAuthorizationEvent auditEvent) {
        if (auditEvent.requestContext().principal() instanceof MultiTenantPrincipal) {
            TenantMetadata metadata = ((MultiTenantPrincipal)auditEvent.requestContext().principal()).tenantMetadata();
            RequestContext tenantRequestContext = this.tenantRequestContext(auditEvent.requestContext());
            io.confluent.security.authorizer.ResourcePattern tenantResourcePattern = this.tenantResourcePattern(auditEvent.action().resourcePattern(), metadata.tenantPrefix());
            Action tenantAction = new Action(auditEvent.action().scope(), tenantResourcePattern, auditEvent.action().operation(), auditEvent.action().resourceReferenceCount(), auditEvent.action().logIfAllowed(), auditEvent.action().logIfDenied());
            AuthorizePolicy tenantAuthorizePolicy = this.tenantAuthorizePolicy(auditEvent.authorizePolicy(), metadata.tenantPrefix());
            ConfluentAuthorizationEvent sanitizeAuditEvent = new ConfluentAuthorizationEvent(auditEvent.action().scope(), tenantRequestContext, tenantAction, auditEvent.authorizeResult(), tenantAuthorizePolicy, auditEvent.timestamp());
            if (metadata.userResourceId != null) {
                sanitizeAuditEvent.setData(this.getData(metadata.userResourceId, (AuditEvent)auditEvent));
            }
            return sanitizeAuditEvent;
        }
        return auditEvent;
    }

    private AuditEvent handleAuthenticationEvent(ConfluentAuthenticationEvent auditEvent, String defaultKafkaClusterId) {
        if (auditEvent.principal().orElse(null) instanceof MultiTenantPrincipal) {
            MultiTenantPrincipal principal = (MultiTenantPrincipal)auditEvent.principal().get();
            DefaultAuthenticationEvent defaultEvent = new DefaultAuthenticationEvent(this.tenantPrincipal(principal), auditEvent.authenticationContext(), auditEvent.status(), (AuthenticationException)auditEvent.authenticationException().orElse(null), auditEvent.timestamp());
            ConfluentAuthenticationEvent sanitizeAuditEvent = new ConfluentAuthenticationEvent((AuthenticationEvent)defaultEvent, principal.tenantMetadata().scope());
            if (principal.tenantMetadata().userResourceId != null) {
                sanitizeAuditEvent.setData(this.getData(principal.tenantMetadata().userResourceId, (AuditEvent)auditEvent));
            }
            return sanitizeAuditEvent;
        }
        if (auditEvent.authenticationException().isPresent()) {
            AuthenticationException exception = auditEvent.authenticationException().get();
            String lkcId = this.getLKCIdFromException(exception);
            String userResourceId = this.getUserResourceIdFromException(exception);
            if (!lkcId.isEmpty() && this.configs != null) {
                Object uuid = this.configs.get(KafkaConfig.BrokerSessionUuidProp());
                if (uuid == null || uuid.toString().isEmpty()) {
                    throw new ConfigException("Broker session UUID must be set in the Kafka config!");
                }
                BasePhysicalClusterMetadata clusterMetadata = BasePhysicalClusterMetadata.getInstance((String)uuid.toString());
                LogicalClusterMetadata logicalClusterMetadata = null;
                if (clusterMetadata != null) {
                    logicalClusterMetadata = clusterMetadata.metadata(lkcId);
                }
                String organizationId = logicalClusterMetadata != null ? logicalClusterMetadata.organizationId() : null;
                String environmentId = logicalClusterMetadata != null ? logicalClusterMetadata.environmentId() : null;
                Scope tenantScope = this.tenantScope(auditEvent.getScope(), lkcId, organizationId, environmentId);
                ConfluentAuthenticationEvent sanitizeAuditEvent = new ConfluentAuthenticationEvent((AuthenticationEvent)new DefaultAuthenticationEvent((KafkaPrincipal)auditEvent.principal().orElse(null), auditEvent.authenticationContext(), auditEvent.status(), (AuthenticationException)auditEvent.authenticationException().orElse(null), auditEvent.timestamp()), tenantScope);
                if (userResourceId != null) {
                    sanitizeAuditEvent.setData(this.getData(userResourceId, (AuditEvent)auditEvent));
                }
                return sanitizeAuditEvent;
            }
        }
        if (defaultKafkaClusterId == null) {
            return auditEvent;
        }
        return new ConfluentAuthenticationEvent((AuthenticationEvent)new DefaultAuthenticationEvent((KafkaPrincipal)auditEvent.principal().orElse(null), auditEvent.authenticationContext(), auditEvent.status(), (AuthenticationException)auditEvent.authenticationException().orElse(null), auditEvent.timestamp()), this.tenantScope(auditEvent.getScope(), defaultKafkaClusterId, null, null));
    }

    private String getLKCIdFromException(AuthenticationException exception) {
        String clusterId = exception.errorInfo().clusterId();
        if (!clusterId.isEmpty()) {
            return clusterId;
        }
        return exception.errorInfo().saslExtensions().getOrDefault("logicalCluster", "");
    }

    private String getUserResourceIdFromException(AuthenticationException exception) {
        return (String)exception.errorInfo().data().get("USER_RESOURCE_ID");
    }

    public static class NotTenantPrefixedException
    extends RuntimeException {
        public NotTenantPrefixedException(String message) {
            super(message);
        }
    }
}

