/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.authorizer;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.security.authorizer.acl.ExtendedAccessRuleProvider;
import io.confluent.kafka.security.authorizer.acl.StandardAclProvider;
import io.confluent.security.authorizer.AccessRule;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.AccessRuleProvider;
import io.confluent.security.authorizer.provider.AuthorizeRule;
import io.confluent.security.authorizer.provider.ConfluentBuiltInProviders;
import io.confluent.security.authorizer.provider.ResourceAuthorizeRules;
import io.confluent.security.roledefinitions.Operation;
import io.confluent.security.roledefinitions.ResourceType;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.security.authorizer.AclEntry;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;

public class TenantAclProvider
implements AccessRuleProvider,
Reconfigurable {
    private ExtendedAccessRuleProvider underlying;
    private boolean supportUserResourceId;

    public TenantAclProvider() {
    }

    TenantAclProvider(ExtendedAccessRuleProvider underlying) {
        this.underlying = underlying;
    }

    public void configure(Map<String, ?> configs) {
        this.supportUserResourceId = false;
        if (configs.containsKey("multitenant.authorizer.support.resource.ids")) {
            this.supportUserResourceId = Boolean.parseBoolean((String)configs.get("multitenant.authorizer.support.resource.ids"));
        }
        if (this.underlying == null) {
            this.underlying = new StandardAclProvider();
        }
        this.underlying.configure(configs);
    }

    public Set<String> reconfigurableConfigs() {
        HashSet<String> configs = new HashSet<String>();
        configs.add("multitenant.authorizer.support.resource.ids");
        return configs;
    }

    public void validateReconfiguration(Map<String, ?> configs) throws ConfigException {
    }

    public void reconfigure(Map<String, ?> configs) {
        this.supportUserResourceId = false;
        if (configs.containsKey("multitenant.authorizer.support.resource.ids")) {
            this.supportUserResourceId = (Boolean)configs.get("multitenant.authorizer.support.resource.ids");
        }
    }

    public CompletionStage<Void> start(ConfluentAuthorizerServerInfo serverInfo) {
        return this.underlying.start(serverInfo);
    }

    public String providerName() {
        return ConfluentBuiltInProviders.AccessRuleProviders.MULTI_TENANT.name();
    }

    private Set<KafkaPrincipal> matchingPrincipals(KafkaPrincipal sessionPrincipal, Set<KafkaPrincipal> groupPrincipals) {
        if (!groupPrincipals.isEmpty()) {
            throw new UnsupportedOperationException("Groups are not supported for TenantAclProvider");
        }
        String tenantPrefix = sessionPrincipal instanceof MultiTenantPrincipal ? ((MultiTenantPrincipal)sessionPrincipal).tenantMetadata().tenantPrefix() : "";
        KafkaPrincipal wildcardPrincipal = tenantPrefix.isEmpty() ? AclEntry.WILDCARD_PRINCIPAL : new KafkaPrincipal("TenantUser*", tenantPrefix);
        HashSet<KafkaPrincipal> matchingPrincipals = new HashSet<KafkaPrincipal>(Set.of(AccessRule.asBaseKafkaPrincipal((KafkaPrincipal)sessionPrincipal), wildcardPrincipal));
        if (sessionPrincipal instanceof MultiTenantPrincipal) {
            for (String authorizationId : ((MultiTenantPrincipal)sessionPrincipal).authorizationIds()) {
                matchingPrincipals.add(new KafkaPrincipal(sessionPrincipal.getPrincipalType(), tenantPrefix + authorizationId));
            }
        }
        return matchingPrincipals;
    }

    public boolean isSuperUser(KafkaPrincipal principal, Scope scope) {
        return this.underlying.isSuperUser(principal, scope);
    }

    public AuthorizeRule findRule(KafkaPrincipal sessionPrincipal, Set<KafkaPrincipal> groupPrincipals, String host, Action action) {
        return this.underlying.findRule(this.matchingPrincipals(sessionPrincipal, groupPrincipals), host, action);
    }

    public void addMatchingRules(ResourceAuthorizeRules matchingRules, KafkaPrincipal sessionPrincipal, Set<KafkaPrincipal> groupPrincipals, String host, Operation operation, Scope resourceScope, ResourceType resourceType) {
        this.underlying.addMatchingRules(matchingRules, this.matchingPrincipals(sessionPrincipal, groupPrincipals), host, operation, resourceScope, resourceType);
    }

    public boolean mayDeny() {
        return true;
    }

    public boolean usesMetadataFromThisKafkaCluster() {
        return this.underlying.usesMetadataFromThisKafkaCluster();
    }

    public Optional<Authorizer> asAuthorizer() {
        return this.underlying.asAuthorizer();
    }

    public void close() throws IOException {
        if (this.underlying != null) {
            this.underlying.close();
        }
        this.underlying = null;
    }
}

