/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth.token;

import io.confluent.kafka.clients.plugins.auth.jwt.JwtAuthenticator;
import io.confluent.kafka.clients.plugins.auth.jwt.JwtAuthenticatorConfig;
import io.confluent.kafka.clients.plugins.auth.jwt.JwtVerificationException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerExtensionsValidatorCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JaasOptionsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenBearerValidatorCallbackHandler
implements AuthenticateCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(TokenBearerValidatorCallbackHandler.class);
    private static final String AUTH_ERROR_MESSAGE = "Authentication failed";
    private JwtAuthenticator authenticator;
    private boolean configured = false;

    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        JaasOptionsUtils.validateOAuthMechanismAndNonNullJaasConfig((String)saslMechanism, jaasConfigEntries);
        HashMap moduleOptions = new HashMap(jaasConfigEntries.get(0).getOptions());
        if (moduleOptions.containsKey("publicKeyPath")) {
            moduleOptions.put("jwksLocation", (String)moduleOptions.remove("publicKeyPath"));
        }
        JwtAuthenticatorConfig authenticatorConfig = new JwtAuthenticatorConfig(moduleOptions);
        this.authenticator = new JwtAuthenticator(authenticatorConfig);
        this.configured = true;
    }

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        if (!this.configured) {
            throw new IllegalStateException("Callback handler not configured");
        }
        for (Callback callback : callbacks) {
            if (callback instanceof OAuthBearerValidatorCallback) {
                OAuthBearerValidatorCallback validationCallback = (OAuthBearerValidatorCallback)callback;
                try {
                    this.handleValidatorCallback(validationCallback);
                }
                catch (JwtVerificationException e) {
                    log.debug("Failed to verify token. ", (Throwable)e);
                    validationCallback.error(AUTH_ERROR_MESSAGE, null, null);
                }
                continue;
            }
            if (callback instanceof OAuthBearerExtensionsValidatorCallback) {
                this.handleExtensionsCallback((OAuthBearerExtensionsValidatorCallback)callback);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    public void close() {
        try {
            this.authenticator.close();
        }
        catch (IOException e) {
            log.error("Failed to close JwtAuthenticator", (Throwable)e);
        }
    }

    private void handleExtensionsCallback(OAuthBearerExtensionsValidatorCallback callback) {
    }

    private void handleValidatorCallback(OAuthBearerValidatorCallback callback) throws JwtVerificationException {
        String tokenValue = callback.tokenValue();
        if (tokenValue == null) {
            throw new IllegalArgumentException("Callback missing required token value");
        }
        OAuthBearerToken token = this.processToken(tokenValue);
        callback.token(token);
        log.debug("Successfully validated token from principal {}", (Object)token.principalName());
    }

    OAuthBearerToken processToken(String jws) throws JwtVerificationException {
        return this.authenticator.login(jws, "clusters");
    }
}

