/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.link.integration;

import java.util.Collections;
import java.util.Properties;
import kafka.link.ClusterLinkDurabilityAuditIntegrationTest;
import kafka.server.link.ClusterLinkConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.collection.JavaConverters;
import scala.collection.Map;

@Tags(value={@Tag(value="integration"), @Tag(value="bazel:shard_count:3"), @Tag(value="bazel:size:large")})
public class ClusterLinkPrefixDurabilityAuditIntegrationTest
extends ClusterLinkDurabilityAuditIntegrationTest {
    public void setUpClusters(int sourceReplicationFactor) {
        this.clusterLinkPrefix_$eq("link1_");
        this.sourceCluster().createTopic(this.topic(), this.numPartitions(), sourceReplicationFactor, new Properties(), this.sourceCluster().listenerName(), this.sourceCluster().adminClientConfig());
        Properties linkProps = this.destLinkProps((Map)this.convertMapToScalaMap(Collections.emptyMap()));
        linkProps.setProperty(ClusterLinkConfig.ClusterLinkPrefixProp(), this.clusterLinkPrefix());
        linkProps.setProperty(ClusterLinkConfig.ConsumerGroupPrefixEnableProp(), "true");
        linkProps.setProperty(ClusterLinkConfig.LinkModeProp(), "DESTINATION");
        Assertions.assertFalse((boolean)this.clusterLinkPrefix().isEmpty());
        this.createClusterLink(this.linkName(), linkProps, this.sourceLinkProps((Map)this.convertMapToScalaMap(Collections.emptyMap())), false, true);
        this.destCluster().linkTopic(this.topic(), (short)1, this.linkName(), this.convertMapToScalaMap(Collections.emptyMap()), this.clusterLinkPrefix());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testClusterLinkDurabilityAuditLogStartOffsetChange(String quorum, boolean coordinator) {
        this.setUpClusters(1);
        this.testDurabilityAuditDestinationLaggingLogStartOffset(quorum);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testClusterLinkDurabilityAuditDestinationLaggingFarBehind(String quorum, boolean coordinator) {
        if (!this.useEskuMode()) {
            this.setUpClusters(1);
            this.testDurabilityAuditDestinationLaggingFarBehind(quorum);
        }
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testClusterLinkDurabilityAuditAllowedMirrorStateTransitions(String quorum, boolean coordinator) {
        this.setUpClusters(1);
        this.testDurabilityAllowedMirrorStateTransitions(quorum);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testClusterLinkDurabilityAuditProduceToStoppedMirrorTopic(String quorum, boolean coordinator) throws InterruptedException {
        this.setUpClusters(1);
        this.testDurabilityAuditProduceToStoppedMirrorTopic(quorum);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testClusterLinkDurabilityAuditRetentionConfigChange(String quorum, boolean coordinator) throws InterruptedException {
        this.setUpClusters(1);
        this.testDurabilityAuditRetentionConfigChange(quorum);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testClusterLinkDurabilityAuditStartOffsetChangeOnStoppedMirrorTopic(String quorum, boolean coordinator) throws InterruptedException {
        this.setUpClusters(1);
        this.testDurabilityAuditStartOffsetChangeOnStoppedMirrorTopic(quorum);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testClusterLinkDurabilityAuditStoppedMirrorPartitionLapseType(String quorum, boolean coordinator) throws InterruptedException {
        this.setUpClusters(1);
        this.testDurabilityAuditStoppedMirrorPartitionLapseType(quorum);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testClusterLinkDurabilityAuditDestLogEpochChange(String quorum, boolean coordinator) throws InterruptedException {
        this.setUpClusters(2);
        this.testDurabilityAuditDestLogEpochChange(quorum);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.coordinator={1}")
    @MethodSource(value={"allCombinations"})
    public void testClusterLinkDurabilityAuditMirrorWithDifferentRetention(String quorum, boolean coordinator) throws InterruptedException {
        this.setUpClusters(1);
        this.testDurabilityAuditMirrorWithDifferentRetention(quorum);
    }

    protected <K, V> scala.collection.mutable.Map<K, V> convertMapToScalaMap(java.util.Map<K, V> map) {
        return (scala.collection.mutable.Map)JavaConverters.mapAsScalaMapConverter(map).asScala();
    }
}

