/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.quota;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.TestCluster;
import io.confluent.kafka.multitenant.quota.MultiTenantQuotaConfig;
import io.confluent.kafka.multitenant.quota.TenantQuotaCallback;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import kafka.server.ActiveTenantsManager;
import kafka.server.ClientQuotaManager;
import kafka.server.KafkaConfig;
import kafka.server.QuotaFactory;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.network.Session;
import org.apache.kafka.server.config.BrokerBackpressureConfig;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import org.apache.kafka.server.quota.ClientQuotaClusterDescriber;
import org.apache.kafka.server.quota.ZkClientQuotaClusterDescriber;
import org.apache.kafka.server.util.MockTime;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Option;

public class TenantUserClientQuotaManagerTest {
    private static final Long MIN_BROKER_CONSUME_QUOTA = 600L;
    private static final Long MIN_BROKER_PRODUCE_QUOTA = 500L;
    private static final Long MAX_BROKER_CONSUME_QUOTA = 2400L;
    private static final Long MAX_BROKER_PRODUCE_QUOTA = 2000L;
    private static final Double DEFAULT_CONTROLLER_QUOTA = 20.0;
    private final Time time = new MockTime();
    private Metrics metrics;
    private QuotaFactory.QuotaManagers quotaManagers;
    private final Long brokerProduceLimit = 1800L;
    private final String tenant1 = "tenant1";
    private final Long tenantProduceByteRate = 800L;
    private final Long tenantConsumeByteRate = 1000L;
    private final MultiTenantPrincipal tenant1User1Principal = this.createMultiTenantPrincipal("tenant1", "sa-abc123");
    private final Long user1ProduceByteRate = 500L;
    private final Long user1ConsumeByteRate = 600L;
    private final MultiTenantPrincipal tenant1User2Principal = this.createMultiTenantPrincipal("tenant1", "sa-123abc");
    private final MultiTenantPrincipal tenant1User3Principal = this.createMultiTenantPrincipal("tenant1", "sa-234abc");
    private final MultiTenantPrincipal tenant1User4Principal = this.createMultiTenantPrincipal("tenant1", "sa-345abc");
    private final String tenant2 = "tenant2";
    private final Long tenant2ProduceByteRate = 1600L;
    private final Long tenant2ConsumeByteRate = this.tenantConsumeByteRate;
    private final MultiTenantPrincipal tenant2User1Principal = this.createMultiTenantPrincipal("tenant2", "sa-567def");

    @BeforeEach
    public void setup() {
        this.metrics = new Metrics(this.time);
        this.quotaManagers = this.createQuotaManagers(new Properties());
        this.createTenantQuotas();
        this.setupCallbackClusterMetadata((ClientQuotaCallback)this.quotaManagers.clientQuotaCallback().get());
    }

    @AfterEach
    public void tearDown() {
        this.quotaManagers.shutdown();
        TenantQuotaCallback.closeAll();
        this.metrics.close();
    }

    @Test
    public void testTenantAndUserQuotasEnforced() {
        ClientQuotaManager produce = this.quotaManagers.produce();
        Assertions.assertEquals((int)0, (int)this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User1Principal, this.user1ProduceByteRate.doubleValue()));
        Assertions.assertEquals((int)0, (int)this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User2Principal, 100.0));
        int tenantUser1Throttle = this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User1Principal, 100.0);
        Assertions.assertEquals((int)200, (int)tenantUser1Throttle);
        Assertions.assertEquals((int)0, (int)this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User2Principal, 100.0));
        Assertions.assertEquals((int)125, (int)this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User2Principal, 100.0));
    }

    @Test
    public void testMaxThrottleReturnedForUser() {
        ClientQuotaManager produce = this.quotaManagers.produce();
        Assertions.assertEquals((int)600, (int)this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User1Principal, this.tenantProduceByteRate.doubleValue()));
        Assertions.assertEquals((long)800L, (long)this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User1Principal, 100.0));
        this.time.sleep(2000L);
        Assertions.assertEquals((int)600, (int)this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User1Principal, this.tenantProduceByteRate.doubleValue()));
        this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User2Principal, this.tenantProduceByteRate.doubleValue() - 100.0);
        Assertions.assertEquals((long)1000L, (long)this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User1Principal, 100.0));
    }

    @Test
    public void testMaxValueInQuotaWindowUsesMinQuotaInHierarchy() {
        this.recreateQuotaManagersWithSampleOverride(2);
        ClientQuotaManager fetch = this.quotaManagers.fetch();
        Assertions.assertEquals((double)600.0, (double)fetch.getMaxValueInQuotaWindow(this.createSession((KafkaPrincipal)this.tenant1User1Principal), ""));
        Assertions.assertEquals((double)1000.0, (double)fetch.getMaxValueInQuotaWindow(this.createSession((KafkaPrincipal)this.tenant1User2Principal), ""));
    }

    @Test
    public void testChildSensorExpiration() {
        ClientQuotaManager produce = this.quotaManagers.produce();
        Assertions.assertEquals((int)0, (int)this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User1Principal, 100.0));
        Assertions.assertEquals((int)0, (int)this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User2Principal, 700.0));
        this.metrics.removeSensor(String.format("PRODUCE-%s:%s", "tenant1", this.tenant1User1Principal.tenantMetadata().userResourceId));
        int tenantUser2Throttle = this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User2Principal, 200.0);
        Assertions.assertEquals((int)250, (int)tenantUser2Throttle);
    }

    @Test
    public void testQuotaUpdate() {
        ClientQuotaManager produce = this.quotaManagers.produce();
        Assertions.assertEquals((double)500.0, (double)produce.quota((KafkaPrincipal)this.tenant1User1Principal, "").bound());
        Assertions.assertEquals((int)0, (int)this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User1Principal, 400.0));
        Assertions.assertEquals((int)0, (int)this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User2Principal, 100.0));
        HashMap<String, MultiTenantQuotaConfig> updatedUserQuotas = new HashMap<String, MultiTenantQuotaConfig>();
        MultiTenantQuotaConfig updatedUser2Quota = this.quotaConfig(200L, 600L, 250.0, 150.0);
        updatedUserQuotas.put(this.tenant1User2Principal.tenantMetadata().userResourceId, updatedUser2Quota);
        TenantQuotaCallback.updateUserQuotas((String)"tenant1", updatedUserQuotas, (MultiTenantQuotaConfig)MultiTenantQuotaConfig.UNLIMITED_QUOTA);
        Assertions.assertEquals((double)500.0, (double)produce.quota((KafkaPrincipal)this.tenant1User1Principal, "").bound());
        Assertions.assertEquals((double)200.0, (double)produce.quota((KafkaPrincipal)this.tenant1User2Principal, "").bound());
        this.time.sleep(2000L);
        Assertions.assertEquals((int)250, (int)this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User2Principal, 250.0));
        Assertions.assertEquals((int)0, (int)this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User1Principal, 500.0));
        Assertions.assertEquals((int)200, (int)this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User1Principal, 100.0));
    }

    @Test
    public void testUnrecordUpdatesParentSensor() {
        ClientQuotaManager fetch = this.quotaManagers.fetch();
        Assertions.assertEquals((int)0, (int)this.maybeRecord(fetch, (KafkaPrincipal)this.tenant1User1Principal, 200.0));
        Assertions.assertEquals((int)0, (int)this.maybeRecord(fetch, (KafkaPrincipal)this.tenant1User2Principal, 800.0));
        Assertions.assertEquals((int)100, (int)this.maybeRecord(fetch, (KafkaPrincipal)this.tenant1User1Principal, 100.0));
        fetch.unrecordQuotaSensor(this.createSession((KafkaPrincipal)this.tenant1User2Principal), "", 800.0, this.time.milliseconds());
        Assertions.assertEquals((int)0, (int)this.maybeRecord(fetch, (KafkaPrincipal)this.tenant1User1Principal, 300.0));
        Assertions.assertEquals((int)250, (int)this.maybeRecord(fetch, (KafkaPrincipal)this.tenant1User1Principal, 150.0));
    }

    @Test
    public void testAutoTuneUserPrincipalsWithEqualQuota() {
        this.recreateQuotaManagersWithSampleOverride(2);
        HashMap<String, MultiTenantQuotaConfig> updatedUserQuotas = new HashMap<String, MultiTenantQuotaConfig>();
        MultiTenantQuotaConfig user1Quota = this.quotaConfig(500L, 600L, 250.0, 150.0);
        MultiTenantQuotaConfig user2Quota = this.quotaConfig(500L, 600L, 250.0, 150.0);
        updatedUserQuotas.put(this.tenant1User1Principal.tenantMetadata().userResourceId, user1Quota);
        updatedUserQuotas.put(this.tenant1User2Principal.tenantMetadata().userResourceId, user2Quota);
        TenantQuotaCallback.updateUserQuotas((String)"tenant1", updatedUserQuotas, (MultiTenantQuotaConfig)MultiTenantQuotaConfig.UNLIMITED_QUOTA);
        ClientQuotaManager produce = this.quotaManagers.produce();
        this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User1Principal, 450.0);
        this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User2Principal, 450.0);
        produce.maybeAutoTuneQuota();
        HashMap<MultiTenantPrincipal, Double> expectedQuotasAfterTuning = new HashMap<MultiTenantPrincipal, Double>();
        expectedQuotasAfterTuning.put(this.tenant1User1Principal, 400.0);
        expectedQuotasAfterTuning.put(this.tenant1User2Principal, 400.0);
        this.verifyDynamicQuotas(produce, expectedQuotasAfterTuning);
    }

    @Test
    public void testAutoTuneUserPrincipalsWithDefaultQuota() {
        this.recreateQuotaManagersWithSampleOverride(2);
        HashMap<String, MultiTenantQuotaConfig> updatedUserQuotas = new HashMap<String, MultiTenantQuotaConfig>();
        MultiTenantQuotaConfig user1Quota = this.quotaConfig(600L, 600L, 250.0, 150.0);
        MultiTenantQuotaConfig defaultQuota = this.quotaConfig(300L, 600L, 250.0, 150.0);
        updatedUserQuotas.put(this.tenant1User1Principal.tenantMetadata().userResourceId, user1Quota);
        TenantQuotaCallback.updateUserQuotas((String)"tenant1", updatedUserQuotas, (MultiTenantQuotaConfig)defaultQuota);
        ClientQuotaManager produce = this.quotaManagers.produce();
        this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User1Principal, 450.0);
        this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User2Principal, 450.0);
        produce.maybeAutoTuneQuota();
        HashMap<MultiTenantPrincipal, Double> expectedQuotasAfterTuning = new HashMap<MultiTenantPrincipal, Double>();
        expectedQuotasAfterTuning.put(this.tenant1User1Principal, 533.3);
        expectedQuotasAfterTuning.put(this.tenant1User2Principal, 300.0);
        this.verifyDynamicQuotas(produce, expectedQuotasAfterTuning);
    }

    @Test
    public void testAutoTuneUserPrincipalsWithUnlimitedQuota() {
        this.recreateQuotaManagersWithSampleOverride(2);
        HashMap<String, MultiTenantQuotaConfig> updatedUserQuotas = new HashMap<String, MultiTenantQuotaConfig>();
        MultiTenantQuotaConfig user1Quota = this.quotaConfig(500L, 600L, 250.0, 150.0);
        updatedUserQuotas.put(this.tenant1User1Principal.tenantMetadata().userResourceId, user1Quota);
        TenantQuotaCallback.updateUserQuotas((String)"tenant1", updatedUserQuotas, (MultiTenantQuotaConfig)MultiTenantQuotaConfig.UNLIMITED_QUOTA);
        ClientQuotaManager produce = this.quotaManagers.produce();
        this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User1Principal, 450.0);
        this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User2Principal, 1000.0);
        produce.maybeAutoTuneQuota();
        HashMap<MultiTenantPrincipal, Double> expectedQuotasAfterTuning = new HashMap<MultiTenantPrincipal, Double>();
        expectedQuotasAfterTuning.put(this.tenant1User1Principal, 0.0);
        expectedQuotasAfterTuning.put(this.tenant1User2Principal, Double.valueOf(this.tenantProduceByteRate.longValue()));
        this.verifyDynamicQuotas(produce, expectedQuotasAfterTuning);
        this.time.sleep(2000L);
        this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User1Principal, 450.0);
        this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User2Principal, 450.0);
        produce.maybeAutoTuneQuota();
        expectedQuotasAfterTuning.put(this.tenant1User1Principal, 350.0);
        expectedQuotasAfterTuning.put(this.tenant1User2Principal, 800.0);
        this.verifyDynamicQuotas(produce, expectedQuotasAfterTuning);
    }

    @Test
    public void testAutoTuneUserPrincipalsWithMultipleUnlimitedQuota() {
        this.recreateQuotaManagersWithSampleOverride(2);
        HashMap<String, MultiTenantQuotaConfig> updatedUserQuotas = new HashMap<String, MultiTenantQuotaConfig>();
        MultiTenantQuotaConfig user1Quota = this.quotaConfig(500L, 600L, 250.0, 150.0);
        updatedUserQuotas.put(this.tenant1User1Principal.tenantMetadata().userResourceId, user1Quota);
        TenantQuotaCallback.updateUserQuotas((String)"tenant1", updatedUserQuotas, (MultiTenantQuotaConfig)MultiTenantQuotaConfig.UNLIMITED_QUOTA);
        ClientQuotaManager produce = this.quotaManagers.produce();
        this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User1Principal, 450.0);
        this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User2Principal, 600.0);
        this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User3Principal, 100.0);
        this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User4Principal, 0.0);
        produce.maybeAutoTuneQuota();
        HashMap<MultiTenantPrincipal, Double> expectedQuotasAfterTuning = new HashMap<MultiTenantPrincipal, Double>();
        expectedQuotasAfterTuning.put(this.tenant1User1Principal, 100.0);
        expectedQuotasAfterTuning.put(this.tenant1User2Principal, 700.0);
        expectedQuotasAfterTuning.put(this.tenant1User3Principal, 400.0);
        expectedQuotasAfterTuning.put(this.tenant1User4Principal, 266.6666666666667);
        this.verifyDynamicQuotas(produce, expectedQuotasAfterTuning);
    }

    @Test
    public void testAutoTuneUserPrincipalsWithUnequalQuota() {
        this.recreateQuotaManagersWithSampleOverride(2);
        HashMap<String, MultiTenantQuotaConfig> updatedUserQuotas = new HashMap<String, MultiTenantQuotaConfig>();
        MultiTenantQuotaConfig user1Quota = this.quotaConfig(800L, 600L, 250.0, 150.0);
        MultiTenantQuotaConfig user2Quota = this.quotaConfig(400L, 600L, 250.0, 150.0);
        updatedUserQuotas.put(this.tenant1User1Principal.tenantMetadata().userResourceId, user1Quota);
        updatedUserQuotas.put(this.tenant1User2Principal.tenantMetadata().userResourceId, user2Quota);
        TenantQuotaCallback.updateUserQuotas((String)"tenant1", updatedUserQuotas, (MultiTenantQuotaConfig)MultiTenantQuotaConfig.UNLIMITED_QUOTA);
        ClientQuotaManager produce = this.quotaManagers.produce();
        this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User1Principal, 450.0);
        this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User2Principal, 450.0);
        produce.maybeAutoTuneQuota();
        HashMap<MultiTenantPrincipal, Double> expectedQuotasAfterTuning = new HashMap<MultiTenantPrincipal, Double>();
        expectedQuotasAfterTuning.put(this.tenant1User1Principal, 533.3);
        expectedQuotasAfterTuning.put(this.tenant1User2Principal, 350.0);
        this.verifyDynamicQuotas(produce, expectedQuotasAfterTuning);
    }

    @Test
    public void testAutoTuneMultipleTenantsAndUserPrincipals() {
        this.recreateQuotaManagersWithSampleOverride(2);
        HashMap<String, MultiTenantQuotaConfig> updatedUserQuotas = new HashMap<String, MultiTenantQuotaConfig>();
        MultiTenantQuotaConfig user1Quota = this.quotaConfig(800L, 600L, 250.0, 150.0);
        MultiTenantQuotaConfig user2Quota = this.quotaConfig(400L, 600L, 250.0, 150.0);
        updatedUserQuotas.put(this.tenant1User1Principal.tenantMetadata().userResourceId, user1Quota);
        updatedUserQuotas.put(this.tenant1User2Principal.tenantMetadata().userResourceId, user2Quota);
        TenantQuotaCallback.updateUserQuotas((String)"tenant1", updatedUserQuotas, (MultiTenantQuotaConfig)MultiTenantQuotaConfig.UNLIMITED_QUOTA);
        ClientQuotaManager produce = this.quotaManagers.produce();
        this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User1Principal, 500.0);
        this.maybeRecord(produce, (KafkaPrincipal)this.tenant1User2Principal, 500.0);
        this.maybeRecord(produce, (KafkaPrincipal)this.tenant2User1Principal, 1400.0);
        produce.maybeAutoTuneQuota();
        HashMap<MultiTenantPrincipal, Double> expectedQuotasAfterTuning = new HashMap<MultiTenantPrincipal, Double>();
        expectedQuotasAfterTuning.put(this.tenant1User1Principal, 400.0);
        expectedQuotasAfterTuning.put(this.tenant1User2Principal, 200.0);
        expectedQuotasAfterTuning.put(this.tenant2User1Principal, 9.223372036854776E18);
        this.verifyDynamicQuotas(produce, expectedQuotasAfterTuning);
    }

    @Test
    public void testCreateParentChildSensor() {
        ClientQuotaManager fetch = this.quotaManagers.fetch();
        Assertions.assertEquals((int)0, (int)this.maybeRecord(fetch, (KafkaPrincipal)this.tenant1User1Principal, 200.0));
        Assertions.assertEquals((int)0, (int)this.maybeRecord(fetch, (KafkaPrincipal)this.tenant1User2Principal, 800.0));
        Assertions.assertEquals((int)100, (int)this.maybeRecord(fetch, (KafkaPrincipal)this.tenant1User1Principal, 100.0));
        Sensor parentQuotaSensor = this.metrics.getSensor("Fetch-tenant1:sa-abc123");
        Sensor childQuotaSensor = this.metrics.getSensor("Fetch-tenant1");
        Sensor parentThrottleSensor = this.metrics.getSensor("FetchThrottleTime-tenant1:sa-abc123");
        Sensor childThrottleSensor = this.metrics.getSensor("FetchThrottleTime-tenant1");
        Assertions.assertNotNull((Object)parentQuotaSensor);
        Assertions.assertNotNull((Object)childQuotaSensor);
        Assertions.assertNotNull((Object)parentThrottleSensor);
        Assertions.assertNotNull((Object)childThrottleSensor);
    }

    private QuotaFactory.QuotaManagers createQuotaManagers(Properties overrideProps) {
        Properties props = new Properties();
        props.setProperty("process.roles", "broker");
        props.setProperty("broker.id", "1");
        props.setProperty("controller.quorum.bootstrap.servers", "localhost:9095");
        props.setProperty("controller.listener.names", "CONTROLLER");
        props.put("listeners", "PLAINTEXT://localhost:9092");
        props.put("quota.window.num", String.valueOf(1));
        props.put("throughput.quota.window.num", String.valueOf(1));
        props.put("confluent.broker.limit.producer.bytes.per.second", String.valueOf(this.brokerProduceLimit));
        props.putAll(this.quotaCallbackProps());
        props.putAll((Map<?, ?>)overrideProps);
        KafkaConfig config = KafkaConfig.fromProps((Properties)props);
        ActiveTenantsManager activeTenantsManager = new ActiveTenantsManager(this.metrics, this.time, BrokerBackpressureConfig.DEFAULT_ACTIVE_WINDOW_MS);
        return QuotaFactory.instantiate((KafkaConfig)config, (Metrics)this.metrics, (Time)this.time, (String)"", (Option)Option.empty(), (Option)Option.empty());
    }

    private void recreateQuotaManagersWithSampleOverride(int numQuotaSamples) {
        this.quotaManagers.shutdown();
        TenantQuotaCallback.closeAll();
        Properties quotaSampleProps = new Properties();
        quotaSampleProps.put("quota.window.num", String.valueOf(numQuotaSamples));
        quotaSampleProps.put("throughput.quota.window.num", String.valueOf(numQuotaSamples));
        this.quotaManagers = this.createQuotaManagers(quotaSampleProps);
        this.createTenantQuotas();
        this.setupCallbackClusterMetadata((ClientQuotaCallback)this.quotaManagers.clientQuotaCallback().get());
    }

    private void createTenantQuotas() {
        HashMap<String, MultiTenantQuotaConfig> tenantQuotas = new HashMap<String, MultiTenantQuotaConfig>();
        tenantQuotas.put("tenant1", this.quotaConfig(this.tenantProduceByteRate, this.tenantConsumeByteRate, 300.0, 200.0));
        tenantQuotas.put("tenant2", this.quotaConfig(this.tenant2ProduceByteRate, this.tenant2ConsumeByteRate, 400.0, 300.0));
        TenantQuotaCallback.updateQuotas(tenantQuotas, (MultiTenantQuotaConfig)MultiTenantQuotaConfig.UNLIMITED_QUOTA);
        HashMap<String, MultiTenantQuotaConfig> userQuotas = new HashMap<String, MultiTenantQuotaConfig>();
        userQuotas.put(this.tenant1User1Principal.tenantMetadata().userResourceId, this.quotaConfig(this.user1ProduceByteRate, this.user1ConsumeByteRate, 250.0, 150.0));
        TenantQuotaCallback.updateUserQuotas((String)"tenant1", userQuotas, (MultiTenantQuotaConfig)MultiTenantQuotaConfig.UNLIMITED_QUOTA);
    }

    private Map<String, Object> quotaCallbackProps() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("client.quota.callback.class", TenantQuotaCallback.class.getName());
        configs.put("broker.id", String.valueOf(0));
        configs.put("confluent.quota.tenant.user.quotas.enable", String.valueOf(true));
        configs.put("confluent.quota.tenant.follower.broker.min.producer.rate", MIN_BROKER_PRODUCE_QUOTA.toString());
        configs.put("confluent.quota.tenant.broker.max.producer.rate", MAX_BROKER_PRODUCE_QUOTA.toString());
        configs.put("confluent.quota.tenant.follower.broker.min.consumer.rate", MIN_BROKER_CONSUME_QUOTA.toString());
        configs.put("confluent.quota.tenant.broker.max.consumer.rate", MAX_BROKER_CONSUME_QUOTA.toString());
        configs.put("confluent.quota.tenant.default.controller.mutation.rate", DEFAULT_CONTROLLER_QUOTA.toString());
        return configs;
    }

    private void setupCallbackClusterMetadata(ClientQuotaCallback quotaCallback) {
        TestCluster testCluster = new TestCluster();
        testCluster.addNode(0, "rack0");
        testCluster.setPartitionLeaders("tenant1_topic1", 0, 1, 0);
        testCluster.setPartitionLeaders("tenant2_topic1", 0, 1, 0);
        Cluster cluster = testCluster.cluster();
        quotaCallback.updateClusterMetadata((ClientQuotaClusterDescriber)new ZkClientQuotaClusterDescriber(cluster));
    }

    private void verifyDynamicQuotas(ClientQuotaManager quotaManager, Map<MultiTenantPrincipal, Double> expectedQuotas) {
        expectedQuotas.forEach((principal, expectedQuota) -> Assertions.assertEquals((double)expectedQuota, (double)quotaManager.dynamicQuota((KafkaPrincipal)principal, "").bound(), (double)0.1));
    }

    private int maybeRecord(ClientQuotaManager quotaManager, KafkaPrincipal principal, Double value) {
        return quotaManager.maybeRecordAndGetThrottleTimeMs(this.createSession(principal), "", value.doubleValue(), this.time.milliseconds());
    }

    private MultiTenantQuotaConfig quotaConfig(long producerByteRate, long consumerByteRate, double requestPercentage, double linkRequestPercentage) {
        return new MultiTenantQuotaConfig(Long.valueOf(producerByteRate), Long.valueOf(consumerByteRate), Double.valueOf(requestPercentage), null, null, Double.valueOf(linkRequestPercentage), MultiTenantQuotaConfig.UNLIMITED_QUOTA);
    }

    private Session createSession(KafkaPrincipal principal) {
        return new Session(principal, null);
    }

    private MultiTenantPrincipal createMultiTenantPrincipal(String tenant, String serviceAccount) {
        return new MultiTenantPrincipal("unused", new TenantMetadata.Builder(tenant, serviceAccount).build());
    }
}

