/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.server.plugins.auth.FileBasedLoginModule;
import io.confluent.kafka.server.plugins.auth.FileBasedPlainSaslAuthenticator;
import io.confluent.kafka.server.plugins.auth.stats.AuthenticationStats;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import kafka.test.JarResourceLoader;
import org.junit.jupiter.api.BeforeEach;

abstract class AbstractFileBasedPlainSaslAuthenticatorTest {
    protected static final String USERNAME_1 = "bkey";
    protected static final String BCRYPT_PASSWORD = "MKRWvhKV5Xd8VQ05JYre6f+aAq0UBXutZjsHWnQd/GYNR6DfqFeay+VNnReeTRpe";
    private Map<String, Object> options;
    protected List<AppConfigurationEntry> jaasEntries;
    protected FileBasedPlainSaslAuthenticator saslAuth;

    AbstractFileBasedPlainSaslAuthenticatorTest() {
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.options = new HashMap<String, Object>();
        String apiKeyFile = JarResourceLoader.loadFileFromResource(AbstractFileBasedPlainSaslAuthenticatorTest.class, (String)"/apikeys.json").toURI().toURL().getFile();
        this.options.put("config_path", apiKeyFile);
        this.options.put("refresh_ms", "1000");
        this.setAuthenticatorValidationMode("optional_validation");
        AuthenticationStats.getInstance().reset();
    }

    protected void setAuthenticatorValidationMode(String sniValidationMode) {
        this.options.put("sni_host_name_validation_mode", sniValidationMode);
        AppConfigurationEntry entry = new AppConfigurationEntry(FileBasedLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, this.options);
        this.jaasEntries = Collections.singletonList(entry);
        this.saslAuth = this.createAuthenticator();
        this.saslAuth.initialize(this.jaasEntries);
    }

    protected abstract FileBasedPlainSaslAuthenticator createAuthenticator();
}

