/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.server.plugins.auth.UserDeletionEventHandler;
import io.confluent.kafka.test.utils.KafkaTestUtils;
import java.util.HashMap;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.UUID;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.util.KafkaBasedLog;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class UserDeletionEventHandlerTest {
    static final String KEY1 = String.join((CharSequence)"\n", "{", "  \"UserResourceId\": \"r1\",", "  \"OrgResourceId\": \"org1\"", "}");
    static final String VALUE1 = String.join((CharSequence)"\n", "{", "  \"UserId\": \"u1\",", "  \"ActiveLkcIds\": [\"lkc1\", \"lkc2\"]", "}");
    static final String KEY2 = String.join((CharSequence)"\n", "{", "  \"UserResourceId\": \"r2\",", "  \"OrgResourceId\": \"org2\"", "}");
    static final String VALUE2 = String.join((CharSequence)"\n", "{", "  \"UserId\": \"u2\",", "  \"ActiveLkcIds\": [\"lkc3\", \"lkc4\"]", "}");
    private UserDeletionEventHandler handler;
    private static final String TOPIC = "user-metadata";
    private String brokerId;
    private Authorizer authorizer;
    private KafkaBasedLog<String, String> log;
    private Metrics metrics;

    @BeforeEach
    void setUp() throws Exception {
        MockTime time = new MockTime();
        Properties props = new Properties();
        this.brokerId = UUID.randomUUID().toString();
        this.log = (KafkaBasedLog)Mockito.mock(KafkaBasedLog.class);
        this.authorizer = (Authorizer)Mockito.mock(StandardAuthorizer.class);
        this.metrics = new Metrics();
        this.handler = new UserDeletionEventHandler(new HashMap(), Optional.of(this.authorizer), this.metrics, 0, (Time)time);
        this.handler.configure(this.log, this.brokerId);
        this.handler.start(Boolean.valueOf(true)).get();
    }

    @AfterEach
    void tearDown() {
        this.handler.close();
        KafkaTestUtils.verifyThreadCleanup();
    }

    @Test
    void testLeaderChangeCurrent() {
        Assertions.assertEquals(this.handler.state.get(), (Object)UserDeletionEventHandler.State.RUNNING);
        this.handler.onControllerChange(new LeaderAndEpoch(OptionalInt.of(0), 0));
        Assertions.assertEquals(this.handler.state.get(), (Object)UserDeletionEventHandler.State.RUNNING);
    }

    @Test
    void testLeaderChangeOther() throws Exception {
        Assertions.assertEquals(this.handler.state.get(), (Object)UserDeletionEventHandler.State.RUNNING);
        this.handler.onControllerChange(new LeaderAndEpoch(OptionalInt.of(1), 0));
        Assertions.assertEquals(this.handler.state.get(), (Object)UserDeletionEventHandler.State.NOT_STARTED);
        this.handler.onControllerChange(new LeaderAndEpoch(OptionalInt.of(0), 1));
        TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertEquals(this.handler.state.get(), (Object)UserDeletionEventHandler.State.RUNNING));
    }

    @Test
    void testSoftDelete() {
        this.handler.read(this.createConsumerRecord(1L, KEY1, VALUE1));
        this.handler.read(this.createConsumerRecord(1L, KEY2, VALUE2));
        Assertions.assertEquals((int)this.handler.userMetaDataKeyUserMetaDataValueMap.size(), (int)2);
        this.handler.read(this.createConsumerRecord(3L, KEY1, null));
        this.handler.read(this.createConsumerRecord(2L, KEY2, null));
        Assertions.assertEquals((int)this.handler.userMetaDataKeyUserMetaDataValueMap.size(), (int)0);
    }

    @Test
    void testDuplicateCreation() {
        Assertions.assertEquals((int)this.handler.userMetaDataKeyUserMetaDataValueMap.size(), (int)0);
        this.handler.read(this.createConsumerRecord(1L, KEY1, VALUE1));
        this.handler.read(this.createConsumerRecord(2L, KEY1, VALUE1));
        this.handler.read(this.createConsumerRecord(3L, KEY1, VALUE1));
        Assertions.assertEquals((int)this.handler.userMetaDataKeyUserMetaDataValueMap.size(), (int)1);
        this.handler.read(this.createConsumerRecord(4L, KEY1, null));
        this.handler.read(this.createConsumerRecord(5L, KEY1, null));
        Assertions.assertEquals((int)this.handler.userMetaDataKeyUserMetaDataValueMap.size(), (int)0);
        this.handler.read(this.createConsumerRecord(1L, KEY2, null));
        Assertions.assertEquals((int)this.handler.userMetaDataKeyUserMetaDataValueMap.size(), (int)0);
    }

    @Test
    void testFailureMetric() {
        this.handler.read(this.createConsumerRecord(1L, KEY1, VALUE1));
        this.handler.read(this.createConsumerRecord(2L, KEY2, VALUE2));
        Assertions.assertEquals((double)0.0, (double)TestUtils.getMetricValue((Metrics)this.metrics, (String)"user-deletion-event-failure-rate"));
        this.handler.read(this.createConsumerRecord(3L, null, null));
        Assertions.assertTrue((TestUtils.getMetricValue((Metrics)this.metrics, (String)"user-deletion-event-failure-rate") > 0.0 ? 1 : 0) != 0);
        this.handler.onControllerChange(new LeaderAndEpoch(OptionalInt.of(1), 0));
        this.handler.onControllerChange(new LeaderAndEpoch(OptionalInt.of(0), 0));
        Assertions.assertEquals((double)0.0, (double)TestUtils.getMetricValue((Metrics)this.metrics, (String)"user-deletion-event-failure-rate"));
    }

    private ConsumerRecord<String, String> createConsumerRecord(long seqId, String key, String value) {
        RecordHeaders headers = KafkaTestUtils.createGoodSequenceIdRecordHeaders(seqId);
        return new ConsumerRecord(TOPIC, 0, 0L, -1L, TimestampType.NO_TIMESTAMP_TYPE, -1, -1, (Object)key, (Object)value, (Headers)headers, Optional.empty());
    }
}

