/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.policy;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.server.plugins.policy.AlterConfigPolicy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kafka.server.link.ClusterLinkConfig;
import org.apache.kafka.common.TopicType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AlterConfigPolicyTest {
    private AlterConfigPolicy policy;
    private final short minIsr = 1;
    private final short replicationFactor = (short)3;

    @BeforeEach
    public void setUp() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("confluent.plugins.topic.policy.replication.factor", Short.toString((short)3));
        config.put("confluent.plugins.topic.policy.max.partitions.per.tenant", "21");
        config.put("confluent.plugins.topic.policy.max.message.bytes.max", "3145728");
        this.policy = new AlterConfigPolicy();
        this.policy.configure(config);
    }

    private AlterConfigPolicy.RequestMetadata requestMetadataWithTopicConfigs(Map<String, String> topicConfigs) {
        ConfigResource cfgResource = new ConfigResource(ConfigResource.Type.TOPIC, "dummy");
        return new AlterConfigPolicy.RequestMetadata(cfgResource, topicConfigs, (KafkaPrincipal)new MultiTenantPrincipal("tenantUserA", new TenantMetadata("cluster1", "cluster1")));
    }

    private AlterConfigPolicy.RequestMetadata requestMetadataWithTopicConfigs() {
        HashMap<String, String> topicConfigs = new HashMap<String, String>();
        topicConfigs.put("min.insync.replicas", Short.toString((short)1));
        topicConfigs.put("max.message.bytes", "4242");
        return this.requestMetadataWithTopicConfigs(topicConfigs);
    }

    @Test
    public void validateParamsSetOk() {
        this.policy.validate(this.requestMetadataWithTopicConfigs());
    }

    @Test
    public void validateNoParamsGivenOk() {
        this.policy.validate(this.requestMetadataWithTopicConfigs(Collections.emptyMap()));
    }

    @Test
    public void rejectDeleteRetentionMsTooHigh() {
        Map<String, String> topicConfigs = Collections.singletonMap("delete.retention.ms", "60566400001");
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(this.requestMetadataWithTopicConfigs(topicConfigs)));
    }

    @Test
    public void rejectSegmentBytesTooLow() {
        Map<String, String> topicConfigs = Collections.singletonMap("segment.bytes", Integer.toString(0x31FFFFF));
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(this.requestMetadataWithTopicConfigs(topicConfigs)));
    }

    @Test
    public void rejectSegmentBytesTooHigh() {
        Map<String, String> topicConfigs = Collections.singletonMap("segment.bytes", "1073741825");
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(this.requestMetadataWithTopicConfigs(topicConfigs)));
    }

    @Test
    public void rejectSegmentMsTooLow() {
        Map<String, String> topicConfigs = Collections.singletonMap("segment.ms", Long.toString(500000L));
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(this.requestMetadataWithTopicConfigs(topicConfigs)));
    }

    @Test
    public void rejectMaxCompactionLagMsTooLow() {
        Map<String, String> topicConfigs = Collections.singletonMap("max.compaction.lag.ms", Long.toString(500000L));
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(this.requestMetadataWithTopicConfigs(topicConfigs)));
    }

    @Test
    public void validateAllAllowedProperties() {
        HashMap<String, String> topicConfigs = new HashMap<String, String>();
        topicConfigs.put("cleanup.policy", "delete");
        topicConfigs.put("max.message.bytes", "100");
        topicConfigs.put("message.timestamp.before.max.ms", "100");
        topicConfigs.put("message.timestamp.after.max.ms", "100");
        topicConfigs.put("message.timestamp.type", "CreateTime");
        topicConfigs.put("min.compaction.lag.ms", "100");
        topicConfigs.put("max.compaction.lag.ms", "604800000");
        topicConfigs.put("retention.bytes", "100");
        topicConfigs.put("retention.ms", "135217728");
        topicConfigs.put("segment.ms", "600000");
        topicConfigs.put("confluent.topic.type", TopicType.VIRTUAL.logConfigValue());
        this.policy.validate(this.requestMetadataWithTopicConfigs(topicConfigs));
    }

    @Test
    public void rejectSchemaValidationProperties() {
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(this.requestMetadataWithTopicConfigs(Collections.singletonMap("confluent.key.schema.validation", "true"))));
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(this.requestMetadataWithTopicConfigs(Collections.singletonMap("confluent.key.subject.name.strategy", "io.confluent.kafka.serializers.subject.TopicNameStrategy"))));
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(this.requestMetadataWithTopicConfigs(Collections.singletonMap("confluent.value.schema.validation", "true"))));
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(this.requestMetadataWithTopicConfigs(Collections.singletonMap("confluent.value.subject.name.strategy", "io.confluent.kafka.serializers.subject.TopicNameStrategy"))));
    }

    @Test
    public void acceptSchemaValidationPropertiesWhenFeatureEnabled() {
        HashMap<String, String> policyConfigs = new HashMap<String, String>();
        policyConfigs.put("confluent.schema.validator.multitenant.enable", "true");
        policyConfigs.put("confluent.plugins.topic.policy.replication.factor", Short.toString((short)3));
        this.policy.configure(policyConfigs);
        HashMap<String, String> topicConfigs = new HashMap<String, String>();
        topicConfigs.put("confluent.key.schema.validation", "true");
        topicConfigs.put("confluent.key.subject.name.strategy", "io.confluent.kafka.serializers.subject.TopicNameStrategy");
        topicConfigs.put("confluent.value.schema.validation", "false");
        topicConfigs.put("confluent.value.subject.name.strategy", "io.confluent.kafka.serializers.subject.TopicNameStrategy");
        this.policy.validate(this.requestMetadataWithTopicConfigs(topicConfigs));
    }

    @Test
    public void rejectsSmallMinIsrs() {
        Map<String, String> topicConfigs = Collections.singletonMap("min.insync.replicas", Integer.toString(0));
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(this.requestMetadataWithTopicConfigs(topicConfigs)));
    }

    @Test
    public void rejectsLargeMinIsrs() {
        Map<String, String> topicConfigs = Collections.singletonMap("min.insync.replicas", Integer.toString(3));
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(this.requestMetadataWithTopicConfigs(topicConfigs)));
    }

    @Test
    public void acceptsValidMinIsr() {
        Map<String, String> topicConfigs = Collections.singletonMap("min.insync.replicas", Integer.toString(1));
        this.policy.validate(this.requestMetadataWithTopicConfigs(topicConfigs));
        Map<String, String> topicConfigs2 = Collections.singletonMap("min.insync.replicas", Integer.toString(2));
        this.policy.validate(this.requestMetadataWithTopicConfigs(topicConfigs2));
    }

    @Test
    public void rejectDisallowedConfigProperty1() {
        HashMap<String, String> topicConfigs = new HashMap<String, String>();
        topicConfigs.put("max.message.bytes", "100");
        topicConfigs.put("segment.ms", "100");
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(this.requestMetadataWithTopicConfigs(topicConfigs)));
    }

    @Test
    public void rejectDisallowedConfigProperty2() {
        Map<String, String> topicConfigs = Collections.singletonMap("confluent.tier.enable", "true");
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(this.requestMetadataWithTopicConfigs(topicConfigs)));
    }

    @Test
    public void allowAllTopicConfigChangesThroughInternalListener() {
        HashMap<String, String> topicConfigs = new HashMap<String, String>();
        topicConfigs.put("max.message.bytes", "100");
        topicConfigs.put("segment.ms", "100");
        topicConfigs.put("confluent.tier.enable", "true");
        ConfigResource cfgResource = new ConfigResource(ConfigResource.Type.TOPIC, "dummy");
        AlterConfigPolicy.RequestMetadata requestMetadata = new AlterConfigPolicy.RequestMetadata(cfgResource, topicConfigs, new KafkaPrincipal("User", "ANONYMOUS"));
        this.policy.validate(requestMetadata);
    }

    @Test
    public void rejectMaxMessageBytesOutOfRange() {
        Map<String, String> topicConfigs = Collections.singletonMap("max.message.bytes", "4123123");
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(this.requestMetadataWithTopicConfigs(topicConfigs)));
    }

    @Test
    public void acceptMaxMessageBytesAtLimit() {
        Map<String, String> topicConfigs = Collections.singletonMap("max.message.bytes", "3145728");
        this.policy.validate(this.requestMetadataWithTopicConfigs(topicConfigs));
    }

    @Test
    public void acceptMaxMessageBytesInRange() {
        Map<String, String> topicConfigs = Collections.singletonMap("max.message.bytes", "10000");
        this.policy.validate(this.requestMetadataWithTopicConfigs(topicConfigs));
    }

    @Test
    public void testClusterLinkRestrictTopicConfigs() {
        String segmentBytesMin = "10000";
        String segmentBytesMax = "1000000";
        String segmentMsMin = "100000";
        String retentionMsMax = "10000000000";
        String deleteRetentionMsMax = "10000000000";
        String maxMessageBytesMax = "1000000";
        String replicationFactor = "3";
        String maxCompactionLagMsMin = "10000000";
        String minInSyncReplicasMin = "1";
        String minInSyncReplicasMax = "2";
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("confluent.plugins.topic.policy.segment.bytes.min", "10000");
        configs.put("confluent.plugins.topic.policy.segment.bytes.max", "1000000");
        configs.put("confluent.plugins.topic.policy.segment.ms.min", "100000");
        configs.put("confluent.plugins.topic.policy.retention.ms.max", "10000000000");
        configs.put("confluent.plugins.topic.policy.delete.retention.ms.max", "10000000000");
        configs.put("confluent.plugins.topic.policy.max.message.bytes.max", "1000000");
        configs.put("confluent.plugins.topic.policy.replication.factor", "3");
        configs.put("confluent.plugins.topic.policy.max.compaction.lag.ms.min", "10000000");
        this.policy.configure(configs);
        configs = new HashMap();
        configs.put("segment.bytes", "100");
        configs.put("segment.ms", "100");
        configs.put("min.insync.replicas", "0");
        configs.put("min.insync.replicas", "0");
        configs.put("preallocate", "true");
        Map result = this.policy.clusterLinkRestrictTopicConfigs(configs);
        Assertions.assertEquals((Object)"10000", result.get("segment.bytes"));
        Assertions.assertEquals((Object)"100000", result.get("segment.ms"));
        Assertions.assertEquals((Object)"1", result.get("min.insync.replicas"));
        Assertions.assertEquals(null, result.get("preallocate"));
        configs = new HashMap();
        configs.put("segment.bytes", "2000000");
        configs.put("max.message.bytes", "2000000");
        configs.put("delete.retention.ms", "20000000000");
        configs.put("retention.ms", "20000000000");
        configs.put("min.insync.replicas", "3");
        configs.put("max.compaction.lag.ms", "123");
        result = this.policy.clusterLinkRestrictTopicConfigs(configs);
        Assertions.assertEquals((Object)"1000000", result.get("segment.bytes"));
        Assertions.assertEquals((Object)"1000000", result.get("max.message.bytes"));
        Assertions.assertEquals((Object)"10000000000", result.get("delete.retention.ms"));
        Assertions.assertEquals((Object)"10000000000", result.get("retention.ms"));
        Assertions.assertEquals((Object)"2", result.get("min.insync.replicas"));
        Assertions.assertEquals((Object)"10000000", result.get("max.compaction.lag.ms"));
    }

    @Test
    public void allowBrokerConfigUpdatesFromInternalUser() {
        AlterConfigPolicy.RequestMetadata brokerRequestMetadata = this.createBrokerRequestMetadata(new KafkaPrincipal("User", "ANONYMOUS"));
        this.policy.validate(brokerRequestMetadata);
    }

    @Test
    public void allowClusterUpdatesForWhitelistedConfigsIfConfigEnabled() {
        this.enableAlterClusterConfigs();
        HashMap<String, String> brokerConfigs = new HashMap<String, String>();
        brokerConfigs.put(AlterConfigPolicy.ClusterPolicyConfig.EXTERNAL_LISTENER_SSL_CIPHER_SUITES_CONFIG, "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
        brokerConfigs.put(AlterConfigPolicy.ClusterPolicyConfig.EXTERNAL_LISTENER_SSL_ENABLED_PROTOCOLS_CONFIG, "TLSv1.2");
        brokerConfigs.put("auto.create.topics.enable", "true");
        brokerConfigs.put("num.partitions", "50");
        brokerConfigs.put(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, "7200000");
        brokerConfigs.put(CleanerConfig.LOG_CLEANER_MAX_COMPACTION_LAG_MS_PROP, "2147483647");
        MultiTenantPrincipal principal = new MultiTenantPrincipal("tenantUserA", new TenantMetadata("cluster1", "cluster1"));
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, "");
        AlterConfigPolicy.RequestMetadata requestMetadata = new AlterConfigPolicy.RequestMetadata(configResource, brokerConfigs, (KafkaPrincipal)principal);
        this.policy.validate(requestMetadata);
    }

    @Test
    public void rejectClusterUpdatesIfAnyConfigIsNotWhitelisted() {
        this.enableAlterClusterConfigs();
        HashMap<String, String> brokerConfigs = new HashMap<String, String>();
        brokerConfigs.put("authorizer.class.name", "SomeAuthorizer");
        brokerConfigs.put("auto.create.topics.enable", "true");
        MultiTenantPrincipal principal = new MultiTenantPrincipal("tenantUserA", new TenantMetadata("cluster1", "cluster1"));
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, "");
        AlterConfigPolicy.RequestMetadata requestMetadata = new AlterConfigPolicy.RequestMetadata(configResource, brokerConfigs, (KafkaPrincipal)principal);
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(requestMetadata));
    }

    @Test
    public void rejectSpecificBrokerConfigUpdatesFromTenant() {
        this.enableAlterClusterConfigs();
        Map<String, String> brokerConfigs = Collections.singletonMap(AlterConfigPolicy.ClusterPolicyConfig.EXTERNAL_LISTENER_SSL_CIPHER_SUITES_CONFIG, "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
        MultiTenantPrincipal principal = new MultiTenantPrincipal("tenantUserA", new TenantMetadata("cluster1", "cluster1"));
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        AlterConfigPolicy.RequestMetadata requestMetadata = new AlterConfigPolicy.RequestMetadata(configResource, brokerConfigs, (KafkaPrincipal)principal);
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(requestMetadata));
    }

    @Test
    public void rejectSslEnabledProtocolsBrokerConfigUpdatesFromTenant() {
        this.enableAlterClusterConfigs();
        Map<String, String> brokerConfigs = Collections.singletonMap(AlterConfigPolicy.ClusterPolicyConfig.EXTERNAL_LISTENER_SSL_ENABLED_PROTOCOLS_CONFIG, "TLSv1.2");
        MultiTenantPrincipal principal = new MultiTenantPrincipal("tenantUserA", new TenantMetadata("cluster1", "cluster1"));
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, "1");
        AlterConfigPolicy.RequestMetadata requestMetadata = new AlterConfigPolicy.RequestMetadata(configResource, brokerConfigs, (KafkaPrincipal)principal);
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(requestMetadata));
    }

    @Test
    public void rejectBrokerConfigUpdatesFromTenantByDefault() {
        AlterConfigPolicy.RequestMetadata brokerRequestMetadata = this.createBrokerRequestMetadata((KafkaPrincipal)new MultiTenantPrincipal("tenantUserA", new TenantMetadata("cluster1", "cluster1")));
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(brokerRequestMetadata));
    }

    @Test
    public void allowClusterUpdatesWithValidSslEnabledProtocols() {
        this.enableAlterClusterConfigs();
        Map<String, String> brokerConfigs = Collections.singletonMap(AlterConfigPolicy.ClusterPolicyConfig.EXTERNAL_LISTENER_SSL_ENABLED_PROTOCOLS_CONFIG, "TLSv1.2, TLSv1.3");
        MultiTenantPrincipal principal = new MultiTenantPrincipal("tenantUserA", new TenantMetadata("cluster1", "cluster1"));
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, "");
        AlterConfigPolicy.RequestMetadata requestMetadata = new AlterConfigPolicy.RequestMetadata(configResource, brokerConfigs, (KafkaPrincipal)principal);
        this.policy.validate(requestMetadata);
    }

    @Test
    public void rejectClusterUpdatesWithInvalidSslEnabledProtocols() {
        this.enableAlterClusterConfigs();
        Map<String, String> brokerConfigs = Collections.singletonMap(AlterConfigPolicy.ClusterPolicyConfig.EXTERNAL_LISTENER_SSL_ENABLED_PROTOCOLS_CONFIG, "TLSv1.2, TLSv1.4");
        MultiTenantPrincipal principal = new MultiTenantPrincipal("tenantUserA", new TenantMetadata("cluster1", "cluster1"));
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, "");
        AlterConfigPolicy.RequestMetadata requestMetadata = new AlterConfigPolicy.RequestMetadata(configResource, brokerConfigs, (KafkaPrincipal)principal);
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(requestMetadata));
    }

    @Test
    public void allowClusterUpdatesWithValidSslCiphers() {
        this.enableAlterClusterConfigs();
        Map<String, String> brokerConfigs = Collections.singletonMap(AlterConfigPolicy.ClusterPolicyConfig.EXTERNAL_LISTENER_SSL_CIPHER_SUITES_CONFIG, "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, tls_ecdhe_rsa_with_chacha20_poly1305_sha256,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256, TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384");
        MultiTenantPrincipal principal = new MultiTenantPrincipal("tenantUserA", new TenantMetadata("cluster1", "cluster1"));
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, "");
        AlterConfigPolicy.RequestMetadata requestMetadata = new AlterConfigPolicy.RequestMetadata(configResource, brokerConfigs, (KafkaPrincipal)principal);
        this.policy.validate(requestMetadata);
    }

    @Test
    public void rejectClusterUpdatesWithInvalidSslCiphers() {
        this.enableAlterClusterConfigs();
        Map<String, String> brokerConfigs = Collections.singletonMap(AlterConfigPolicy.ClusterPolicyConfig.EXTERNAL_LISTENER_SSL_CIPHER_SUITES_CONFIG, "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256");
        MultiTenantPrincipal principal = new MultiTenantPrincipal("tenantUserA", new TenantMetadata("cluster1", "cluster1"));
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, "");
        AlterConfigPolicy.RequestMetadata requestMetadata = new AlterConfigPolicy.RequestMetadata(configResource, brokerConfigs, (KafkaPrincipal)principal);
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(requestMetadata));
    }

    @Test
    public void allowClusterUpdatesWithValidNumPartitionsMin() {
        this.enableAlterClusterConfigs();
        Map<String, String> brokerConfigs = Collections.singletonMap("num.partitions", "1");
        MultiTenantPrincipal principal = new MultiTenantPrincipal("tenantUserA", new TenantMetadata("cluster1", "cluster1"));
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, "");
        AlterConfigPolicy.RequestMetadata requestMetadata = new AlterConfigPolicy.RequestMetadata(configResource, brokerConfigs, (KafkaPrincipal)principal);
        this.policy.validate(requestMetadata);
    }

    @Test
    public void allowClusterUpdatesWithValidNumPartitionsMax() {
        this.enableAlterClusterConfigs();
        Map<String, String> brokerConfigs = Collections.singletonMap("num.partitions", "100");
        MultiTenantPrincipal principal = new MultiTenantPrincipal("tenantUserA", new TenantMetadata("cluster1", "cluster1"));
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, "");
        AlterConfigPolicy.RequestMetadata requestMetadata = new AlterConfigPolicy.RequestMetadata(configResource, brokerConfigs, (KafkaPrincipal)principal);
        this.policy.validate(requestMetadata);
    }

    @Test
    public void rejectClusterUpdatesWithInvalidNumPartitionsMin() {
        this.enableAlterClusterConfigs();
        Map<String, String> brokerConfigs = Collections.singletonMap("num.partitions", "0");
        MultiTenantPrincipal principal = new MultiTenantPrincipal("tenantUserA", new TenantMetadata("cluster1", "cluster1"));
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, "");
        AlterConfigPolicy.RequestMetadata requestMetadata = new AlterConfigPolicy.RequestMetadata(configResource, brokerConfigs, (KafkaPrincipal)principal);
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(requestMetadata));
    }

    @Test
    public void rejectClusterUpdatesWithInvalidNumPartitionsMax() {
        this.enableAlterClusterConfigs();
        Map<String, String> brokerConfigs = Collections.singletonMap("num.partitions", "101");
        MultiTenantPrincipal principal = new MultiTenantPrincipal("tenantUserA", new TenantMetadata("cluster1", "cluster1"));
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, "");
        AlterConfigPolicy.RequestMetadata requestMetadata = new AlterConfigPolicy.RequestMetadata(configResource, brokerConfigs, (KafkaPrincipal)principal);
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(requestMetadata));
    }

    @Test
    public void allowClusterUpdatesWithValidRetentionMsMin() {
        this.enableAlterClusterConfigs();
        Map<String, String> brokerConfigs = Collections.singletonMap(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, "3600000");
        MultiTenantPrincipal principal = new MultiTenantPrincipal("tenantUserA", new TenantMetadata("cluster1", "cluster1"));
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, "");
        AlterConfigPolicy.RequestMetadata requestMetadata = new AlterConfigPolicy.RequestMetadata(configResource, brokerConfigs, (KafkaPrincipal)principal);
        this.policy.validate(requestMetadata);
    }

    @Test
    public void allowClusterUpdatesWithValidRetentionMsMax() {
        this.enableAlterClusterConfigs();
        Map<String, String> brokerConfigs = Collections.singletonMap(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, String.valueOf(Long.MAX_VALUE));
        MultiTenantPrincipal principal = new MultiTenantPrincipal("tenantUserA", new TenantMetadata("cluster1", "cluster1"));
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, "");
        AlterConfigPolicy.RequestMetadata requestMetadata = new AlterConfigPolicy.RequestMetadata(configResource, brokerConfigs, (KafkaPrincipal)principal);
        this.policy.validate(requestMetadata);
    }

    @Test
    public void rejectClusterUpdatesWithInvalidRetentionMsMin() {
        this.enableAlterClusterConfigs();
        Map<String, String> brokerConfigs = Collections.singletonMap(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, "3599999");
        MultiTenantPrincipal principal = new MultiTenantPrincipal("tenantUserA", new TenantMetadata("cluster1", "cluster1"));
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, "");
        AlterConfigPolicy.RequestMetadata requestMetadata = new AlterConfigPolicy.RequestMetadata(configResource, brokerConfigs, (KafkaPrincipal)principal);
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(requestMetadata));
    }

    @Test
    public void allowClusterUpdatesWithInfiniteRetention() {
        this.enableAlterClusterConfigs();
        Map<String, String> brokerConfigs = Collections.singletonMap(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, "-1");
        MultiTenantPrincipal principal = new MultiTenantPrincipal("tenantUserA", new TenantMetadata("cluster1", "cluster1"));
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, "");
        AlterConfigPolicy.RequestMetadata requestMetadata = new AlterConfigPolicy.RequestMetadata(configResource, brokerConfigs, (KafkaPrincipal)principal);
        this.policy.validate(requestMetadata);
    }

    @Test
    public void rejectClusterUpdatesWithInvalidRetentionMsNegative() {
        this.enableAlterClusterConfigs();
        Map<String, String> brokerConfigs = Collections.singletonMap(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, "-2");
        MultiTenantPrincipal principal = new MultiTenantPrincipal("tenantUserA", new TenantMetadata("cluster1", "cluster1"));
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, "");
        AlterConfigPolicy.RequestMetadata requestMetadata = new AlterConfigPolicy.RequestMetadata(configResource, brokerConfigs, (KafkaPrincipal)principal);
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(requestMetadata));
    }

    @Test
    public void allowClusterUpdatesWithValidMaxCompactionLagMsMin() {
        this.enableAlterClusterConfigs();
        Map<String, String> brokerConfigs = Collections.singletonMap(CleanerConfig.LOG_CLEANER_MAX_COMPACTION_LAG_MS_PROP, "604800000");
        MultiTenantPrincipal principal = new MultiTenantPrincipal("tenantUserA", new TenantMetadata("cluster1", "cluster1"));
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, "");
        AlterConfigPolicy.RequestMetadata requestMetadata = new AlterConfigPolicy.RequestMetadata(configResource, brokerConfigs, (KafkaPrincipal)principal);
        this.policy.validate(requestMetadata);
    }

    @Test
    public void rejectClusterUpdatesWithInvalidMaxCompactionLagMsMin() {
        this.enableAlterClusterConfigs();
        Map<String, String> brokerConfigs = Collections.singletonMap(CleanerConfig.LOG_CLEANER_MAX_COMPACTION_LAG_MS_PROP, "604799999");
        MultiTenantPrincipal principal = new MultiTenantPrincipal("tenantUserA", new TenantMetadata("cluster1", "cluster1"));
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, "");
        AlterConfigPolicy.RequestMetadata requestMetadata = new AlterConfigPolicy.RequestMetadata(configResource, brokerConfigs, (KafkaPrincipal)principal);
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(requestMetadata));
    }

    @Test
    public void rejectsBrokerLoggerUpdatesFromTenant() {
        AlterConfigPolicy.RequestMetadata brokerRequestMetadata = this.createBrokerLoggerRequestMetadata((KafkaPrincipal)new MultiTenantPrincipal("tenantUserA", new TenantMetadata("cluster1", "cluster1")));
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(brokerRequestMetadata));
    }

    @Test
    public void allowsBrokerLoggerUpdatesFromInternalUser() {
        AlterConfigPolicy.RequestMetadata brokerRequestMetadata = this.createBrokerLoggerRequestMetadata(new KafkaPrincipal("User", "ANONYMOUS"));
        this.policy.validate(brokerRequestMetadata);
    }

    private void enableAlterClusterConfigs() {
        HashMap<String, String> policyConfigs = new HashMap<String, String>();
        policyConfigs.put("confluent.alter.cluster.configs.enable", "true");
        policyConfigs.put("confluent.plugins.topic.policy.replication.factor", Short.toString((short)3));
        this.policy.configure(policyConfigs);
    }

    private AlterConfigPolicy.RequestMetadata createBrokerRequestMetadata(KafkaPrincipal principal) {
        ConfigResource cfgResource = new ConfigResource(ConfigResource.Type.BROKER, "dummy");
        Map<String, String> brokerConfigs = Collections.singletonMap("message.max.bytes", "4242");
        return new AlterConfigPolicy.RequestMetadata(cfgResource, brokerConfigs, principal);
    }

    private AlterConfigPolicy.RequestMetadata createBrokerLoggerRequestMetadata(KafkaPrincipal principal) {
        ConfigResource cfgResource = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "dummy");
        Map<String, String> loggerConfigs = Collections.singletonMap("kafka.tier.archiver.TierArchiver", "INFO");
        return new AlterConfigPolicy.RequestMetadata(cfgResource, loggerConfigs, principal);
    }

    @Test
    public void rejectsUnknownTypeConfigs() {
        ConfigResource cfgResource = new ConfigResource(ConfigResource.Type.UNKNOWN, "dummy");
        MultiTenantPrincipal principal = new MultiTenantPrincipal("tenantUserA", new TenantMetadata("cluster1", "cluster1"));
        AlterConfigPolicy.RequestMetadata brokerRequestMetadata = new AlterConfigPolicy.RequestMetadata(cfgResource, Collections.emptyMap(), (KafkaPrincipal)principal);
        Assertions.assertThrows(PolicyViolationException.class, () -> this.policy.validate(brokerRequestMetadata));
    }

    @Test
    public void validateClusterLinkEmptyParamsOk() {
        this.policy.validate(this.requestMetadataWithClusterLinkConfigs(Collections.emptyMap()));
    }

    @Test
    public void validateClusterLinkSetParamsOk() {
        this.validateClusterLinkConfig(ClusterLinkConfig.AclSyncMsProp(), "10000");
        this.validateClusterLinkConfig(ClusterLinkConfig.ConsumerOffsetSyncMsProp(), "10000");
        this.validateClusterLinkConfig(ClusterLinkConfig.TopicConfigSyncMsProp(), "10000");
        this.validateClusterLinkConfig("replica.socket.receive.buffer.bytes", "100000");
        this.validateClusterLinkConfig("sasl.mechanism", "PLAIN");
        this.validateClusterLinkConfig("sasl.mechanism", "plain");
        this.validateClusterLinkConfig("sasl.mechanism", "SCRAM-SHA-256");
        this.validateClusterLinkConfig("sasl.mechanism", "SCRAM-sha-256");
        this.validateClusterLinkConfig("sasl.mechanism", "SCRAM-SHA-512");
        this.validateClusterLinkConfig("sasl.mechanism", "Scram-Sha-512");
    }

    @Test
    public void rejectClusterLinkConfigs() {
        this.rejectClusterLinkConfig(ClusterLinkConfig.AclSyncMsProp(), "1");
        this.rejectClusterLinkConfig(ClusterLinkConfig.AclSyncMsProp(), "1000000000");
        this.rejectClusterLinkConfig(ClusterLinkConfig.ConsumerOffsetSyncMsProp(), "1");
        this.rejectClusterLinkConfig(ClusterLinkConfig.ConsumerOffsetSyncMsProp(), "1000000000");
        this.rejectClusterLinkConfig(ClusterLinkConfig.TopicConfigSyncMsProp(), "1");
        this.rejectClusterLinkConfig(ClusterLinkConfig.TopicConfigSyncMsProp(), "1000000000");
        this.rejectClusterLinkConfig("replica.socket.receive.buffer.bytes", "1");
        this.rejectClusterLinkConfig("replica.socket.receive.buffer.bytes", "1000000000");
        this.rejectClusterLinkConfig("sasl.mechanism", "GSSAPI");
        this.rejectClusterLinkConfig("sasl.mechanism", "INVALID");
    }

    @Test
    public void rejectUnknownConfigs() {
        this.rejectClusterLinkConfig("", "1000");
        this.rejectClusterLinkConfig(".", "1000");
        this.rejectClusterLinkConfig("bad.config", "1000");
    }

    private AlterConfigPolicy.RequestMetadata requestMetadataWithClusterLinkConfigs(Map<String, String> clusterLinkConfigs) {
        ConfigResource cfgResource = new ConfigResource(ConfigResource.Type.CLUSTER_LINK, "dummy");
        return new AlterConfigPolicy.RequestMetadata(cfgResource, clusterLinkConfigs, (KafkaPrincipal)new MultiTenantPrincipal("tenantUserA", new TenantMetadata("cluster1", "cluster1")));
    }

    private void validateClusterLinkConfig(String key, String value) {
        this.policy.validate(this.requestMetadataWithClusterLinkConfigs(Collections.singletonMap(key, value)));
    }

    private void rejectClusterLinkConfig(String key, String value) {
        Assertions.assertThrows(PolicyViolationException.class, () -> this.validateClusterLinkConfig(key, value));
    }

    @Test
    public void validateGroupConfigAutoOffsetResetStrategy() {
        this.validateGroupConfig("share.auto.offset.reset", "earliest");
        this.validateGroupConfig("share.auto.offset.reset", "latest");
        this.rejectGroupConfig("share.auto.offset.reset", "earlst");
    }

    @Test
    public void validateGroupConfigShareIsolationLevel() {
        this.validateGroupConfig("share.isolation.level", "read_committed");
        this.validateGroupConfig("share.isolation.level", "read_uncommitted");
        this.rejectGroupConfig("share.isolation.level", "read");
    }

    @Test
    public void validateGroupConfigShareRecordLockDuration() {
        this.validateGroupConfig("share.record.lock.duration.ms", "15000");
        this.validateGroupConfig("share.record.lock.duration.ms", "45000");
        this.validateGroupConfig("share.record.lock.duration.ms", "60000");
        this.rejectGroupConfig("share.record.lock.duration.ms", "1500");
        this.rejectGroupConfig("share.record.lock.duration.ms", "100000");
    }

    @Test
    public void validateGroupConfigShareHeartbeatInterval() {
        this.validateGroupConfig("share.heartbeat.interval.ms", "5000");
        this.validateGroupConfig("share.heartbeat.interval.ms", "15000");
        this.validateGroupConfig("share.heartbeat.interval.ms", "10000");
        this.rejectGroupConfig("share.heartbeat.interval.ms", "500");
        this.rejectGroupConfig("share.heartbeat.interval.ms", "25000");
    }

    @Test
    public void validateGroupConfigShareSessionTimeout() {
        this.validateGroupConfig("share.session.timeout.ms", "45000");
        this.validateGroupConfig("share.session.timeout.ms", "60000");
        this.validateGroupConfig("share.session.timeout.ms", "50000");
        this.rejectGroupConfig("share.session.timeout.ms", "15000");
        this.rejectGroupConfig("share.session.timeout.ms", "75000");
    }

    @Test
    public void validateGroupConfigConsumerSessionTimeout() {
        this.validateGroupConfig("consumer.session.timeout.ms", "45000");
        this.validateGroupConfig("consumer.session.timeout.ms", "60000");
        this.validateGroupConfig("consumer.session.timeout.ms", "50000");
        this.rejectGroupConfig("consumer.session.timeout.ms", "15000");
        this.rejectGroupConfig("consumer.session.timeout.ms", "75000");
    }

    @Test
    public void validateGroupConfigConsumerHeartbeatInterval() {
        this.validateGroupConfig("consumer.heartbeat.interval.ms", "5000");
        this.validateGroupConfig("consumer.heartbeat.interval.ms", "10000");
        this.validateGroupConfig("consumer.heartbeat.interval.ms", "15000");
        this.rejectGroupConfig("consumer.heartbeat.interval.ms", "500");
        this.rejectGroupConfig("consumer.heartbeat.interval.ms", "25000");
    }

    private AlterConfigPolicy.RequestMetadata requestMetadataWithGroupConfigs(Map<String, String> groupConfigs) {
        ConfigResource cfgResource = new ConfigResource(ConfigResource.Type.GROUP, "test-group");
        return new AlterConfigPolicy.RequestMetadata(cfgResource, groupConfigs, (KafkaPrincipal)new MultiTenantPrincipal("tenantUserA", new TenantMetadata("cluster1", "cluster1")));
    }

    private void validateGroupConfig(String key, String value) {
        this.policy.validate(this.requestMetadataWithGroupConfigs(Collections.singletonMap(key, value)));
    }

    private void rejectGroupConfig(String key, String value) {
        Assertions.assertThrows(PolicyViolationException.class, () -> this.validateGroupConfig(key, value));
    }
}

