/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.oauth.mockserver.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.confluent.security.auth.oauth.mockserver.common.BearerTokenWithPayload;
import io.confluent.security.auth.oauth.mockserver.common.TimeUtil;
import io.confluent.security.auth.oauth.mockserver.common.TokenInfo;
import java.util.Objects;
import java.util.Set;

public class CommonFunctions {
    static final String WWW_FORM_CONTENT_TYPE = "application/x-www-form-urlencoded";
    public static final String LOG_PATH = "target/test.log";

    static class MockBearerTokenWithPayload
    implements BearerTokenWithPayload {
        private final TokenInfo ti;
        private JsonNode payload;

        MockBearerTokenWithPayload(TokenInfo ti) {
            if (ti == null) {
                throw new IllegalArgumentException("TokenInfo == null");
            }
            this.ti = ti;
        }

        @Override
        public JsonNode getPayload() {
            return this.payload;
        }

        @Override
        public void setPayload(JsonNode value) {
            this.payload = value;
        }

        @Override
        public Set<String> getGroups() {
            return this.ti.groups();
        }

        @Override
        public ObjectNode getClaimsJSON() {
            return this.ti.payload();
        }

        public String value() {
            return this.ti.token();
        }

        public Set<String> scope() {
            return this.ti.scope();
        }

        public long lifetimeMs() {
            return this.ti.expiresAtMs();
        }

        public String principalName() {
            return this.ti.principal();
        }

        public Long startTimeMs() {
            return this.ti.issuedAtMs();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MockBearerTokenWithPayload)) {
                return false;
            }
            MockBearerTokenWithPayload that = (MockBearerTokenWithPayload)o;
            return this.ti.equals(that.ti) && Objects.equals(this.payload, that.payload);
        }

        public int hashCode() {
            return Objects.hash(this.ti, this.payload);
        }

        public String toString() {
            return "BearerTokenWithPayload (principalName: " + this.ti.principal() + ", groups: " + String.valueOf(this.ti.groups()) + ", lifetimeMs: " + this.ti.expiresAtMs() + " [" + TimeUtil.formatIsoDateTimeUTC(this.ti.expiresAtMs()) + " UTC], startTimeMs: " + this.ti.issuedAtMs() + " [" + TimeUtil.formatIsoDateTimeUTC(this.ti.issuedAtMs()) + " UTC], scope: " + String.valueOf(this.ti.scope()) + ")";
        }
    }
}

