/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.tools;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.utils.Exit;

public class DeleteAclsForMultiTenantPrincipal {
    public static void main(String[] args) {
        if (args.length == 1 && (args[0].equals("--h") || args[0].equals("--help"))) {
            System.out.println("Pass BOOTSTRAP_SERVERS_CONFIG as first arguments, lkcID as second arguments and other arguments as space separated principals. Usage: DeleteAclsForMultiTenantPrincipal localhost:1971 lkc-123 user1");
            Exit.exit((int)0);
        } else if (args.length < 3) {
            System.out.println("Pass at least three arguments, BOOTSTRAP_SERVERS_CONFIG as first arguments, lkcID as second arguments and other arguments as principals.");
            Exit.exit((int)0);
        }
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", args[0]);
        List<String> users = Arrays.asList(args);
        String lcId = new String(args[1]);
        users.replaceAll(user -> lcId + "_" + user);
        System.out.println("ACLs will be deleted for the following users: \n" + String.valueOf(users));
        int count = 0;
        try (AdminClient adminClient = AdminClient.create((Properties)props);){
            System.out.println("Successfully created Admin client!");
            Collection aclBindingList = (Collection)adminClient.describeAcls(AclBindingFilter.ANY).values().get();
            System.out.println("Fetched all the ACLs!");
            for (AclBinding aclBinding : aclBindingList) {
                String user2 = DeleteAclsForMultiTenantPrincipal.removeUserPrefix(aclBinding.entry().principal());
                if (!users.contains(user2)) continue;
                Collection deleteAclBinding = (Collection)adminClient.deleteAcls(Collections.singleton(aclBinding.toFilter())).all().get();
                if (deleteAclBinding.size() != 1) {
                    throw new RuntimeException("One AclBinding = " + String.valueOf(aclBinding) + " found but not deleted!");
                }
                ++count;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        System.out.println("Deleted " + count + " ACLs");
    }

    public static String removeUserPrefix(String str) {
        if (str == null || str.isEmpty()) {
            throw new IllegalArgumentException("expected a string in format principalType:principalName but got " + str);
        }
        String[] split = str.split(":", 2);
        if (split.length != 2) {
            throw new IllegalArgumentException("expected a string in format principalType:principalName but got " + str);
        }
        return split[1];
    }
}

