/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.clients.plugins.auth.jwt;

import io.confluent.kafka.clients.plugins.auth.jwt.AsyncHttpsJwks;
import io.confluent.kafka.clients.plugins.auth.jwt.AsyncHttpsJwksVerificationKeyResolver;
import io.confluent.kafka.clients.plugins.auth.jwt.CloseableVerificationKeyResolver;
import io.confluent.kafka.clients.plugins.auth.jwt.JkuVerificationKeyResolver;
import io.confluent.kafka.clients.plugins.auth.jwt.JwtAuthenticator;
import io.confluent.kafka.clients.plugins.auth.jwt.JwtVerificationException;
import io.confluent.kafka.clients.plugins.auth.jwt.UnverifiedJwtBearerToken;
import io.confluent.security.fixtures.jwt.TestJwkProvider;
import java.io.IOException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.jose4j.http.Response;
import org.jose4j.http.SimpleGet;
import org.jose4j.http.SimpleResponse;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.UnresolvableKeyException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class ValidationKeyResolverTest {
    @Test
    public void testVerificationKeyResolverUnknownKid() {
        TestJwkProvider jwks = new TestJwkProvider();
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        VerificationKeyResolver keyResolver = ValidationKeyResolverTest.newKeyResolver(httpsJwks, true);
        Assertions.assertThrows(UnresolvableKeyException.class, () -> keyResolver.resolveKey(ValidationKeyResolverTest.newRsaJws("mysteryKID"), Collections.emptyList()));
    }

    @Test
    public void testVerificationKeyResolverKnownKid() throws Exception {
        TestJwkProvider jwks = new TestJwkProvider();
        PublicJsonWebKey jwk = jwks.createJwkIfAbsent("k1");
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        VerificationKeyResolver keyResolver = ValidationKeyResolverTest.newKeyResolver(httpsJwks, true);
        httpsJwks.syncRefresh();
        Assertions.assertEquals((Object)jwk.getKey(), (Object)keyResolver.resolveKey(ValidationKeyResolverTest.newRsaJws("k1"), Collections.emptyList()));
    }

    @Test
    public void testVerificationKeyResolverNoKidSingleJwkDisambiguateJwkTrue() throws Exception {
        TestJwkProvider jwks = new TestJwkProvider();
        PublicJsonWebKey jwk = jwks.createJwkIfAbsent("k1");
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        VerificationKeyResolver keyResolver = ValidationKeyResolverTest.newKeyResolver(httpsJwks, true);
        httpsJwks.syncRefresh();
        Assertions.assertEquals((Object)jwk.getKey(), (Object)keyResolver.resolveKey(ValidationKeyResolverTest.newRsaJws(""), Collections.emptyList()));
    }

    @Test
    public void testVerificationKeyResolverNoKidMultiJwk() throws Exception {
        TestJwkProvider jwks = new TestJwkProvider();
        jwks.createJwkIfAbsent("k1");
        jwks.createJwkIfAbsent("k2");
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        VerificationKeyResolver keyResolver = ValidationKeyResolverTest.newKeyResolver(httpsJwks, true);
        httpsJwks.syncRefresh();
        Assertions.assertThrows(UnresolvableKeyException.class, () -> keyResolver.resolveKey(ValidationKeyResolverTest.newRsaJws(""), Collections.emptyList()));
    }

    @Test
    public void testAmbiguousVerificationKeyNoKidKnownAlg() throws Exception {
        TestJwkProvider jwks = new TestJwkProvider();
        PublicJsonWebKey jwk = jwks.createJwkIfAbsent("");
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        VerificationKeyResolver keyResolver = ValidationKeyResolverTest.newKeyResolver(httpsJwks, false);
        httpsJwks.syncRefresh();
        Assertions.assertEquals((Object)jwk.getKey(), (Object)keyResolver.resolveKey(ValidationKeyResolverTest.newRsaJws(""), Collections.emptyList()));
    }

    @Test
    public void testAmbiguousVerificationKeyUnknownKidKnownAlg() {
        TestJwkProvider jwks = new TestJwkProvider();
        jwks.createJwkIfAbsent("validKid");
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        VerificationKeyResolver keyResolver = ValidationKeyResolverTest.newKeyResolver(httpsJwks, false);
        Assertions.assertThrows(UnresolvableKeyException.class, () -> keyResolver.resolveKey(ValidationKeyResolverTest.newRsaJws("invalidKid"), Collections.emptyList()));
    }

    @Test
    public void testAmbiguousVerificationKeyNoKidUnknownAlg() {
        TestJwkProvider jwks = new TestJwkProvider();
        jwks.createJwkIfAbsent("");
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        VerificationKeyResolver keyResolver = ValidationKeyResolverTest.newKeyResolver(httpsJwks, false);
        Assertions.assertThrows(UnresolvableKeyException.class, () -> keyResolver.resolveKey(ValidationKeyResolverTest.newEcsJws(""), Collections.emptyList()));
    }

    @Test
    public void testAmbiguousVerificationKeyValidKidUnknownAlg() {
        TestJwkProvider jwks = new TestJwkProvider();
        jwks.createJwkIfAbsent("k1");
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        VerificationKeyResolver keyResolver = ValidationKeyResolverTest.newKeyResolver(httpsJwks, false);
        Assertions.assertThrows(UnresolvableKeyException.class, () -> keyResolver.resolveKey(ValidationKeyResolverTest.newEcsJws("k1"), Collections.emptyList()));
    }

    @Test
    public void testJkuVerificationKey() throws Exception {
        TestJwkProvider jwks = new TestJwkProvider();
        PublicJsonWebKey jwk = jwks.createJwkIfAbsent("k1");
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        JkuVerificationKeyResolver keyResolver = new JkuVerificationKeyResolver(location -> httpsJwks, Collections.singletonList("localhost"), false, false);
        httpsJwks.syncRefresh();
        Assertions.assertEquals((Object)jwk.getKey(), (Object)keyResolver.resolveKey(ValidationKeyResolverTest.newRsaJws("k1"), Collections.emptyList()));
    }

    @Test
    public void testJkuVerificationKeyRelativeDomain() {
        List<String> domainWhiteList = Collections.singletonList(".localhost.com");
        String jkuDomain = "https://test.localhost.com:8090";
        Assertions.assertTrue((boolean)JkuVerificationKeyResolver.hasValidJkuDomain(domainWhiteList, (String)"https", (String)jkuDomain), (String)String.format("%s should be valid with domain whitelist %s", jkuDomain, domainWhiteList));
        jkuDomain = "https://testing.1.2.3.localhost.com:8090";
        Assertions.assertTrue((boolean)JkuVerificationKeyResolver.hasValidJkuDomain(domainWhiteList, (String)"https", (String)jkuDomain), (String)String.format("%s should be valid with domain whitelist %s", jkuDomain, domainWhiteList));
        jkuDomain = "https://test.not_localhost.com:8090";
        Assertions.assertFalse((boolean)JkuVerificationKeyResolver.hasValidJkuDomain(domainWhiteList, (String)"https", (String)jkuDomain), (String)String.format("%s should be invalid with domain whitelist %s", jkuDomain, domainWhiteList));
        jkuDomain = "https://test.localhost:8090";
        Assertions.assertFalse((boolean)JkuVerificationKeyResolver.hasValidJkuDomain(domainWhiteList, (String)"https", (String)jkuDomain), (String)String.format("%s should be invalid with domain whitelist %s", jkuDomain, domainWhiteList));
        jkuDomain = "https://test.localhost:8090";
        Assertions.assertFalse((boolean)JkuVerificationKeyResolver.hasValidJkuDomain(Collections.singletonList(".localhost.com"), (String)"https", (String)jkuDomain), (String)String.format("%s should be invalid with domain whitelist %s", jkuDomain, domainWhiteList));
    }

    @Test
    public void testJkuVerificationKeyInvalidDomain() {
        TestJwkProvider jwks = new TestJwkProvider();
        jwks.createJwkIfAbsent("k1");
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        JkuVerificationKeyResolver keyResolver = new JkuVerificationKeyResolver(location -> httpsJwks, Collections.singletonList("mysteryIssuer"), false, true);
        httpsJwks.syncRefresh();
        Throwable e = Assertions.assertThrows(UnresolvableKeyException.class, () -> ValidationKeyResolverTest.lambda$testJkuVerificationKeyInvalidDomain$1((VerificationKeyResolver)keyResolver));
        Assertions.assertTrue((boolean)e.getLocalizedMessage().startsWith("Invalid jku:"));
    }

    @Test
    public void testJkuVerificationKeyEmptyDomainWhitelist() {
        TestJwkProvider jwks = new TestJwkProvider();
        jwks.createJwkIfAbsent("k1");
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        Assertions.assertThrows(ConfigException.class, () -> new JkuVerificationKeyResolver(location -> httpsJwks, Collections.emptyList(), false, true));
    }

    @Test
    public void testJkuVerificationKeyShutdown() throws IOException {
        JkuVerificationKeyResolver keyResolver = new JkuVerificationKeyResolver(Collections.singletonList("localhost"), true);
        keyResolver.close();
        Assertions.assertThrows(IllegalStateException.class, () -> ValidationKeyResolverTest.lambda$testJkuVerificationKeyShutdown$0((CloseableVerificationKeyResolver)keyResolver));
    }

    @Test
    public void testAsyncHttpsJwksVerificationKeyResolverShutdown() throws IOException {
        TestJwkProvider jwks = new TestJwkProvider();
        jwks.createJwkIfAbsent("k1");
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        AsyncHttpsJwksVerificationKeyResolver keyResolver = new AsyncHttpsJwksVerificationKeyResolver(httpsJwks);
        keyResolver.close();
        Assertions.assertThrows(IllegalStateException.class, () -> ValidationKeyResolverTest.lambda$testAsyncHttpsJwksVerificationKeyResolverShutdown$0((CloseableVerificationKeyResolver)keyResolver));
    }

    @Test
    public void testAudVerificationWhenValidAudButNotRequired() throws Exception {
        String sub = "test";
        String kid = "k1";
        String aud = "kafka";
        ArrayList<String> audList = new ArrayList<String>();
        audList.add(aud);
        TestJwkProvider jwks = new TestJwkProvider();
        PublicJsonWebKey jwk = jwks.createJwkIfAbsent(kid);
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        JwtClaims claims = this.buildJwt(sub, aud);
        JsonWebSignature jws = this.buildJws(claims, jwk);
        AsyncHttpsJwksVerificationKeyResolver keyResolver = new AsyncHttpsJwksVerificationKeyResolver(httpsJwks, true);
        JwtAuthenticator authenticator = new JwtAuthenticator("https://localhost", (CloseableVerificationKeyResolver)keyResolver, audList, false);
        OAuthBearerToken token = authenticator.login(jws.getCompactSerialization());
        Assertions.assertEquals((Object)sub, (Object)token.principalName());
    }

    @Test
    public void testJwtAuthenticatorExtractSignature() throws Exception {
        String sub = "test";
        String kid = "k1";
        String aud = "kafka";
        ArrayList<String> audList = new ArrayList<String>();
        audList.add(aud);
        TestJwkProvider jwks = new TestJwkProvider();
        PublicJsonWebKey jwk = jwks.createJwkIfAbsent(kid);
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        JwtClaims claims = this.buildJwt(sub, aud);
        JsonWebSignature jws = this.buildJws(claims, jwk);
        AsyncHttpsJwksVerificationKeyResolver keyResolver = new AsyncHttpsJwksVerificationKeyResolver(httpsJwks, true);
        JwtAuthenticator authenticator = new JwtAuthenticator("https://localhost", (CloseableVerificationKeyResolver)keyResolver, audList, false);
        OAuthBearerToken token = authenticator.login(jws.getCompactSerialization());
        Assertions.assertEquals((Object)JwtAuthenticator.extractSignature((OAuthBearerToken)token), (Object)token.value().split("\\.")[2]);
    }

    @Test
    public void testJwtAuthenticatorExtractEmptySignature() throws Exception {
        String sub = "test";
        String aud = "kafka";
        JwtClaims claims = this.buildJwt(sub, aud);
        JsonWebSignature jws = new JsonWebSignature();
        jws.setAlgorithmHeaderValue("none");
        jws.setAlgorithmConstraints(AlgorithmConstraints.NO_CONSTRAINTS);
        jws.setPayload(claims.toJson());
        UnverifiedJwtBearerToken token = new UnverifiedJwtBearerToken(jws.getCompactSerialization());
        Assertions.assertTrue((boolean)JwtAuthenticator.extractSignature((OAuthBearerToken)token).isEmpty());
    }

    @Test
    public void testUnverifiedJwtBearerTokenIatUnsupported() throws Exception {
        JwtClaims claims = new JwtClaims();
        claims.setIssuer("https://localhost");
        claims.setSubject("test");
        claims.setAudience("kafka");
        claims.setStringClaim("scope", "foo bar");
        claims.setGeneratedJwtId(16);
        claims.setExpirationTimeMinutesInTheFuture(10.0f);
        JsonWebSignature jws = new JsonWebSignature();
        jws.setAlgorithmHeaderValue("none");
        jws.setAlgorithmConstraints(AlgorithmConstraints.NO_CONSTRAINTS);
        jws.setPayload(claims.toJson());
        UnverifiedJwtBearerToken token = new UnverifiedJwtBearerToken(jws.getCompactSerialization());
        Assertions.assertEquals((Object)"test", (Object)token.principalName());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((OAuthBearerToken)token).startTimeMs());
    }

    @Test
    public void testUnverifiedJwtBearerTokenScopeUnsupported() throws Exception {
        String sub = "test";
        String aud = "kafka";
        JwtClaims claims = this.buildJwt(sub, aud);
        claims.setStringClaim("scope", "foo bar");
        JsonWebSignature jws = new JsonWebSignature();
        jws.setAlgorithmHeaderValue("none");
        jws.setAlgorithmConstraints(AlgorithmConstraints.NO_CONSTRAINTS);
        jws.setPayload(claims.toJson());
        UnverifiedJwtBearerToken token = new UnverifiedJwtBearerToken(jws.getCompactSerialization());
        Assertions.assertEquals((Object)"test", (Object)token.principalName());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ((OAuthBearerToken)token).scope());
    }

    @Test
    public void testAudVerificationMultiAudMatch() throws Exception {
        String sub = "test";
        String kid = "k1";
        String aud = "kafka";
        String aud2 = "notKafka";
        ArrayList<String> audList = new ArrayList<String>();
        audList.add(aud);
        TestJwkProvider jwks = new TestJwkProvider();
        PublicJsonWebKey jwk = jwks.createJwkIfAbsent(kid);
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        JwtClaims claims = this.buildJwt(sub, aud, aud2);
        JsonWebSignature jws = this.buildJws(claims, jwk);
        AsyncHttpsJwksVerificationKeyResolver keyResolver = new AsyncHttpsJwksVerificationKeyResolver(httpsJwks, true);
        JwtAuthenticator authenticator = new JwtAuthenticator("https://localhost", (CloseableVerificationKeyResolver)keyResolver, audList, false);
        OAuthBearerToken token = authenticator.login(jws.getCompactSerialization());
        Assertions.assertEquals((Object)sub, (Object)token.principalName());
    }

    @Test
    public void testAudVerificationMultiAudInJwtAuthenticatorMatch() throws Exception {
        String sub = "test";
        String kid = "k1";
        String aud = "kafka";
        String aud2 = "notKafka";
        ArrayList<String> audList = new ArrayList<String>(Arrays.asList(aud, aud2));
        TestJwkProvider jwks = new TestJwkProvider();
        PublicJsonWebKey jwk = jwks.createJwkIfAbsent(kid);
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        JwtClaims claims = this.buildJwt(sub, aud);
        JsonWebSignature jws = this.buildJws(claims, jwk);
        AsyncHttpsJwksVerificationKeyResolver keyResolver = new AsyncHttpsJwksVerificationKeyResolver(httpsJwks, true);
        JwtAuthenticator authenticator = new JwtAuthenticator("https://localhost", (CloseableVerificationKeyResolver)keyResolver, audList, false);
        OAuthBearerToken token = authenticator.login(jws.getCompactSerialization());
        Assertions.assertEquals((Object)sub, (Object)token.principalName());
    }

    @Test
    public void testAudVerificationMultiAudInAuthenticatorAndMultiAudInJwtMatch() throws Exception {
        String sub = "test";
        String kid = "k1";
        String jwtAud1 = "kafka";
        String jwtAud2 = "test";
        ArrayList<String> audList = new ArrayList<String>(Arrays.asList(jwtAud1, "notKafka"));
        TestJwkProvider jwks = new TestJwkProvider();
        PublicJsonWebKey jwk = jwks.createJwkIfAbsent(kid);
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        JwtClaims claims = this.buildJwt(sub, jwtAud1, jwtAud2);
        JsonWebSignature jws = this.buildJws(claims, jwk);
        AsyncHttpsJwksVerificationKeyResolver keyResolver = new AsyncHttpsJwksVerificationKeyResolver(httpsJwks, true);
        JwtAuthenticator authenticator = new JwtAuthenticator("https://localhost", (CloseableVerificationKeyResolver)keyResolver, audList, false);
        OAuthBearerToken token = authenticator.login(jws.getCompactSerialization());
        Assertions.assertEquals((Object)sub, (Object)token.principalName());
    }

    @Test
    public void testAudVerificationMultiAudInJwtAuthenticatorNoMatch() throws Exception {
        String sub = "test";
        String kid = "k1";
        String jwtaud1 = "error";
        String jwtaud2 = "error1";
        ArrayList<String> audList = new ArrayList<String>(Arrays.asList("kafka", "notKafka"));
        TestJwkProvider jwks = new TestJwkProvider();
        PublicJsonWebKey jwk = jwks.createJwkIfAbsent(kid);
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        JwtClaims claims = this.buildJwt(sub, jwtaud1, jwtaud2);
        JsonWebSignature jws = this.buildJws(claims, jwk);
        AsyncHttpsJwksVerificationKeyResolver keyResolver = new AsyncHttpsJwksVerificationKeyResolver(httpsJwks, true);
        JwtAuthenticator authenticator = new JwtAuthenticator("https://localhost", (CloseableVerificationKeyResolver)keyResolver, audList, false);
        Assertions.assertThrows(JwtVerificationException.class, () -> authenticator.login(jws.getCompactSerialization()));
    }

    @Test
    public void testAudVerificationEmptyAudWithEmptyAudInAuthenticatorAndJwt() throws Exception {
        String sub = "test";
        String kid = "k1";
        TestJwkProvider jwks = new TestJwkProvider();
        PublicJsonWebKey jwk = jwks.createJwkIfAbsent(kid);
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        JwtClaims claims = this.buildJwt(sub, new String[0]);
        JsonWebSignature jws = this.buildJws(claims, jwk);
        AsyncHttpsJwksVerificationKeyResolver keyResolver = new AsyncHttpsJwksVerificationKeyResolver(httpsJwks, true);
        JwtAuthenticator authenticator = new JwtAuthenticator("https://localhost", (CloseableVerificationKeyResolver)keyResolver);
        OAuthBearerToken token = authenticator.login(jws.getCompactSerialization());
        Assertions.assertEquals((Object)sub, (Object)token.principalName());
    }

    @Test
    public void testAudVerificationEmptyAudWithEmptyAudInAuthenticator() throws Exception {
        String sub = "test";
        String kid = "k1";
        String aud = "kafka";
        TestJwkProvider jwks = new TestJwkProvider();
        PublicJsonWebKey jwk = jwks.createJwkIfAbsent(kid);
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        JwtClaims claims = this.buildJwt(sub, aud);
        JsonWebSignature jws = this.buildJws(claims, jwk);
        AsyncHttpsJwksVerificationKeyResolver keyResolver = new AsyncHttpsJwksVerificationKeyResolver(httpsJwks, true);
        JwtAuthenticator authenticator = new JwtAuthenticator("https://localhost", (CloseableVerificationKeyResolver)keyResolver);
        OAuthBearerToken token = authenticator.login(jws.getCompactSerialization());
        Assertions.assertEquals((Object)sub, (Object)token.principalName());
    }

    @Test
    public void testAudVerificationEmptyAudWithMultiAudInAuthenticator() throws Exception {
        String sub = "test";
        String kid = "k1";
        ArrayList audList = new ArrayList();
        TestJwkProvider jwks = new TestJwkProvider();
        PublicJsonWebKey jwk = jwks.createJwkIfAbsent(kid);
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        JwtClaims claims = this.buildJwt(sub, new String[0]);
        JsonWebSignature jws = this.buildJws(claims, jwk);
        AsyncHttpsJwksVerificationKeyResolver keyResolver = new AsyncHttpsJwksVerificationKeyResolver(httpsJwks, true);
        JwtAuthenticator authenticator = new JwtAuthenticator("https://localhost", (CloseableVerificationKeyResolver)keyResolver, audList, false);
        OAuthBearerToken token = authenticator.login(jws.getCompactSerialization());
        Assertions.assertEquals((Object)sub, (Object)token.principalName());
    }

    @Test
    public void testAudVerificationEmptyAudWithMultiAudInAuthenticatorAndAudRequired() throws Exception {
        String sub = "test";
        String kid = "k1";
        ArrayList<String> audList = new ArrayList<String>(Arrays.asList("kafka", "notKafka"));
        TestJwkProvider jwks = new TestJwkProvider();
        PublicJsonWebKey jwk = jwks.createJwkIfAbsent(kid);
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        JwtClaims claims = this.buildJwt(sub, new String[0]);
        JsonWebSignature jws = this.buildJws(claims, jwk);
        AsyncHttpsJwksVerificationKeyResolver keyResolver = new AsyncHttpsJwksVerificationKeyResolver(httpsJwks, true);
        JwtAuthenticator authenticator = new JwtAuthenticator("https://localhost", (CloseableVerificationKeyResolver)keyResolver, audList, true);
        Assertions.assertThrows(JwtVerificationException.class, () -> authenticator.login(jws.getCompactSerialization()));
    }

    @Test
    public void testAudVerificationMultiAudInAuthenticatorAndAudRequired() throws Exception {
        String sub = "test";
        String kid = "k1";
        String aud = "kafka";
        ArrayList<String> audList = new ArrayList<String>(Arrays.asList(aud, "notKafka"));
        TestJwkProvider jwks = new TestJwkProvider();
        PublicJsonWebKey jwk = jwks.createJwkIfAbsent(kid);
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        JwtClaims claims = this.buildJwt(sub, aud);
        JsonWebSignature jws = this.buildJws(claims, jwk);
        AsyncHttpsJwksVerificationKeyResolver keyResolver = new AsyncHttpsJwksVerificationKeyResolver(httpsJwks, true);
        JwtAuthenticator authenticator = new JwtAuthenticator("https://localhost", (CloseableVerificationKeyResolver)keyResolver, audList, true);
        OAuthBearerToken token = authenticator.login(jws.getCompactSerialization());
        Assertions.assertEquals((Object)sub, (Object)token.principalName());
    }

    @Test
    public void testAudVerificationMultiAudInAuthenticatorAndAudRequiredNoMatch() throws Exception {
        String sub = "test";
        String kid = "k1";
        String aud = "error";
        ArrayList<String> audList = new ArrayList<String>(Arrays.asList("kafka", "notKafka"));
        TestJwkProvider jwks = new TestJwkProvider();
        PublicJsonWebKey jwk = jwks.createJwkIfAbsent(kid);
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        JwtClaims claims = this.buildJwt(sub, aud);
        JsonWebSignature jws = this.buildJws(claims, jwk);
        AsyncHttpsJwksVerificationKeyResolver keyResolver = new AsyncHttpsJwksVerificationKeyResolver(httpsJwks, true);
        JwtAuthenticator authenticator = new JwtAuthenticator("https://localhost", (CloseableVerificationKeyResolver)keyResolver, audList, true);
        Assertions.assertThrows(JwtVerificationException.class, () -> authenticator.login(jws.getCompactSerialization()));
    }

    @Test
    public void testAudVerificationNoAudInAuthenticatorAndAudRequiredNoMatch() throws Exception {
        String sub = "test";
        String kid = "k1";
        String aud = "error";
        TestJwkProvider jwks = new TestJwkProvider();
        PublicJsonWebKey jwk = jwks.createJwkIfAbsent(kid);
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        JwtClaims claims = this.buildJwt(sub, aud);
        JsonWebSignature jws = this.buildJws(claims, jwk);
        AsyncHttpsJwksVerificationKeyResolver keyResolver = new AsyncHttpsJwksVerificationKeyResolver(httpsJwks, true);
        JwtAuthenticator authenticator = new JwtAuthenticator("https://localhost", (CloseableVerificationKeyResolver)keyResolver, null, true);
        OAuthBearerToken token = authenticator.login(jws.getCompactSerialization());
        Assertions.assertEquals((Object)sub, (Object)token.principalName());
    }

    @Test
    public void testAudVerificationNoAudInAuthenticatorAndNoAudAndAudRequiredMatch() throws Exception {
        String sub = "test";
        String kid = "k1";
        TestJwkProvider jwks = new TestJwkProvider();
        PublicJsonWebKey jwk = jwks.createJwkIfAbsent(kid);
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        JwtClaims claims = this.buildJwt(sub, new String[0]);
        JsonWebSignature jws = this.buildJws(claims, jwk);
        AsyncHttpsJwksVerificationKeyResolver keyResolver = new AsyncHttpsJwksVerificationKeyResolver(httpsJwks, true);
        JwtAuthenticator authenticator = new JwtAuthenticator("https://localhost", (CloseableVerificationKeyResolver)keyResolver, null, true);
        OAuthBearerToken token = authenticator.login(jws.getCompactSerialization());
        Assertions.assertEquals((Object)sub, (Object)token.principalName());
    }

    @Test
    public void testAudVerificationMultiAudNoMatch() throws Exception {
        String sub = "test";
        String kid = "k1";
        String aud = "notKafka";
        String aud2 = "alsoNotKafka";
        ArrayList<String> audList = new ArrayList<String>(Arrays.asList("kafka"));
        TestJwkProvider jwks = new TestJwkProvider();
        PublicJsonWebKey jwk = jwks.createJwkIfAbsent(kid);
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        JwtClaims claims = this.buildJwt(sub, aud, aud2);
        JsonWebSignature jws = this.buildJws(claims, jwk);
        AsyncHttpsJwksVerificationKeyResolver keyResolver = new AsyncHttpsJwksVerificationKeyResolver(httpsJwks, true);
        JwtAuthenticator authenticator = new JwtAuthenticator("https://localhost", (CloseableVerificationKeyResolver)keyResolver, audList, false);
        Assertions.assertThrows(JwtVerificationException.class, () -> authenticator.login(jws.getCompactSerialization()));
    }

    @Test
    public void testAudVerificationNullAud() throws Exception {
        String sub = "test";
        String kid = "k1";
        TestJwkProvider jwks = new TestJwkProvider();
        PublicJsonWebKey jwk = jwks.createJwkIfAbsent(kid);
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        JwtClaims claims = this.buildJwt(sub, new String[0]);
        JsonWebSignature jws = this.buildJws(claims, jwk);
        AsyncHttpsJwksVerificationKeyResolver keyResolver = new AsyncHttpsJwksVerificationKeyResolver(httpsJwks, true);
        JwtAuthenticator authenticator = new JwtAuthenticator("https://localhost", (CloseableVerificationKeyResolver)keyResolver, null, false);
        OAuthBearerToken token = authenticator.login(jws.getCompactSerialization());
        Assertions.assertEquals((Object)sub, (Object)token.principalName());
    }

    @Test
    public void testAudVerificationEmptyAud() throws Exception {
        String sub = "test";
        String kid = "k1";
        ArrayList<String> audList = new ArrayList<String>(Arrays.asList("kafka"));
        TestJwkProvider jwks = new TestJwkProvider();
        PublicJsonWebKey jwk = jwks.createJwkIfAbsent(kid);
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        JwtClaims claims = this.buildJwt(sub, new String[0]);
        claims.setAudience(Collections.emptyList());
        JsonWebSignature jws = this.buildJws(claims, jwk);
        AsyncHttpsJwksVerificationKeyResolver keyResolver = new AsyncHttpsJwksVerificationKeyResolver(httpsJwks, true);
        JwtAuthenticator authenticator = new JwtAuthenticator("https://localhost", (CloseableVerificationKeyResolver)keyResolver, audList, false);
        Assertions.assertThrows(JwtVerificationException.class, () -> authenticator.login(jws.getCompactSerialization()));
    }

    @Test
    public void testAudVerificationInvalidAud() {
        String sub = "test";
        String kid = "k1";
        ArrayList<String> audList = new ArrayList<String>(Arrays.asList("kafka"));
        TestJwkProvider jwks = new TestJwkProvider();
        PublicJsonWebKey jwk = jwks.createJwkIfAbsent(kid);
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        JwtClaims claims = this.buildJwt(sub, "notKafka");
        JsonWebSignature jws = this.buildJws(claims, jwk);
        AsyncHttpsJwksVerificationKeyResolver keyResolver = new AsyncHttpsJwksVerificationKeyResolver(httpsJwks, true);
        JwtAuthenticator authenticator = new JwtAuthenticator("https://localhost", (CloseableVerificationKeyResolver)keyResolver, audList, false);
        Assertions.assertThrows(JwtVerificationException.class, () -> authenticator.login(jws.getCompactSerialization()));
    }

    @Test
    public void testJwtAuthenticatorRotatedValidationKey() throws Exception {
        String sub = "test";
        String kid = "k1";
        String aud = "kafka";
        ArrayList<String> audList = new ArrayList<String>(Arrays.asList(aud));
        TestJwkProvider jwks = new TestJwkProvider();
        PublicJsonWebKey jwk = jwks.createJwkIfAbsent(kid);
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        AsyncHttpsJwksVerificationKeyResolver keyResolver = new AsyncHttpsJwksVerificationKeyResolver(httpsJwks, true);
        JwtAuthenticator authenticator = new JwtAuthenticator("https://localhost", (CloseableVerificationKeyResolver)keyResolver, audList, false);
        JwtClaims claims = this.buildJwt(sub, aud);
        JsonWebSignature jws = this.buildJws(claims, jwk);
        String compactSerialization = jws.getCompactSerialization();
        authenticator.login(compactSerialization);
        jwks.rotateJwk(kid);
        httpsJwks.syncRefresh();
        Assertions.assertThrows(JwtVerificationException.class, () -> authenticator.login(compactSerialization));
    }

    @Test
    public void testJwtAuthenticatorNewValidationKey() throws Exception {
        String sub = "test";
        String kid = "k1";
        String aud = "kafka";
        ArrayList<String> audList = new ArrayList<String>(Arrays.asList(aud));
        TestJwkProvider jwks = new TestJwkProvider();
        jwks.createJwkIfAbsent(kid);
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        AsyncHttpsJwksVerificationKeyResolver keyResolver = new AsyncHttpsJwksVerificationKeyResolver(httpsJwks, true);
        JwtAuthenticator authenticator = new JwtAuthenticator("https://localhost", (CloseableVerificationKeyResolver)keyResolver, audList, false);
        JwtClaims claims = this.buildJwt(sub, aud);
        PublicJsonWebKey jwk = jwks.generateRsaJwk("newKid");
        JsonWebSignature jws = this.buildJws(claims, jwk);
        String compactSerialization = jws.getCompactSerialization();
        Assertions.assertThrows(JwtVerificationException.class, () -> authenticator.login(compactSerialization));
        jwks.registerJwk(jwk);
        httpsJwks.syncRefresh();
        OAuthBearerToken token = authenticator.login(jws.getCompactSerialization());
        Assertions.assertEquals((Object)sub, (Object)token.principalName());
    }

    @Test
    public void testJwtAuthenticatorRevokedValidationKey() throws Exception {
        String sub = "test";
        String kid = "k1";
        String kid2 = "k2";
        String aud = "kafka";
        ArrayList<String> audList = new ArrayList<String>(Arrays.asList(aud));
        TestJwkProvider jwks = new TestJwkProvider();
        jwks.createJwkIfAbsent(kid);
        jwks.createJwkIfAbsent(kid2);
        AsyncHttpsJwks httpsJwks = ValidationKeyResolverTest.newHttpsJwks(jwks);
        AsyncHttpsJwksVerificationKeyResolver keyResolver = new AsyncHttpsJwksVerificationKeyResolver(httpsJwks, true);
        JwtAuthenticator authenticator = new JwtAuthenticator("https://localhost", (CloseableVerificationKeyResolver)keyResolver, audList, false);
        JwtClaims claims = this.buildJwt(sub, aud);
        JsonWebSignature jws = this.buildJws(claims, jwks.createJwkIfAbsent(kid));
        String compactSerialization = jws.getCompactSerialization();
        JsonWebSignature jws2 = this.buildJws(claims, jwks.createJwkIfAbsent(kid2));
        OAuthBearerToken token = authenticator.login(compactSerialization);
        jwks.deleteJwk(kid);
        httpsJwks.syncRefresh();
        Assertions.assertThrows(JwtVerificationException.class, () -> authenticator.login(compactSerialization));
        httpsJwks.syncRefresh();
        OAuthBearerToken token2 = authenticator.login(jws2.getCompactSerialization());
        Assertions.assertEquals((Object)sub, (Object)token.principalName());
        Assertions.assertEquals((Object)sub, (Object)token2.principalName());
    }

    private static JsonWebSignature newRsaJws(String kid) {
        return ValidationKeyResolverTest.newJws(kid, "RS256");
    }

    private static JsonWebSignature newEcsJws(String kid) {
        return ValidationKeyResolverTest.newJws(kid, "ES256");
    }

    private static JsonWebSignature newJws(String kid, String alg) {
        Objects.requireNonNull(kid);
        JsonWebSignature jws = new JsonWebSignature();
        jws.setAlgorithmHeaderValue(alg);
        jws.setHeader("jku", "https://localhost/jwks.json");
        if (!kid.isEmpty()) {
            jws.setKeyIdHeaderValue(kid);
        }
        return jws;
    }

    private static VerificationKeyResolver newKeyResolver(AsyncHttpsJwks httpsJwks, boolean disambiguateJwk) {
        AsyncHttpsJwksVerificationKeyResolver keyResolver = new AsyncHttpsJwksVerificationKeyResolver(httpsJwks, disambiguateJwk);
        return keyResolver;
    }

    private static AsyncHttpsJwks newHttpsJwks(TestJwkProvider jwksProvider) {
        AsyncHttpsJwks httpsJwks = new AsyncHttpsJwks((SimpleGet)new MockHttpGet(jwksProvider), "https://localhost/jwks.json", true, 0L);
        httpsJwks.setRefreshReprieveThreshold(0L);
        httpsJwks.syncRefresh();
        return httpsJwks;
    }

    private JwtClaims buildJwt(String sub, String ... aud) {
        JwtClaims claims = new JwtClaims();
        claims.setIssuer("https://localhost");
        claims.setSubject(sub);
        if (aud.length > 0) {
            claims.setAudience(aud);
        }
        claims.setIssuedAt(NumericDate.now());
        claims.setExpirationTimeMinutesInTheFuture(10.0f);
        claims.setGeneratedJwtId();
        return claims;
    }

    private JsonWebSignature buildJws(JwtClaims claims, PublicJsonWebKey jwk) {
        JsonWebSignature jws = new JsonWebSignature();
        if (!jwk.getKeyId().isEmpty()) {
            jws.setKeyIdHeaderValue(jwk.getKeyId());
        }
        jws.setAlgorithmHeaderValue(jwk.getAlgorithm());
        jws.setKey((Key)jwk.getPrivateKey());
        jws.setHeader("jku", "https://localhost/jwks.json");
        jws.setAlgorithmConstraints(AlgorithmConstraints.NO_CONSTRAINTS);
        jws.setPayload(claims.toJson());
        return jws;
    }

    private static /* synthetic */ void lambda$testAsyncHttpsJwksVerificationKeyResolverShutdown$0(CloseableVerificationKeyResolver keyResolver) throws Throwable {
        keyResolver.resolveKey(ValidationKeyResolverTest.newRsaJws("k1"), Collections.emptyList());
    }

    private static /* synthetic */ void lambda$testJkuVerificationKeyShutdown$0(CloseableVerificationKeyResolver keyResolver) throws Throwable {
        keyResolver.resolveKey(ValidationKeyResolverTest.newRsaJws("k1"), Collections.emptyList());
    }

    private static /* synthetic */ void lambda$testJkuVerificationKeyInvalidDomain$1(VerificationKeyResolver keyResolver) throws Throwable {
        keyResolver.resolveKey(ValidationKeyResolverTest.newRsaJws("k1"), Collections.emptyList());
    }

    public static class MockHttpGet
    implements SimpleGet {
        private final TestJwkProvider jwks;

        public MockHttpGet(TestJwkProvider jwks) {
            this.jwks = jwks;
        }

        public SimpleResponse get(String location) {
            return new Response(200, "OK", Collections.singletonMap("Content-Type", Collections.singletonList("application/json")), this.jwks.getJsonWebKeySet().toJson());
        }
    }
}

