/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.MultiTenantConfigRestrictions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class MultiTenantConfigRestrictionsTest {
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testVisibleTopicConfigs(boolean schemaValidationEnabled) {
        Assertions.assertTrue((boolean)MultiTenantConfigRestrictions.visibleTopicConfig((String)"confluent.topic.type", (boolean)schemaValidationEnabled));
        Assertions.assertEquals((Object)schemaValidationEnabled, (Object)MultiTenantConfigRestrictions.visibleTopicConfig((String)"confluent.key.schema.validation", (boolean)schemaValidationEnabled));
        Assertions.assertEquals((Object)schemaValidationEnabled, (Object)MultiTenantConfigRestrictions.visibleTopicConfig((String)"confluent.key.subject.name.strategy", (boolean)schemaValidationEnabled));
        Assertions.assertEquals((Object)schemaValidationEnabled, (Object)MultiTenantConfigRestrictions.visibleTopicConfig((String)"confluent.value.schema.validation", (boolean)schemaValidationEnabled));
        Assertions.assertEquals((Object)schemaValidationEnabled, (Object)MultiTenantConfigRestrictions.visibleTopicConfig((String)"confluent.value.subject.name.strategy", (boolean)schemaValidationEnabled));
        Assertions.assertEquals((Object)schemaValidationEnabled, (Object)MultiTenantConfigRestrictions.visibleTopicConfig((String)"confluent.schema.validation.context.name", (boolean)schemaValidationEnabled));
        Assertions.assertFalse((boolean)MultiTenantConfigRestrictions.visibleTopicConfig((String)"confluent.tier.cleaner.enable", (boolean)schemaValidationEnabled));
    }

    @Test
    public void testUpdatableFreightTopicConfigs() {
        Assertions.assertTrue((boolean)MultiTenantConfigRestrictions.updatableFreightTopicConfig((String)"cleanup.policy"));
        Assertions.assertTrue((boolean)MultiTenantConfigRestrictions.updatableFreightTopicConfig((String)"retention.bytes"));
        Assertions.assertTrue((boolean)MultiTenantConfigRestrictions.updatableFreightTopicConfig((String)"retention.ms"));
        Assertions.assertTrue((boolean)MultiTenantConfigRestrictions.updatableFreightTopicConfig((String)"delete.retention.ms"));
        Assertions.assertTrue((boolean)MultiTenantConfigRestrictions.updatableFreightTopicConfig((String)"min.compaction.lag.ms"));
        Assertions.assertTrue((boolean)MultiTenantConfigRestrictions.updatableFreightTopicConfig((String)"message.timestamp.type"));
        Assertions.assertFalse((boolean)MultiTenantConfigRestrictions.updatableFreightTopicConfig((String)"segment.ms"));
        Assertions.assertFalse((boolean)MultiTenantConfigRestrictions.updatableFreightTopicConfig((String)"segment.bytes"));
        Assertions.assertFalse((boolean)MultiTenantConfigRestrictions.updatableFreightTopicConfig((String)"max.compaction.lag.ms"));
        Assertions.assertFalse((boolean)MultiTenantConfigRestrictions.updatableFreightTopicConfig((String)"min.cleanable.dirty.ratio"));
        Assertions.assertFalse((boolean)MultiTenantConfigRestrictions.updatableFreightTopicConfig((String)"min.insync.replicas"));
    }
}

