/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.MultiTenantInterceptorConfig;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class MultiTenantInterceptorConfigTest {
    private static final Map<String, Object> BASE_CONFIGS = Map.of("broker.id", 1, "confluent.multitenant.listener.hostname.cluster.prefix.enable", false, "confluent.schema.validator.multitenant.enable", true, "confluent.multitenant.interceptor.balancer.apis.enabled", true, "confluent.multitenant.listener.hostname.subdomain.suffix.enable", true, "confluent.subdomain.separator.map", "us-west-1.aws.private.glb.confluent.cloud:-, default:.", "confluent.fetch.from.follower.require.leader.epoch.enable", true, "confluent.ppv2.endpoint.scheme.enable", false);

    @Test
    public void constructorCorrectlyParsedTheConfig() {
        MultiTenantInterceptorConfig config = MultiTenantInterceptorConfig.fromConfigMap(BASE_CONFIGS);
        Assertions.assertFalse((boolean)config.isClusterPrefixForHostnameEnabled());
        Assertions.assertTrue((boolean)config.isSchemaValidationEnabled());
        Assertions.assertTrue((boolean)config.sbcApisEnabled());
        Assertions.assertTrue((boolean)config.shouldAppendSubdomainToHostname());
        Assertions.assertEquals((Object)"-", config.subdomainSeparatorMap().get("us-west-1.aws.private.glb.confluent.cloud"));
        Assertions.assertEquals((Object)".", config.subdomainSeparatorMap().get("default"));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testZoneTaggedRequestMetricsEnabled(boolean zoneTaggedRequestMetricsEnabled) {
        MultiTenantInterceptorConfig baseConfig = MultiTenantInterceptorConfig.fromConfigMap(BASE_CONFIGS);
        Assertions.assertEquals((Object)false, (Object)baseConfig.zoneTaggedRequestMetricsEnabled());
        HashMap<String, Object> configs = new HashMap<String, Object>(BASE_CONFIGS);
        configs.put("confluent.zone.tagged.request.metrics.enable", zoneTaggedRequestMetricsEnabled);
        MultiTenantInterceptorConfig config = MultiTenantInterceptorConfig.fromConfigMap(configs);
        Assertions.assertEquals((Object)zoneTaggedRequestMetricsEnabled, (Object)config.zoneTaggedRequestMetricsEnabled());
    }
}

