/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.server.plugins.auth.DefaultDataPolicyContext;
import io.confluent.kafka.server.plugins.auth.DefaultDataPolicyValidationMode;
import java.util.Optional;
import org.apache.kafka.common.security.authenticator.SaslInternalConfigs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultDataPolicyValidationModeTest {
    @Test
    public void fromStringTest() {
        Assertions.assertEquals((Object)DefaultDataPolicyValidationMode.NONE, (Object)DefaultDataPolicyValidationMode.fromString(null), (String)"Should return none if input is null");
        Assertions.assertEquals((Object)DefaultDataPolicyValidationMode.NONE, (Object)DefaultDataPolicyValidationMode.fromString((String)"foo"), (String)"Should return none if input is not recognized");
        Assertions.assertEquals((Object)DefaultDataPolicyValidationMode.NONE, (Object)DefaultDataPolicyValidationMode.fromString((String)DefaultDataPolicyValidationMode.NONE.name()), (String)"Should parse none successfully");
        Assertions.assertEquals((Object)DefaultDataPolicyValidationMode.STRICT, (Object)DefaultDataPolicyValidationMode.fromString((String)DefaultDataPolicyValidationMode.STRICT.name()), (String)"Should parse strict successfully");
        Assertions.assertEquals((Object)DefaultDataPolicyValidationMode.STRICT, (Object)DefaultDataPolicyValidationMode.fromString((String)"strict"), (String)"Should parse strict successfully");
    }

    @Test
    public void testNoneAllowsEverything() {
        DefaultDataPolicyContext policyContext = new DefaultDataPolicyContext.Builder().build();
        Assertions.assertTrue((boolean)DefaultDataPolicyValidationMode.NONE.trafficAllowed(true, Optional.empty(), policyContext));
        Assertions.assertTrue((boolean)DefaultDataPolicyValidationMode.NONE.trafficAllowed(false, Optional.empty(), policyContext));
    }

    @Test
    public void testStrictAllows() {
        Assertions.assertTrue((boolean)DefaultDataPolicyValidationMode.STRICT.trafficAllowed(false, Optional.of("env-same"), new DefaultDataPolicyContext.Builder("env-same", SaslInternalConfigs.NetworkType.PRIVATE, Boolean.valueOf(true)).build()));
        Assertions.assertFalse((boolean)DefaultDataPolicyValidationMode.STRICT.trafficAllowed(true, Optional.of("env-same"), new DefaultDataPolicyContext.Builder("env-same", SaslInternalConfigs.NetworkType.PRIVATE, Boolean.valueOf(true)).build()));
        Assertions.assertFalse((boolean)DefaultDataPolicyValidationMode.STRICT.trafficAllowed(false, Optional.of("env-same"), new DefaultDataPolicyContext.Builder("env-different", SaslInternalConfigs.NetworkType.PRIVATE, Boolean.valueOf(true)).build()));
        Assertions.assertFalse((boolean)DefaultDataPolicyValidationMode.STRICT.trafficAllowed(false, Optional.of("env-same"), new DefaultDataPolicyContext.Builder().networkType(SaslInternalConfigs.NetworkType.PRIVATE).hasSslPeerCertificate(Boolean.valueOf(true)).build()));
        Assertions.assertFalse((boolean)DefaultDataPolicyValidationMode.STRICT.trafficAllowed(false, Optional.of("env-same"), new DefaultDataPolicyContext.Builder("env-same", SaslInternalConfigs.NetworkType.PUBLIC, Boolean.valueOf(true)).build()));
        Assertions.assertFalse((boolean)DefaultDataPolicyValidationMode.STRICT.trafficAllowed(false, Optional.of("env-same"), new DefaultDataPolicyContext.Builder("env-same", SaslInternalConfigs.NetworkType.NOT_SET, Boolean.valueOf(true)).build()));
        Assertions.assertFalse((boolean)DefaultDataPolicyValidationMode.STRICT.trafficAllowed(false, Optional.of("env-same"), new DefaultDataPolicyContext.Builder().organizationId("org-same").hasSslPeerCertificate(Boolean.valueOf(true)).build()));
        Assertions.assertFalse((boolean)DefaultDataPolicyValidationMode.STRICT.trafficAllowed(false, Optional.of("env-same"), new DefaultDataPolicyContext.Builder("env-same", SaslInternalConfigs.NetworkType.PRIVATE, Boolean.valueOf(false)).build()));
        Assertions.assertFalse((boolean)DefaultDataPolicyValidationMode.STRICT.trafficAllowed(false, Optional.of("env-same"), new DefaultDataPolicyContext.Builder().organizationId("org-same").networkType(SaslInternalConfigs.NetworkType.PRIVATE).build()));
    }
}

